/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.display.examplesupport;

import java.awt.Dimension;

public class BoundingBox {
    private double minX = Double.MAX_VALUE;
    private double maxX = Double.NEGATIVE_INFINITY;
    private double minY = Double.MAX_VALUE;
    private double maxY = Double.NEGATIVE_INFINITY;

    public BoundingBox() {
    }

    public BoundingBox(Dimension d) {
        this(d.getWidth(), d.getHeight());
    }

    public BoundingBox(double width, double height) {
        this.minX = 0.0;
        this.minY = 0.0;
        this.maxX = width;
        this.maxY = height;
    }

    public BoundingBox(double minX, double maxX, double minY, double maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMinY() {
        return this.minY;
    }

    public boolean isEmpty() {
        return this.minX == Double.MAX_VALUE || this.minY == Double.MIN_VALUE;
    }

    public void debug() {
        assert (this.maxX >= this.minX);
        System.out.println(this.maxX + " >= " + this.minX);
        assert (this.maxY >= this.minY);
        System.out.println(this.maxY + " >= " + this.minY);
    }

    public void applyPoint(double x, double y) {
        if (x < this.minX) {
            this.minX = x;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
    }

    public boolean contains(double otherX, double otherY) {
        if (otherX < this.minX) {
            return false;
        }
        if (otherX > this.maxX) {
            return false;
        }
        if (otherY < this.minY) {
            return false;
        }
        return !(otherY > this.maxY);
    }

    public boolean contains(BoundingBox otherBox) {
        if (otherBox.minX < this.minX) {
            return false;
        }
        if (otherBox.minY < this.minY) {
            return false;
        }
        if (otherBox.maxX > this.maxX) {
            return false;
        }
        return !(otherBox.maxY > this.maxY);
    }

    public double transformX(BoundingBox fromSpace, double x) {
        double myWidth = this.maxX - this.minX;
        double fromWidth = fromSpace.maxX - fromSpace.minX;
        double rval = (x - fromSpace.minX) * myWidth / fromWidth + this.minX;
        return rval;
    }

    public double transformY(BoundingBox fromSpace, double y) {
        double myHeight = this.maxY - this.minY;
        double fromHeight = fromSpace.maxY - fromSpace.minY;
        return (y - fromSpace.minY) * myHeight / fromHeight + this.minY;
    }

    public String toString() {
        return "[box] minX: " + this.minX + "; maxX: " + this.maxX + "; minY: " + this.minY + "; maxY: " + this.maxY;
    }
}

