/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.display.examplesupport;

import com.metsci.glimpse.charts.vector.display.examplesupport.SelectedShapeChange;
import com.metsci.glimpse.charts.vector.display.examplesupport.UpdateListener;
import com.metsci.glimpse.charts.vector.parser.objects.GeoObject;
import com.metsci.glimpse.charts.vector.parser.objects.GeoShape;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class AttributePanel<V extends GeoObject>
extends JPanel
implements UpdateListener<SelectedShapeChange<V>> {
    private JTextArea textArea;

    public AttributePanel() {
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        JScrollPane scroll = new JScrollPane(this.textArea);
        this.add((Component)scroll, "Center");
    }

    public UpdateListener<SelectedShapeChange<V>> getSelectedShapeListener() {
        return this;
    }

    @Override
    public void updateOccurred(SelectedShapeChange<V> ssc) {
        this.newShape(ssc.getIndexInFile(), ssc.getGeoObject());
    }

    private void newShape(int indexInFile, V geoObject) {
        StringBuilder sb = new StringBuilder();
        sb.append(geoObject.toString());
        Collection<? extends GeoShape> shapeList = geoObject.getGeoShapes();
        for (GeoShape geoShape : shapeList) {
            int pointSize = geoShape.getPointSize();
            sb.append("\nShape: ").append((Object)geoShape.getShapeType()).append("; pt size: ").append(pointSize).append("; ").append(geoShape.getNumCoordinates()).append(" points").append("\n");
            int coordCount = geoShape.getNumCoordinates();
            for (int i = 0; i < coordCount; ++i) {
                sb.append("\tlat,lon: ");
                sb.append(geoShape.getVertex(1, i));
                sb.append(", ");
                sb.append(geoShape.getVertex(0, i));
                for (int d = 2; d < pointSize; ++d) {
                    sb.append(", ");
                    sb.append(geoShape.getVertex(d, i));
                }
                sb.append("\n");
            }
        }
        this.textArea.setText(sb.toString());
        this.textArea.setCaretPosition(0);
    }
}

