/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.display;

import com.metsci.glimpse.charts.vector.display.ContentHandler;
import com.metsci.glimpse.charts.vector.display.GeoContext;
import com.metsci.glimpse.charts.vector.display.xmlgen.TrackPainterSpec;
import com.metsci.glimpse.charts.vector.painter.EncPainterUtils;
import com.metsci.glimpse.charts.vector.parser.objects.GeoFeatureType;
import com.metsci.glimpse.charts.vector.parser.objects.GeoObject;
import com.metsci.glimpse.charts.vector.parser.objects.GeoShape;
import com.metsci.glimpse.charts.vector.parser.objects.GeoShapeType;
import com.metsci.glimpse.painter.track.Point;
import com.metsci.glimpse.painter.track.TrackPainter;
import com.metsci.glimpse.util.geo.projection.GeoProjection;
import java.util.List;

public class TrackHandler<V extends GeoObject>
implements ContentHandler<V> {
    private static final GeoShapeType[] shapeTypes = GeoShapeType.values();
    private static final int defaultStippleFactor = 1;
    private static final short defaultStipplePattern = 255;
    private TrackPainterSpec spec;
    private int trackIdOffset = 0;
    private int trackIdFactor = -1;

    public TrackHandler() {
        this(new TrackPainterSpec());
    }

    public TrackHandler(TrackPainterSpec spec) {
        this.spec = spec;
    }

    private int determineGroupId(GeoFeatureType objectType, GeoShapeType shapeType) {
        return objectType.ordinal() + (shapeType.ordinal() + shapeTypes.length);
    }

    @Override
    public Integer getScaleMin(V object) {
        return null;
    }

    @Override
    public void paintEnc(GeoContext geoContext, V object) {
        GeoShape shape = object.getGeoShapes().iterator().next();
        int groupId = this.determineGroupId(object.getGeoFeatureType(), shape.getShapeType());
        if (this.trackIdFactor < 0) {
            this.trackIdFactor = Integer.MAX_VALUE / (object.getGeoFeatureType().getNumFeatures() * shapeTypes.length);
        }
        int trackId = this.trackIdFactor * groupId + this.trackIdOffset++;
        TrackPainter trackPainter = geoContext.getTrackPainter();
        this.initializeGroupPainterSettings(trackId, trackPainter);
        GeoProjection projection = geoContext.getProjection();
        List<Point> points = EncPainterUtils.convertGeoVertexesToPoints(projection, shape, trackId);
        if (!points.isEmpty()) {
            trackPainter.addPoints(trackId, points);
        }
    }

    @Override
    public void reset() {
        this.trackIdOffset = 0;
    }

    private void initializeGroupPainterSettings(int trackId, TrackPainter trackPainter) {
        if (this.spec.isShowLines() != null) {
            trackPainter.setShowLines(trackId, this.spec.isShowLines().booleanValue());
        }
        if (this.spec.getLineColor() != null) {
            trackPainter.setLineColor(trackId, EncPainterUtils.convertColorSpecToFloatArray(this.spec.getLineColor()));
        }
        if (this.spec.getLineWidth() != null) {
            trackPainter.setLineWidth(trackId, this.spec.getLineWidth().floatValue());
        }
        if (this.spec.isShowPoints() != null) {
            trackPainter.setShowPoints(trackId, this.spec.isShowPoints().booleanValue());
        }
        if (this.spec.getPointColor() != null) {
            trackPainter.setPointColor(trackId, EncPainterUtils.convertColorSpecToFloatArray(this.spec.getPointColor()));
        }
        if (this.spec.getPointSize() != null) {
            trackPainter.setPointSize(trackId, this.spec.getPointSize().floatValue());
        }
        if (this.spec.isDotted() != null) {
            boolean isDotted = this.spec.isDotted();
            trackPainter.setDotted(trackId, isDotted);
            if (isDotted) {
                int stippleFactor = 1;
                if (this.spec.getStippleFactor() != null) {
                    stippleFactor = this.spec.getStippleFactor();
                }
                short stipplePattern = 255;
                if (this.spec.getStipplePattern() != null) {
                    stipplePattern = this.spec.getStipplePattern();
                }
                trackPainter.setDotted(trackId, stippleFactor, stipplePattern);
            }
        }
        if (this.spec.isShowLabel() != null) {
            boolean isShowLabel = this.spec.isShowLabel();
            trackPainter.setShowLabel(trackId, isShowLabel);
            if (isShowLabel) {
                if (this.spec.getLabel() != null) {
                    trackPainter.setLabel(trackId, this.spec.getLabel());
                }
                if (this.spec.getLabelColor() != null) {
                    trackPainter.setLabelColor(trackId, EncPainterUtils.convertColorSpecToFloatArray(this.spec.getLabelColor()));
                }
            }
        }
        if (this.spec.isShowLabelLine() != null) {
            boolean showLabelLine = this.spec.isShowLabelLine();
            trackPainter.setShowLabelLine(trackId, showLabelLine);
            if (showLabelLine && this.spec.getLabelLineColor() != null) {
                trackPainter.setLabelLineColor(trackId, EncPainterUtils.convertColorSpecToFloatArray(this.spec.getLabelLineColor()));
            }
        }
        if (this.spec.isShowHeadPoint() != null) {
            boolean showHeadPoint = this.spec.isShowHeadPoint();
            trackPainter.setShowHeadPoint(trackId, showHeadPoint);
            if (showHeadPoint) {
                if (this.spec.getHeadPointSize() != null) {
                    trackPainter.setHeadPointSize(trackId, this.spec.getHeadPointSize().floatValue());
                }
                if (this.spec.getHeadPointColor() != null) {
                    trackPainter.setHeadPointColor(trackId, EncPainterUtils.convertColorSpecToFloatArray(this.spec.getHeadPointColor()));
                }
            }
        }
    }

    public void setHeadPointColor(float r, float g, float b, float a) {
        this.spec.setHeadPointColor(EncPainterUtils.convertFloatsToColorSpec(r, g, b, a));
    }

    public void setHeadPointSize(float size) {
        this.spec.setHeadPointSize(Float.valueOf(size));
    }

    public void setShowHeadPoint(boolean show) {
        this.spec.setShowHeadPoint(show);
    }

    public void setPointColor(float r, float g, float b, float a) {
        this.spec.setPointColor(EncPainterUtils.convertFloatsToColorSpec(r, g, b, a));
    }

    public void setPointColor(float[] color) {
        this.spec.setPointColor(EncPainterUtils.convertFloatArrayToColorSpec(color));
    }

    public void setPointSize(float size) {
        this.spec.setPointSize(Float.valueOf(size));
    }

    public void setShowPoints(boolean show) {
        this.spec.setShowPoints(show);
    }

    public void setLineColor(float r, float g, float b, float a) {
        this.spec.setLineColor(EncPainterUtils.convertFloatsToColorSpec(r, g, b, a));
    }

    public void setLineColor(float[] color) {
        this.spec.setLineColor(EncPainterUtils.convertFloatArrayToColorSpec(color));
    }

    public void setLineWidth(float width) {
        this.spec.setLineWidth(Float.valueOf(width));
    }

    public void setShowLines(boolean show) {
        this.spec.setShowLines(show);
    }

    public void setDotted(boolean activate) {
        this.spec.setDotted(activate);
    }

    public void setDotted(int stippleFactor, short stipplePattern) {
        this.spec.setDotted(Boolean.TRUE);
        this.spec.setStippleFactor(stippleFactor);
        this.spec.setStipplePattern(stipplePattern);
    }

    public void setLabelColor(float r, float g, float b, float a) {
        this.spec.setLabelColor(EncPainterUtils.convertFloatsToColorSpec(r, g, b, a));
    }

    public void setLabelLineColor(float r, float g, float b, float a) {
        this.spec.setLabelLineColor(EncPainterUtils.convertFloatsToColorSpec(r, g, b, a));
    }

    public void setShowLabelLine(boolean show) {
        this.spec.setShowLabelLine(show);
    }

    public void setLabel(String label) {
        this.spec.setLabel(label);
    }

    public void setShowLabel(boolean show) {
        this.spec.setShowLabel(show);
    }
}

