/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.display;

import com.metsci.glimpse.charts.vector.display.ContentHandler;
import com.metsci.glimpse.charts.vector.display.GeoContext;
import com.metsci.glimpse.charts.vector.display.xmlgen.PolygonPainterSpec;
import com.metsci.glimpse.charts.vector.painter.EncPainterUtils;
import com.metsci.glimpse.charts.vector.parser.objects.GeoFeatureType;
import com.metsci.glimpse.charts.vector.parser.objects.GeoObject;
import com.metsci.glimpse.charts.vector.parser.objects.GeoShape;
import com.metsci.glimpse.painter.shape.PolygonPainter;
import com.metsci.glimpse.support.polygon.Polygon;
import com.metsci.glimpse.util.geo.projection.GeoProjection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class PolygonHandler<V extends GeoObject>
implements ContentHandler<V> {
    private static final int defaultLineStippleFactor = 1;
    private static final short defaultLineStipplePattern = 255;
    private PolygonPainterSpec polygonGroupAttributes;
    private Set<GeoFeatureType> groupInitSet = new HashSet<GeoFeatureType>();
    private int polyId = 0;

    public PolygonHandler() {
        this(new PolygonPainterSpec());
    }

    public PolygonHandler(PolygonPainterSpec spec) {
        assert (spec != null);
        if (spec == null) {
            throw new AssertionError();
        }
        this.polygonGroupAttributes = spec;
    }

    private int determineGroupId(GeoFeatureType objectType) {
        return objectType.ordinal();
    }

    @Override
    public void paintEnc(GeoContext encContext, V object) {
        Collection<? extends GeoShape> shapeList = object.getGeoShapes();
        if (shapeList.isEmpty()) {
            return;
        }
        PolygonPainter polygonPainter = encContext.getPolyPainter();
        GeoProjection projection = encContext.getProjection();
        GeoFeatureType featureType = object.getGeoFeatureType();
        if (!this.groupInitSet.contains(featureType)) {
            this.initializeGroupPainterSettings(featureType.ordinal(), polygonPainter);
            this.groupInitSet.add(featureType);
        }
        Polygon polygon = EncPainterUtils.convertGeoVertexesToPolgon(projection, object);
        polygonPainter.addPolygon(featureType.ordinal(), this.polyId++, polygon, 1.0f);
    }

    @Override
    public Integer getScaleMin(V object) {
        return null;
    }

    @Override
    public void reset() {
        this.groupInitSet.clear();
        this.polyId = 0;
    }

    private void initializeGroupPainterSettings(int groupId, PolygonPainter polygonPainter) {
        if (this.polygonGroupAttributes.isShowLines() != null) {
            polygonPainter.setShowLines(groupId, this.polygonGroupAttributes.isShowLines().booleanValue());
        }
        if (this.polygonGroupAttributes.getLineColor() != null) {
            polygonPainter.setLineColor(groupId, EncPainterUtils.convertColorSpecToFloatArray(this.polygonGroupAttributes.getLineColor()));
        }
        if (this.polygonGroupAttributes.getLineWidth() != null) {
            polygonPainter.setLineWidth(groupId, (float)this.polygonGroupAttributes.getLineWidth().intValue());
        }
        if (this.polygonGroupAttributes.isLineDotted() != null) {
            boolean isLineDotted = this.polygonGroupAttributes.isLineDotted();
            polygonPainter.setLineDotted(groupId, isLineDotted);
            if (isLineDotted) {
                int lineStippleFactor = 1;
                if (this.polygonGroupAttributes.getLineStippleFactor() != null) {
                    lineStippleFactor = this.polygonGroupAttributes.getLineStippleFactor();
                }
                short lineStipplePattern = 255;
                if (this.polygonGroupAttributes.getLineStipplePattern() != null) {
                    lineStipplePattern = this.polygonGroupAttributes.getLineStipplePattern();
                }
                polygonPainter.setLineDotted(groupId, lineStippleFactor, lineStipplePattern);
            }
        }
        if (this.polygonGroupAttributes.isPolyDotted() != null) {
            boolean isPolyDotted = this.polygonGroupAttributes.isPolyDotted();
            polygonPainter.setPolyDotted(groupId, isPolyDotted);
            if (isPolyDotted && this.polygonGroupAttributes.getPolyStipplePattern() != null) {
                polygonPainter.setPolyDotted(groupId, this.polygonGroupAttributes.getPolyStipplePattern());
            }
        }
        if (this.polygonGroupAttributes.isFill() != null) {
            boolean isFill = this.polygonGroupAttributes.isFill();
            polygonPainter.setFill(groupId, isFill);
            if (isFill && this.polygonGroupAttributes.getFillColor() != null) {
                polygonPainter.setFillColor(groupId, EncPainterUtils.convertColorSpecToFloatArray(this.polygonGroupAttributes.getFillColor()));
            }
        }
    }

    public void setShowLines(boolean show) {
        this.polygonGroupAttributes.setShowLines(show);
    }

    public void setLineColor(float r, float g, float b, float a) {
        this.polygonGroupAttributes.setLineColor(EncPainterUtils.convertFloatsToColorSpec(r, g, b, a));
    }

    public void setLineColor(float[] rgba) {
        this.polygonGroupAttributes.setLineColor(EncPainterUtils.convertFloatArrayToColorSpec(rgba));
    }

    public void setLineWidth(int width) {
        this.polygonGroupAttributes.setLineWidth(width);
    }

    public void setPolyDotted(byte[] stipple) {
        this.polygonGroupAttributes.setPolyStipplePattern(stipple);
    }

    public void setPolyDotted(boolean dotted) {
        this.polygonGroupAttributes.setPolyDotted(dotted);
    }

    public void setLineDotted(boolean dotted) {
        this.polygonGroupAttributes.setLineDotted(dotted);
    }

    public void setLineDotted(int stippleFactor, short stipplePattern) {
        this.polygonGroupAttributes.setLineStippleFactor(stippleFactor);
        this.polygonGroupAttributes.setLineStipplePattern(stipplePattern);
    }

    public void setFill(boolean show) {
        this.polygonGroupAttributes.setFill(show);
    }

    public void setFillColor(float r, float g, float b, float a) {
        this.polygonGroupAttributes.setFillColor(EncPainterUtils.convertFloatsToColorSpec(r, g, b, a));
    }

    public void setFillColor(float[] rgba) {
        this.polygonGroupAttributes.setFillColor(EncPainterUtils.convertFloatArrayToColorSpec(rgba));
    }
}

