/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.display;

import com.metsci.glimpse.charts.vector.display.ColorPalette;
import com.metsci.glimpse.charts.vector.display.xmlgen.ColorSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.FeatureSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.Geoskinspec;
import com.metsci.glimpse.charts.vector.display.xmlgen.PolygonPainterSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.ShapeSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.ShapeTypeSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.TrackPainterSpec;
import com.metsci.glimpse.charts.vector.painter.EncPainterUtils;
import com.metsci.glimpse.charts.vector.parser.objects.ENCObjectType;
import java.util.List;
import java.util.logging.Logger;

public class HardCodedENCSkinSpecFactory {
    private static Logger logger = Logger.getLogger(HardCodedENCSkinSpecFactory.class.toString());
    private ColorPalette colorPalette;

    public HardCodedENCSkinSpecFactory(ColorPalette colorPalette) {
        this.colorPalette = colorPalette;
    }

    public Geoskinspec createSkinSpec() {
        Geoskinspec skinSpec = new Geoskinspec();
        List<FeatureSpec> encList = skinSpec.getFeature();
        encList.add(this.addCoastlineHandlers());
        encList.add(this.addDepthContourHandlers());
        encList.add(this.addDepthAreaHandlers());
        encList.add(this.addLandAreaHandlers());
        encList.add(this.addSeaAreaNamedWaterAreaHandler());
        encList.add(this.addCoverageSpec());
        return skinSpec;
    }

    private FeatureSpec addCoastlineHandlers() {
        TrackPainterSpec trackSpec = this.createDefaultTrackHandlerForLinestringType();
        trackSpec.setShowPoints(false);
        trackSpec.setLineColor(EncPainterUtils.convertFloatArrayToColorSpec(this.colorPalette.getCoastlineLineColor(0.5f)));
        ShapeSpec shape = EncPainterUtils.createShape(ShapeTypeSpec.LINESTRING, trackSpec);
        return EncPainterUtils.createEnc(ENCObjectType.Coastline.name(), shape, new ShapeSpec[0]);
    }

    private FeatureSpec addDepthContourHandlers() {
        TrackPainterSpec trackSpec = this.createDefaultTrackHandlerForLinestringType();
        trackSpec.setShowPoints(false);
        trackSpec.setDotted(true);
        trackSpec.setStipplePattern((short)21845);
        trackSpec.setStippleFactor(1);
        trackSpec.setLineColor(EncPainterUtils.convertFloatArrayToColorSpec(this.colorPalette.getDepthLineColor(0.5f)));
        ShapeSpec shape = EncPainterUtils.createShape(ShapeTypeSpec.LINESTRING, trackSpec);
        return EncPainterUtils.createEnc(ENCObjectType.DepthContour.name(), shape, new ShapeSpec[0]);
    }

    private FeatureSpec addDepthAreaHandlers() {
        PolygonPainterSpec polygonSpec = this.createDefaultPolygonHandlerForPolygonType();
        polygonSpec.setPolyDotted(Boolean.TRUE);
        polygonSpec.setLineColor(EncPainterUtils.convertFloatArrayToColorSpec(this.colorPalette.getDepthLineColor(0.5f)));
        ShapeSpec shape = EncPainterUtils.createShape(ShapeTypeSpec.POLYGON, polygonSpec);
        TrackPainterSpec trackSpec = this.createDefaultTrackHandlerForLinestringType();
        trackSpec.setDotted(Boolean.TRUE);
        trackSpec.setLineColor(EncPainterUtils.convertFloatArrayToColorSpec(this.colorPalette.getDepthLineColor(0.5f)));
        trackSpec.setShowPoints(Boolean.FALSE);
        ShapeSpec shape2 = EncPainterUtils.createShape(ShapeTypeSpec.LINESTRING, trackSpec);
        return EncPainterUtils.createEnc(ENCObjectType.DepthArea.name(), shape, shape2);
    }

    private FeatureSpec addLandAreaHandlers() {
        PolygonPainterSpec polySpec = this.createDefaultPolygonHandlerForPolygonType();
        float[] landColorRgba = this.colorPalette.getLandColor(0.2f);
        ColorSpec landColor = EncPainterUtils.convertFloatArrayToColorSpec(landColorRgba);
        polySpec.setFill(Boolean.TRUE);
        polySpec.setFillColor(landColor);
        polySpec.setShowLines(Boolean.FALSE);
        ShapeSpec polyShape = EncPainterUtils.createShape(ShapeTypeSpec.POLYGON, polySpec);
        TrackPainterSpec trackSpec = this.createDefaultTrackHandlerForPointType();
        trackSpec.setPointColor(landColor);
        ShapeSpec pointShape = EncPainterUtils.createShape(ShapeTypeSpec.POINT, trackSpec);
        FeatureSpec enc = EncPainterUtils.createEnc(ENCObjectType.LandArea.name(), polyShape, pointShape);
        enc.getFeaturetype().add(ENCObjectType.LandRegion.name());
        return enc;
    }

    private FeatureSpec addSeaAreaNamedWaterAreaHandler() {
        PolygonPainterSpec polySpec = this.createDefaultPolygonHandlerForPolygonType();
        polySpec.setFill(true);
        float[] waterBlueRgba = this.colorPalette.getWaterColor(0.2f);
        ColorSpec waterBlueColor = EncPainterUtils.convertFloatArrayToColorSpec(waterBlueRgba);
        polySpec.setFillColor(waterBlueColor);
        polySpec.setShowLines(Boolean.FALSE);
        ShapeSpec polyShape = EncPainterUtils.createShape(ShapeTypeSpec.POLYGON, polySpec);
        return EncPainterUtils.createEnc(ENCObjectType.SeaAreaNamedWaterArea.name(), polyShape, new ShapeSpec[0]);
    }

    private FeatureSpec addCoverageSpec() {
        PolygonPainterSpec polySpec = this.createDefaultPolygonHandlerForPolygonType();
        polySpec.setLineColor(EncPainterUtils.convertFloatArrayToColorSpec(this.colorPalette.getCoverageLineColor(0.8f)));
        polySpec.setLineDotted(Boolean.TRUE);
        ShapeSpec polyShape = EncPainterUtils.createShape(ShapeTypeSpec.POLYGON, polySpec);
        return EncPainterUtils.createEnc(ENCObjectType.Coverage.name(), polyShape, new ShapeSpec[0]);
    }

    private PolygonPainterSpec createDefaultPolygonHandlerForPolygonType() {
        return new PolygonPainterSpec();
    }

    private TrackPainterSpec createDefaultTrackHandlerForLinestringType() {
        TrackPainterSpec trackPainterSpec = new TrackPainterSpec();
        trackPainterSpec.setShowLines(Boolean.TRUE);
        return trackPainterSpec;
    }

    private TrackPainterSpec createDefaultTrackHandlerForMultiPointType() {
        return this.createDefaultTrackHandlerForPointType();
    }

    private TrackPainterSpec createDefaultTrackHandlerForPointType() {
        TrackPainterSpec trackPainterSpec = new TrackPainterSpec();
        trackPainterSpec.setShowLines(Boolean.FALSE);
        return trackPainterSpec;
    }
}

