/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.display;

import com.metsci.glimpse.charts.vector.display.ColorPalette;
import com.metsci.glimpse.charts.vector.display.xmlgen.ColorSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.FeatureSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.Geoskinspec;
import com.metsci.glimpse.charts.vector.display.xmlgen.PolygonPainterSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.ShapeSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.ShapeTypeSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.TrackPainterSpec;
import com.metsci.glimpse.charts.vector.painter.EncPainterUtils;
import com.metsci.glimpse.charts.vector.parser.objects.DNCFeatureCode;
import java.util.List;
import java.util.logging.Logger;

public class HardCodedDNCSkinSpecFactory {
    private static Logger logger = Logger.getLogger(HardCodedDNCSkinSpecFactory.class.toString());
    private ColorPalette colorPalette;

    public HardCodedDNCSkinSpecFactory(ColorPalette colorPalette) {
        this.colorPalette = colorPalette;
    }

    public Geoskinspec createSkinSpec() {
        Geoskinspec skinSpec = new Geoskinspec();
        List<FeatureSpec> dncList = skinSpec.getFeature();
        dncList.add(this.addCoastlineHandlers());
        dncList.add(this.addDepthContourHandlers());
        dncList.add(this.addDepthAreaHandlers());
        dncList.add(this.addLandAreaHandlers());
        dncList.add(this.addWaterandler());
        return skinSpec;
    }

    private FeatureSpec addCoastlineHandlers() {
        TrackPainterSpec trackSpec = this.createDefaultTrackHandlerForLinestringType();
        trackSpec.setShowPoints(false);
        trackSpec.setLineColor(EncPainterUtils.convertFloatArrayToColorSpec(this.colorPalette.getCoastlineLineColor(0.5f)));
        ShapeSpec shape = EncPainterUtils.createShape(ShapeTypeSpec.LINESTRING, trackSpec);
        return EncPainterUtils.createEnc(new String[]{DNCFeatureCode.Coastline.code(), DNCFeatureCode.CoastlineShoreline.code()}, shape, new ShapeSpec[0]);
    }

    private FeatureSpec addDepthContourHandlers() {
        TrackPainterSpec trackSpec = this.createDefaultTrackHandlerForLinestringType();
        trackSpec.setShowPoints(false);
        trackSpec.setDotted(true);
        trackSpec.setStipplePattern((short)21845);
        trackSpec.setStippleFactor(1);
        trackSpec.setLineColor(EncPainterUtils.convertFloatArrayToColorSpec(this.colorPalette.getDepthLineColor(0.5f)));
        ShapeSpec shape = EncPainterUtils.createShape(ShapeTypeSpec.LINESTRING, trackSpec);
        return EncPainterUtils.createEnc(DNCFeatureCode.DepthContour.code(), shape, new ShapeSpec[0]);
    }

    private FeatureSpec addDepthAreaHandlers() {
        PolygonPainterSpec polygonSpec = this.createDefaultPolygonHandlerForPolygonType();
        polygonSpec.setPolyDotted(Boolean.TRUE);
        polygonSpec.setLineColor(EncPainterUtils.convertFloatArrayToColorSpec(this.colorPalette.getDepthLineColor(0.5f)));
        ShapeSpec shape = EncPainterUtils.createShape(ShapeTypeSpec.POLYGON, polygonSpec);
        TrackPainterSpec trackSpec = this.createDefaultTrackHandlerForLinestringType();
        trackSpec.setDotted(Boolean.TRUE);
        trackSpec.setLineColor(EncPainterUtils.convertFloatArrayToColorSpec(this.colorPalette.getDepthLineColor(0.5f)));
        trackSpec.setShowPoints(Boolean.FALSE);
        ShapeSpec shape2 = EncPainterUtils.createShape(ShapeTypeSpec.LINESTRING, trackSpec);
        return EncPainterUtils.createEnc(DNCFeatureCode.DepthArea.code(), shape, shape2);
    }

    private FeatureSpec addLandAreaHandlers() {
        PolygonPainterSpec polySpec = this.createDefaultPolygonHandlerForPolygonType();
        float[] landColorRgba = this.colorPalette.getLandColor(0.2f);
        ColorSpec landColor = EncPainterUtils.convertFloatArrayToColorSpec(landColorRgba);
        polySpec.setFill(Boolean.TRUE);
        polySpec.setFillColor(landColor);
        polySpec.setShowLines(Boolean.FALSE);
        ShapeSpec polyShape = EncPainterUtils.createShape(ShapeTypeSpec.POLYGON, polySpec);
        TrackPainterSpec trackSpec = this.createDefaultTrackHandlerForPointType();
        trackSpec.setPointColor(landColor);
        ShapeSpec pointShape = EncPainterUtils.createShape(ShapeTypeSpec.POINT, trackSpec);
        FeatureSpec enc = EncPainterUtils.createEnc(DNCFeatureCode.LandArea.code(), polyShape, pointShape);
        enc.getFeaturetype().add(DNCFeatureCode.LandRegion.code());
        return enc;
    }

    private FeatureSpec addWaterandler() {
        PolygonPainterSpec polySpec = this.createDefaultPolygonHandlerForPolygonType();
        polySpec.setFill(true);
        float[] waterBlueRgba = this.colorPalette.getWaterColor(0.2f);
        ColorSpec waterBlueColor = EncPainterUtils.convertFloatArrayToColorSpec(waterBlueRgba);
        polySpec.setFillColor(waterBlueColor);
        polySpec.setShowLines(Boolean.FALSE);
        ShapeSpec polyShape = EncPainterUtils.createShape(ShapeTypeSpec.POLYGON, polySpec);
        return EncPainterUtils.createEnc(DNCFeatureCode.Water.code(), polyShape, new ShapeSpec[0]);
    }

    private PolygonPainterSpec createDefaultPolygonHandlerForPolygonType() {
        return new PolygonPainterSpec();
    }

    private TrackPainterSpec createDefaultTrackHandlerForLinestringType() {
        TrackPainterSpec trackPainterSpec = new TrackPainterSpec();
        trackPainterSpec.setShowLines(Boolean.TRUE);
        return trackPainterSpec;
    }

    private TrackPainterSpec createDefaultTrackHandlerForMultiPointType() {
        return this.createDefaultTrackHandlerForPointType();
    }

    private TrackPainterSpec createDefaultTrackHandlerForPointType() {
        TrackPainterSpec trackPainterSpec = new TrackPainterSpec();
        trackPainterSpec.setShowLines(Boolean.FALSE);
        return trackPainterSpec;
    }
}

