/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.display;

import com.metsci.glimpse.charts.vector.display.BasicSkin;
import com.metsci.glimpse.charts.vector.display.BasicSkinHelper;
import com.metsci.glimpse.charts.vector.display.ColorPalette;
import com.metsci.glimpse.charts.vector.display.ContentHandler;
import com.metsci.glimpse.charts.vector.display.ENCAnnotationHandler;
import com.metsci.glimpse.charts.vector.display.HardCodedENCSkinSpecFactory;
import com.metsci.glimpse.charts.vector.display.Skin;
import com.metsci.glimpse.charts.vector.display.xmlgen.AnnotationPainterSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.EncAnnotationPainterSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.Geoskinspec;
import com.metsci.glimpse.charts.vector.iteration.ENCObjectLoader;
import com.metsci.glimpse.charts.vector.iteration.StreamToGeoObjectConverter;
import com.metsci.glimpse.charts.vector.parser.attributes.ENCEnumAttribute;
import com.metsci.glimpse.charts.vector.parser.autogen.ENCAttributeType;
import com.metsci.glimpse.charts.vector.parser.autogen.ENCAttributeValues;
import com.metsci.glimpse.charts.vector.parser.objects.ENCObject;
import com.metsci.glimpse.charts.vector.parser.objects.ENCObjectType;
import com.metsci.glimpse.charts.vector.parser.objects.GeoFeatureType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class ENCBasicSkinHelper
implements BasicSkinHelper<ENCObject> {
    private static Logger logger = Logger.getLogger(ENCBasicSkinHelper.class.toString());
    private static final Set<GeoFeatureType> bestMapBoundaryTypes = new HashSet<GeoFeatureType>();

    @Override
    public Schema getXsdSchema() throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        return schemaFactory.newSchema(this.getClass().getClassLoader().getResource("data/encskin.xsd"));
    }

    @Override
    public Skin<ENCObject> createDefaultHardCodedSkin() {
        return this.createDefaultHardCodedSkin(ColorPalette.createDefaultColorPalette());
    }

    @Override
    public Skin<ENCObject> createDefaultHardCodedSkin(ColorPalette colorPalette) {
        Geoskinspec skinSpec = new HardCodedENCSkinSpecFactory(colorPalette).createSkinSpec();
        return new BasicSkin<ENCObject>(new ENCBasicSkinHelper(), skinSpec);
    }

    @Override
    public ContentHandler<ENCObject> createAnnotationPainterSpec(AnnotationPainterSpec annotationSpec) {
        return new ENCAnnotationHandler((EncAnnotationPainterSpec)annotationSpec);
    }

    @Override
    public boolean isBestBoundaryType(ENCObject enc) {
        if (enc.getObjectType() == ENCObjectType.Coverage) {
            ENCEnumAttribute coverage = enc.getEnumAttribute(ENCAttributeType.CategoryOfCoverage);
            return coverage != null && coverage.getENCAttributeValue() == ENCAttributeValues.CategoryOfCoverage_CoverageAvailable;
        }
        return false;
    }

    @Override
    public boolean isSecondBestBoundaryType(ENCObject enc) {
        return bestMapBoundaryTypes.contains(enc.getObjectType());
    }

    @Override
    public StreamToGeoObjectConverter<ENCObject> createGeoObjectLoader() {
        return new ENCObjectLoader();
    }

    @Override
    public GeoFeatureType convertGeoFeatureType(String type) {
        return ENCObjectType.valueOf(type);
    }

    @Override
    public List<? extends GeoFeatureType> convertGeoFeatureType(List<String> featureTypeList) {
        ArrayList<ENCObjectType> realList = new ArrayList<ENCObjectType>(featureTypeList.size());
        for (String featureType : featureTypeList) {
            realList.add(this.internalConvertGeoFeatureType(featureType));
        }
        return realList;
    }

    @Override
    public String geoName() {
        return "ENC";
    }

    private ENCObjectType internalConvertGeoFeatureType(String type) {
        return ENCObjectType.valueOf(type);
    }

    static {
        bestMapBoundaryTypes.add(ENCObjectType.NauticalPublicationInformation);
        bestMapBoundaryTypes.add(ENCObjectType.NavigationalSystemOfMarks);
        bestMapBoundaryTypes.add(ENCObjectType.Coverage);
        bestMapBoundaryTypes.add(ENCObjectType.QualityOfData);
    }
}

