/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.display;

import com.metsci.glimpse.charts.vector.display.AnnotationHandler;
import com.metsci.glimpse.charts.vector.display.ContentHandler;
import com.metsci.glimpse.charts.vector.display.xmlgen.EncAnnotationPainterSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.EncAttributeTypeSpec;
import com.metsci.glimpse.charts.vector.parser.attributes.ENCIntAttribute;
import com.metsci.glimpse.charts.vector.parser.autogen.ENCAttributeType;
import com.metsci.glimpse.charts.vector.parser.objects.ENCObject;
import com.metsci.glimpse.charts.vector.parser.objects.GeoAttributeType;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ENCAnnotationHandler
extends AnnotationHandler<ENCObject>
implements ContentHandler<ENCObject> {
    private static Logger logger = Logger.getLogger(ENCAnnotationHandler.class.toString());
    private GeoAttributeType attributeTypeToAnnotate;

    public ENCAnnotationHandler() {
        this(new EncAnnotationPainterSpec());
    }

    public ENCAnnotationHandler(EncAnnotationPainterSpec spec) {
        super(spec);
        EncAttributeTypeSpec attributeTypeSpec = spec.getAttributeKey();
        if (attributeTypeSpec == null) {
            logger.log(Level.WARNING, "XML has missing or invalid ENCAttributeTypeSpec for EncAnnotationPainterSpec");
            return;
        }
        this.attributeTypeToAnnotate = ENCAttributeType.valueOf(attributeTypeSpec.value());
    }

    @Override
    public GeoAttributeType getAttributeTypeToAnnotate() {
        return this.attributeTypeToAnnotate;
    }

    @Override
    public Integer getScaleMin(ENCObject object) {
        ENCIntAttribute attributeValue = object.getIntAttribute(ENCAttributeType.ScaleMinimum);
        if (attributeValue != null && !attributeValue.isNullValued()) {
            return attributeValue.getAttributeValue();
        }
        return null;
    }
}

