/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.display;

import com.metsci.glimpse.charts.vector.display.ContentHandler;
import com.metsci.glimpse.charts.vector.display.PolygonHandler;
import com.metsci.glimpse.charts.vector.display.Skin;
import com.metsci.glimpse.charts.vector.display.TrackHandler;
import com.metsci.glimpse.charts.vector.parser.objects.ENCShape;
import com.metsci.glimpse.charts.vector.parser.objects.GeoObject;
import com.metsci.glimpse.charts.vector.parser.objects.GeoShape;
import com.metsci.glimpse.charts.vector.parser.objects.GeoShapeType;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.logging.Logger;

public class DummySkin<V extends GeoObject>
implements Skin<V> {
    private static Logger logger = Logger.getLogger(DummySkin.class.toString());
    private EnumMap<GeoShapeType, ContentHandler<V>> lookupMap;
    private Color color;

    public DummySkin() {
        this(Color.gray);
    }

    public DummySkin(Color color) {
        this.color = color;
        this.reset();
    }

    public ContentHandler<V> getHandlerForShape(V geoObject, ENCShape shape, int shapeIndex) {
        return this.lookupMap.get((Object)shape.getShapeType());
    }

    @Override
    public List<ContentHandler<V>> getHandlersForGeoObject(V geoObject) {
        Collection<? extends GeoShape> shapeList = geoObject.getGeoShapes();
        if (shapeList.isEmpty()) {
            return Collections.emptyList();
        }
        ContentHandler<V> singleHandler = this.lookupMap.get((Object)geoObject.getFirstGeoShape().getShapeType());
        return Collections.singletonList(singleHandler);
    }

    @Override
    public void reset() {
        this.lookupMap = new EnumMap(GeoShapeType.class);
        this.lookupMap.put(GeoShapeType.Polygon, this.createDefaultPolygonHandlerForPolygonType());
        this.lookupMap.put(GeoShapeType.Linestring, this.createDefaultTrackHandlerForLinestringType());
        this.lookupMap.put(GeoShapeType.Point, this.createDefaultTrackHandlerForPointType());
        this.lookupMap.put(GeoShapeType.Multipoint, this.createDefaultTrackHandlerForMultiPointType());
    }

    private PolygonHandler<V> createDefaultPolygonHandlerForPolygonType() {
        PolygonHandler polygonHandler = new PolygonHandler();
        polygonHandler.setShowLines(Boolean.TRUE);
        polygonHandler.setFill(true);
        polygonHandler.setFillColor(1.0f, 0.0f, 0.0f, 0.25f);
        polygonHandler.setLineColor(this.color.getComponents(null));
        return polygonHandler;
    }

    private TrackHandler<V> createDefaultTrackHandlerForLinestringType() {
        TrackHandler trackHandler = new TrackHandler();
        trackHandler.setShowLines(true);
        trackHandler.setLineColor(this.color.getComponents(null));
        trackHandler.setPointColor(this.color.getComponents(null));
        return trackHandler;
    }

    private TrackHandler<V> createDefaultTrackHandlerForMultiPointType() {
        return this.createDefaultTrackHandlerForPointType();
    }

    private TrackHandler<V> createDefaultTrackHandlerForPointType() {
        TrackHandler trackHandler = new TrackHandler();
        trackHandler.setShowLines(false);
        trackHandler.setPointColor(this.color.getComponents(null));
        return trackHandler;
    }
}

