/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.display;

import com.metsci.glimpse.charts.vector.display.BasicSkin;
import com.metsci.glimpse.charts.vector.display.BasicSkinHelper;
import com.metsci.glimpse.charts.vector.display.ColorPalette;
import com.metsci.glimpse.charts.vector.display.ContentHandler;
import com.metsci.glimpse.charts.vector.display.DNCAnnotationHandler;
import com.metsci.glimpse.charts.vector.display.HardCodedDNCSkinSpecFactory;
import com.metsci.glimpse.charts.vector.display.Skin;
import com.metsci.glimpse.charts.vector.display.xmlgen.AnnotationPainterSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.DncAnnotationPainterSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.Geoskinspec;
import com.metsci.glimpse.charts.vector.iteration.DNCObjectLoader;
import com.metsci.glimpse.charts.vector.iteration.StreamToGeoObjectConverter;
import com.metsci.glimpse.charts.vector.parser.objects.DNCFeatureCode;
import com.metsci.glimpse.charts.vector.parser.objects.DNCObject;
import com.metsci.glimpse.charts.vector.parser.objects.GeoFeatureType;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class DNCBasicSkinHelper
implements BasicSkinHelper<DNCObject> {
    private static Logger logger = Logger.getLogger(DNCBasicSkinHelper.class.toString());

    @Override
    public Schema getXsdSchema() throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        return schemaFactory.newSchema(this.getClass().getClassLoader().getResource("data/dncskin.xsd"));
    }

    @Override
    public Skin<DNCObject> createDefaultHardCodedSkin() {
        return this.createDefaultHardCodedSkin(ColorPalette.createDefaultColorPalette());
    }

    @Override
    public Skin<DNCObject> createDefaultHardCodedSkin(ColorPalette colorPalette) {
        Geoskinspec skinSpec = new HardCodedDNCSkinSpecFactory(colorPalette).createSkinSpec();
        return new BasicSkin<DNCObject>(new DNCBasicSkinHelper(), skinSpec);
    }

    @Override
    public ContentHandler<DNCObject> createAnnotationPainterSpec(AnnotationPainterSpec annotationSpec) {
        return new DNCAnnotationHandler((DncAnnotationPainterSpec)annotationSpec);
    }

    @Override
    public boolean isBestBoundaryType(DNCObject dnc) {
        return dnc.getFeatureCode() == DNCFeatureCode.Coastline;
    }

    @Override
    public boolean isSecondBestBoundaryType(DNCObject dnc) {
        return false;
    }

    @Override
    public StreamToGeoObjectConverter<DNCObject> createGeoObjectLoader() {
        return new DNCObjectLoader();
    }

    @Override
    public GeoFeatureType convertGeoFeatureType(String type) {
        return DNCFeatureCode.fromKey(type);
    }

    @Override
    public List<? extends GeoFeatureType> convertGeoFeatureType(List<String> featureTypeList) {
        ArrayList<DNCFeatureCode> realList = new ArrayList<DNCFeatureCode>(featureTypeList.size());
        for (String featureType : featureTypeList) {
            DNCFeatureCode code = this.internalConvertGeoFeatureType(featureType);
            assert (code != null) : "No feature code for type " + featureType;
            realList.add(code);
        }
        return realList;
    }

    @Override
    public String geoName() {
        return "DNC";
    }

    private DNCFeatureCode internalConvertGeoFeatureType(String type) {
        return DNCFeatureCode.fromKey(type);
    }
}

