/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.display;

import java.awt.Color;

public class ColorPalette {
    private Color waterColor;
    private Color landColor;
    private Color coverageLineColor;
    private Color depthLineColor;
    private Color coastlineLineColor;

    public static ColorPalette createDefaultColorPalette() {
        return new ColorPalette(new Color(191, 219, 255), new Color(254, 255, 215), Color.yellow, Color.gray, Color.black);
    }

    public static ColorPalette createGrayscaleColorPalette() {
        ColorPalette colorPalette = ColorPalette.createDefaultColorPalette();
        return new ColorPalette(ColorPalette.grayScalize(colorPalette.waterColor), ColorPalette.grayScalize(colorPalette.landColor), ColorPalette.grayScalize(colorPalette.coverageLineColor), ColorPalette.grayScalize(colorPalette.depthLineColor), ColorPalette.grayScalize(colorPalette.coverageLineColor));
    }

    public static ColorPalette createDebugColorPalette() {
        return new ColorPalette(Color.green, Color.orange, Color.yellow, Color.gray, Color.black);
    }

    private static Color grayScalize(Color color) {
        float[] colorComp = color.getComponents(null);
        float num = colorComp[0] * 0.2989f + colorComp[1] * 0.587f + colorComp[2] * 0.114f;
        return new Color(num, num, num, colorComp[3]);
    }

    public ColorPalette(Color waterColor, Color landColor, Color coverageLineColor, Color depthLineColor, Color coastlineLineColor) {
        this.waterColor = waterColor;
        this.landColor = landColor;
        this.coverageLineColor = coverageLineColor;
        this.depthLineColor = depthLineColor;
        this.coastlineLineColor = coastlineLineColor;
    }

    public float[] getWaterColor() {
        return this.waterColor.getComponents(null);
    }

    public float[] getWaterColor(float alpha) {
        float[] f = this.waterColor.getComponents(null);
        f[3] = alpha;
        return f;
    }

    public float[] getLandColor() {
        return this.landColor.getComponents(null);
    }

    public float[] getLandColor(float alpha) {
        float[] f = this.landColor.getComponents(null);
        f[3] = alpha;
        return f;
    }

    public float[] getCoverageLineColor() {
        return this.coverageLineColor.getComponents(null);
    }

    public float[] getCoverageLineColor(float alpha) {
        float[] f = this.coverageLineColor.getComponents(null);
        f[3] = alpha;
        return f;
    }

    public float[] getDepthLineColor() {
        return this.depthLineColor.getComponents(null);
    }

    public float[] getDepthLineColor(float alpha) {
        float[] f = this.depthLineColor.getComponents(null);
        f[3] = alpha;
        return f;
    }

    public float[] getCoastlineLineColor() {
        return this.coastlineLineColor.getComponents(null);
    }

    public float[] getCoastlineLineColor(float alpha) {
        float[] f = this.coastlineLineColor.getComponents(null);
        f[3] = alpha;
        return f;
    }
}

