/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.display;

import com.metsci.glimpse.charts.vector.display.BasicSkinHelper;
import com.metsci.glimpse.charts.vector.display.ContentHandler;
import com.metsci.glimpse.charts.vector.display.PolygonHandler;
import com.metsci.glimpse.charts.vector.display.Skin;
import com.metsci.glimpse.charts.vector.display.TrackHandler;
import com.metsci.glimpse.charts.vector.display.xmlgen.AnnotationPainterSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.FeatureSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.Geoskinspec;
import com.metsci.glimpse.charts.vector.display.xmlgen.PainterSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.PolygonPainterSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.ShapeSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.ShapeTypeSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.TrackPainterSpec;
import com.metsci.glimpse.charts.vector.parser.objects.GeoFeatureType;
import com.metsci.glimpse.charts.vector.parser.objects.GeoObject;
import com.metsci.glimpse.charts.vector.parser.objects.GeoShape;
import com.metsci.glimpse.charts.vector.parser.objects.GeoShapeType;
import com.metsci.glimpse.util.io.StreamOpener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.validation.Schema;
import org.xml.sax.SAXException;

public class BasicSkin<V extends GeoObject>
implements Skin<V> {
    private static Logger logger = Logger.getLogger(BasicSkin.class.toString());
    private static final GeoShapeType[] shapeTypes = GeoShapeType.values();
    private Map<Integer, List<ContentHandler<V>>> lookupMap;
    private Set<GeoFeatureType> debugWarningMap;
    private Geoskinspec skinSpec;
    private BasicSkinHelper<V> helper;

    public BasicSkin(BasicSkinHelper<V> helper, String resource) throws JAXBException, IOException, SAXException {
        this(helper, StreamOpener.fileThenResource.openForRead(resource));
    }

    public BasicSkin(BasicSkinHelper<V> helper, InputStream xmlStream) throws JAXBException, SAXException {
        assert (helper != null);
        this.helper = helper;
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Geoskinspec.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        Schema schema = helper.getXsdSchema();
        if (schema != null) {
            unmarshaller.setSchema(schema);
        }
        unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
        Object oSkin = unmarshaller.unmarshal(xmlStream);
        this.skinSpec = (Geoskinspec)oSkin;
        this.buildHandlersFromXmlSkin();
    }

    public BasicSkin(BasicSkinHelper<V> helper, Geoskinspec skin) {
        assert (helper != null);
        this.helper = helper;
        this.skinSpec = skin;
        this.buildHandlersFromXmlSkin();
    }

    private void buildHandlersFromXmlSkin() {
        this.lookupMap = new HashMap<Integer, List<ContentHandler<V>>>();
        this.debugWarningMap = new HashSet<GeoFeatureType>();
        List<FeatureSpec> encList = this.skinSpec.getFeature();
        for (FeatureSpec enc : encList) {
            List<GeoFeatureType> featureTypeList = this.helper.convertGeoFeatureType(enc.getFeaturetype());
            this.debugWarningMap.addAll(featureTypeList);
            List<ShapeSpec> shapeSpecList = enc.getShapespec();
            for (ShapeSpec shapeSpec : shapeSpecList) {
                GeoShapeType shapeType = this.convertShapeType(shapeSpec.getShapetypespec());
                PainterSpec painterSpecs = shapeSpec.getPainterspec();
                ArrayList<ContentHandler<V>> contentHandlerList = new ArrayList<ContentHandler<V>>();
                List<Object> painterSpecList = painterSpecs.getPolygonpainterspecOrTrackpainterspecOrAnnotationpainterspec();
                for (Object painterSpec : painterSpecList) {
                    if (painterSpec instanceof PolygonPainterSpec) {
                        PolygonPainterSpec polygonSpec = (PolygonPainterSpec)painterSpec;
                        contentHandlerList.add(new PolygonHandler(polygonSpec));
                        continue;
                    }
                    if (painterSpec instanceof TrackPainterSpec) {
                        TrackPainterSpec trackSpec = (TrackPainterSpec)painterSpec;
                        contentHandlerList.add(new TrackHandler(trackSpec));
                        continue;
                    }
                    if (painterSpec instanceof AnnotationPainterSpec) {
                        contentHandlerList.add(this.helper.createAnnotationPainterSpec((AnnotationPainterSpec)painterSpec));
                        continue;
                    }
                    assert (false) : "Unknown PainterSpec " + painterSpec.getClass();
                }
                for (GeoFeatureType featureType : featureTypeList) {
                    this.lookupMap.put(this.determineGroupId(featureType, shapeType), contentHandlerList);
                }
            }
        }
    }

    private GeoShapeType convertShapeType(ShapeTypeSpec type) {
        return GeoShapeType.valueOf(type.value());
    }

    private int determineGroupId(GeoFeatureType featureType, GeoShapeType shapeType) {
        assert (featureType != null);
        assert (shapeType != null);
        return shapeType.ordinal() + featureType.ordinal() * shapeTypes.length;
    }

    @Override
    public List<ContentHandler<V>> getHandlersForGeoObject(V geoObject) {
        Collection<? extends GeoShape> shapeList = geoObject.getGeoShapes();
        if (shapeList.isEmpty()) {
            return Collections.emptyList();
        }
        List<ContentHandler<V>> handlers = this.getHandlersOfType(geoObject.getGeoFeatureType(), geoObject.getFirstGeoShape().getShapeType());
        if (handlers == null) {
            return Collections.emptyList();
        }
        return handlers;
    }

    private List<ContentHandler<V>> getHandlersOfType(GeoFeatureType featureType, GeoShapeType shapeType) {
        int handlerId = this.determineGroupId(featureType, shapeType);
        List<ContentHandler<V>> handlerList = this.lookupMap.get(handlerId);
        if (handlerList == null && this.debugWarningMap.contains(featureType)) {
            logger.warning("No handler for known enc object type " + featureType + ", shapeType: " + (Object)((Object)shapeType));
        }
        return handlerList;
    }

    @Override
    public void reset() {
        this.buildHandlersFromXmlSkin();
    }
}

