/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.display;

import com.metsci.glimpse.charts.vector.display.ContentHandler;
import com.metsci.glimpse.charts.vector.display.GeoContext;
import com.metsci.glimpse.charts.vector.display.xmlgen.AnnotationPainterSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.EncAnnotationPainterSpec;
import com.metsci.glimpse.charts.vector.painter.EncPainterUtils;
import com.metsci.glimpse.charts.vector.parser.attributes.GeoAttribute;
import com.metsci.glimpse.charts.vector.parser.objects.GeoAttributeType;
import com.metsci.glimpse.charts.vector.parser.objects.GeoObject;
import com.metsci.glimpse.charts.vector.parser.objects.GeoShape;
import com.metsci.glimpse.painter.info.AnnotationPainter;
import com.metsci.glimpse.util.geo.LatLonGeo;
import com.metsci.glimpse.util.geo.projection.GeoProjection;
import com.metsci.glimpse.util.math.stat.StatCollectorNDim;
import com.metsci.glimpse.util.vector.Vector2d;
import java.util.logging.Logger;

public abstract class AnnotationHandler<V extends GeoObject>
implements ContentHandler<V> {
    private static final int centerPointCalculationCap = -1;
    private static Logger logger = Logger.getLogger(AnnotationHandler.class.toString());
    private AnnotationPainterSpec textAttributeSpec;

    public AnnotationHandler() {
        this(new EncAnnotationPainterSpec());
    }

    public AnnotationHandler(AnnotationPainterSpec spec) {
        assert (spec != null);
        if (spec == null) {
            throw new AssertionError();
        }
        this.textAttributeSpec = spec;
    }

    public abstract GeoAttributeType getAttributeTypeToAnnotate();

    @Override
    public void reset() {
    }

    @Override
    public void paintEnc(GeoContext geoContext, V object) {
        if (object.getGeoShapes().isEmpty()) {
            return;
        }
        GeoAttribute attributeValue = object.getGeoAttribute(this.getAttributeTypeToAnnotate());
        if (attributeValue == null) {
            return;
        }
        String attributeValueText = attributeValue.getAttributeValueAsString();
        if (attributeValueText == null) {
            return;
        }
        AnnotationPainter annotationPainter = geoContext.getAnnotationPainter();
        double[] centerXY = this.findCenterPoint(geoContext.getProjection(), object);
        AnnotationPainter.Annotation annotation = new AnnotationPainter.Annotation(attributeValueText, (float)centerXY[0], (float)centerXY[1], true, true);
        this.polishAnnotation(object, annotation);
        assert (annotation.getText() != null) : "null text";
        annotationPainter.addAnnotation(annotation);
    }

    @Override
    public Integer getScaleMin(V object) {
        return null;
    }

    private double[] findCenterPoint(GeoProjection projection, V object) {
        GeoShape shape = object.getGeoShapes().iterator().next();
        int numVertexes = shape.getNumCoordinates();
        int vertexIncrement = 1;
        StatCollectorNDim center = new StatCollectorNDim(2);
        double[] vectorXYValues = new double[2];
        for (int v = 0; v < numVertexes; v += vertexIncrement) {
            double lon = shape.getVertex(0, v);
            double lat = shape.getVertex(1, v);
            Vector2d vector = projection.project(LatLonGeo.fromDeg((double)lat, (double)lon));
            vectorXYValues[0] = vector.getX();
            vectorXYValues[1] = vector.getY();
            center.addElement(vectorXYValues);
        }
        return center.getMean();
    }

    private void polishAnnotation(V object, AnnotationPainter.Annotation annotation) {
        if (this.textAttributeSpec.isCenterX() != null) {
            annotation.setCenterX(this.textAttributeSpec.isCenterX().booleanValue());
        }
        if (this.textAttributeSpec.isCenterY() != null) {
            annotation.setCenterY(this.textAttributeSpec.isCenterY().booleanValue());
        }
        if (this.textAttributeSpec.getColor() != null) {
            annotation.setColor(EncPainterUtils.convertColorSpecToFloatArray(this.textAttributeSpec.getColor()));
        }
        if (this.textAttributeSpec.getFont() != null) {
            AnnotationPainter.AnnotationFont font = AnnotationPainter.AnnotationFont.valueOf((String)this.textAttributeSpec.getFont().value());
            annotation.setFont(font.getFont());
        }
    }
}

