/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector;

import com.metsci.glimpse.util.geo.LatLonGeo;
import com.metsci.glimpse.util.geo.projection.GeoProjection;
import com.metsci.glimpse.util.geo.projection.KinematicVector2d;
import com.metsci.glimpse.util.units.Angle;
import com.metsci.glimpse.util.vector.Vector2d;

public class MercatorProjection
implements GeoProjection {
    private double center_lon;

    public MercatorProjection(double center_longitude_deg) {
        this.center_lon = Angle.degreesToRadians((double)center_longitude_deg);
    }

    public MercatorProjection() {
        this(0.0);
    }

    public Vector2d project(LatLonGeo latLon) {
        double lon = latLon.getLonRad();
        double lat = latLon.getLatRad();
        double x = Angle.normalizeAnglePi((double)(lon - this.center_lon));
        double y = Math.log((Math.sin(lat) + 1.0) / Math.cos(lat));
        return new Vector2d(x, y);
    }

    public LatLonGeo unproject(double x, double y) {
        double lat = 2.0 * Math.atan(Math.exp(y)) - 1.5707963267948966;
        double lon = x + this.center_lon;
        return LatLonGeo.fromRad((double)lat, (double)lon);
    }

    public Vector2d reprojectFrom(double x, double y, GeoProjection fromProjection) {
        LatLonGeo unproj = fromProjection.unproject(x, y);
        return this.project(unproj);
    }

    public KinematicVector2d reprojectPosVelFrom(double x, double y, double vx, double vy, GeoProjection fromProjection) {
        throw new UnsupportedOperationException();
    }
}

