/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.shoreline.ndgc;

import com.metsci.glimpse.charts.shoreline.LandBox;
import com.metsci.glimpse.charts.shoreline.LandFile;
import com.metsci.glimpse.charts.shoreline.LandVertex;
import com.metsci.glimpse.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class NgdcFile
extends LandFile {
    private static final Logger _logger = Logger.getLogger(NgdcFile.class.getName());
    private static final String _headerLinePrefix = "# HEADER: ";
    private static final String _northLatKey = "northLat";
    private static final String _southLatKey = "southLat";
    private static final String _eastLonKey = "eastLon";
    private static final String _westLonKey = "westLon";
    private static final String _latOffsetKey = "latOffset";
    private static final String _lonOffsetKey = "lonOffset";
    private static final String _isSwCornerLandKey = "isSwCornerLand";

    public NgdcFile(File file) {
        this(file, NgdcFile.readSegments(file));
    }

    private NgdcFile(File file, List<List<LandVertex>> segments) {
        super(segments, NgdcFile.newLandBox(file, segments), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<List<LandVertex>> readSegments(File file) {
        double latOffset = 0.0;
        double lonOffset = 0.0;
        Map<String, String> headerMap = NgdcFile.readHeader(file);
        if (headerMap.containsKey(_latOffsetKey)) {
            try {
                latOffset = Double.parseDouble(headerMap.get(_latOffsetKey));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (headerMap.containsKey(_lonOffsetKey)) {
            try {
                lonOffset = Double.parseDouble(headerMap.get(_lonOffsetKey));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        BufferedReader reader = null;
        long lineNumber = 0L;
        try {
            Object line;
            ArrayList segments = new ArrayList();
            ArrayList<LandVertex> segment = null;
            reader = new BufferedReader(new FileReader(file));
            while (true) {
                double lon;
                double lat;
                line = reader.readLine();
                ++lineNumber;
                if (line == null) break;
                if (((String)line).startsWith(_headerLinePrefix)) continue;
                if (((String)line).matches("^[\\s]*[nN]a[nN][\\s]+[nN]a[nN][\\s]*$|^# -b$")) {
                    lat = Double.NaN;
                    lon = Double.NaN;
                } else {
                    String[] tokens = StringUtils.split((String)((String)line).trim(), (char)'\t');
                    if (tokens.length != 2) {
                        throw new IOException(String.format("Line %d: %s", lineNumber, line));
                    }
                    lat = Double.parseDouble(tokens[1]) + latOffset;
                    lon = Double.parseDouble(tokens[0]) + lonOffset;
                }
                if (Double.isNaN(lat) || Double.isNaN(lon)) {
                    segment = new ArrayList<LandVertex>();
                    segments.add(segment);
                    continue;
                }
                segment.add(new LandVertex(lat, lon));
            }
            line = segments;
            return line;
        }
        catch (Exception e) {
            _logger.warning("Error reading land file (line " + lineNumber + "): " + e);
            List<List<LandVertex>> list = null;
            return list;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static LandBox newLandBox(File file, List<List<LandVertex>> segments) {
        if (segments == null) {
            return null;
        }
        double northLat = Double.NEGATIVE_INFINITY;
        double southLat = Double.POSITIVE_INFINITY;
        double eastLon = Double.NEGATIVE_INFINITY;
        double westLon = Double.POSITIVE_INFINITY;
        for (List<LandVertex> vertices : segments) {
            for (LandVertex vertex : vertices) {
                northLat = Math.max(northLat, vertex.lat);
                southLat = Math.min(southLat, vertex.lat);
                eastLon = Math.max(eastLon, vertex.lon);
                westLon = Math.min(westLon, vertex.lon);
            }
        }
        boolean isSwCornerLand = false;
        Map<String, String> headerMap = NgdcFile.readHeader(file);
        if (headerMap.containsKey(_northLatKey)) {
            try {
                northLat = Double.parseDouble(headerMap.get(_northLatKey));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (headerMap.containsKey(_southLatKey)) {
            try {
                southLat = Double.parseDouble(headerMap.get(_southLatKey));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (headerMap.containsKey(_eastLonKey)) {
            try {
                eastLon = Double.parseDouble(headerMap.get(_eastLonKey));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (headerMap.containsKey(_westLonKey)) {
            try {
                westLon = Double.parseDouble(headerMap.get(_westLonKey));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (headerMap.containsKey(_isSwCornerLandKey)) {
            isSwCornerLand = Boolean.parseBoolean(headerMap.get(_isSwCornerLandKey));
        }
        return new LandBox(northLat, southLat, eastLon, westLon, isSwCornerLand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> readHeader(File file) {
        BufferedReader reader = null;
        long lineNumber = 0L;
        try {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            reader = new BufferedReader(new FileReader(file));
            while (true) {
                String line = reader.readLine();
                ++lineNumber;
                if (line == null || !line.startsWith(_headerLinePrefix)) break;
                String[] tokens = StringUtils.split((String)line.substring(_headerLinePrefix.length()), (char)' ');
                if (tokens.length != 2) {
                    throw new IOException(String.format("Line %d: %s", lineNumber, line));
                }
                headerMap.put(tokens[0], tokens[1]);
            }
            HashMap<String, String> hashMap = headerMap;
            return hashMap;
        }
        catch (Exception e) {
            _logger.warning("Error reading land file (line " + lineNumber + "): " + e);
            Map<String, String> map = null;
            return map;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

