/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.shoreline.gshhs;

import com.metsci.glimpse.charts.shoreline.LandVertex;
import com.metsci.glimpse.charts.shoreline.gshhs.GshhsPolygonHeader;
import com.metsci.glimpse.util.Pair;
import com.metsci.glimpse.util.io.LittleEndianDataInput;
import com.metsci.glimpse.util.io.StreamOpener;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class GshhsReader {
    public static Pair<List<List<LandVertex>>, List<GshhsPolygonHeader>> readSegments(File file) throws IOException {
        return GshhsReader.readSegments(file.getPath(), StreamOpener.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<List<List<LandVertex>>, List<GshhsPolygonHeader>> readSegments(String location, StreamOpener streamOpener) throws IOException {
        InputStream stream = null;
        try {
            stream = streamOpener.openForRead(location);
            Pair<List<List<LandVertex>>, List<GshhsPolygonHeader>> pair = GshhsReader.readSegments(stream);
            return pair;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static Pair<List<List<LandVertex>>, List<GshhsPolygonHeader>> readSegments(InputStream stream) throws IOException {
        ArrayList<ArrayList<LandVertex>> segments = new ArrayList<ArrayList<LandVertex>>();
        ArrayList<GshhsPolygonHeader> headers = new ArrayList<GshhsPolygonHeader>();
        try {
            DataInputStream dataStream = new DataInputStream(new BufferedInputStream(stream));
            DataInputStream in = GshhsReader.isLittleEndian(dataStream) ? new LittleEndianDataInput((DataInput)dataStream) : dataStream;
            while (true) {
                GshhsPolygonHeader header = new GshhsPolygonHeader(in);
                boolean shiftWholePolygon = !header.crossesGreenwich && header.westLon_DEG >= 180.0;
                boolean isAntarctica = header.southLat_DEG == -90.0 && header.westLon_DEG == 0.0 && header.eastLon_DEG == 360.0;
                List<LandVertex> segment = new ArrayList<LandVertex>(header.numVertices);
                for (int i = 0; i < header.numVertices; ++i) {
                    double vertexLon_DEG = 1.0E-6 * (double)in.readInt();
                    double vertexLat_DEG = 1.0E-6 * (double)in.readInt();
                    if (header.crossesGreenwich && vertexLon_DEG >= 270.0) {
                        vertexLon_DEG -= 360.0;
                    }
                    if (shiftWholePolygon) {
                        vertexLon_DEG -= 360.0;
                    }
                    if (isAntarctica && vertexLon_DEG >= 180.0) {
                        vertexLon_DEG -= 360.0;
                    }
                    segment.add(new LandVertex(vertexLat_DEG, vertexLon_DEG));
                }
                if (isAntarctica) {
                    segment = GshhsReader.rebreakAntarcticaSegment(segment);
                }
                segments.add((ArrayList<LandVertex>)segment);
                headers.add(header);
            }
        }
        catch (EOFException e) {
            return new Pair(segments, headers);
        }
        catch (GshhsPolygonHeader.UnrecognizedValueException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isLittleEndian(DataInputStream stream) throws IOException {
        stream.mark(1024);
        try {
            new GshhsPolygonHeader(stream);
            boolean bl = false;
            return bl;
        }
        catch (GshhsPolygonHeader.UnrecognizedValueException e) {
        }
        finally {
            stream.reset();
        }
        stream.mark(1024);
        try {
            new GshhsPolygonHeader((DataInput)new LittleEndianDataInput((DataInput)stream));
            boolean e = true;
            return e;
        }
        catch (GshhsPolygonHeader.UnrecognizedValueException e) {
            throw new RuntimeException(e);
        }
        finally {
            stream.reset();
        }
    }

    private static List<LandVertex> rebreakAntarcticaSegment(List<LandVertex> segment) {
        for (int i = 0; i < segment.size(); ++i) {
            LandVertex vertex = segment.get(i);
            if (!(vertex.lon > 0.0)) continue;
            List<LandVertex> newSegment = segment.subList(i, segment.size());
            newSegment.addAll(segment.subList(0, i));
            return newSegment;
        }
        throw new RuntimeException("Failed to rebreak Antarctica segment");
    }
}

