/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.shoreline.gshhs;

import java.io.DataInput;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;

public class GshhsPolygonHeader {
    private static final Set<Integer> supportedVersions = new LinkedHashSet<Integer>();
    public final int id;
    public final int numVertices;
    public final PolygonType type;
    public final boolean crossesGreenwich;
    public final PolygonDataSource dataSource;
    public final double westLon_DEG;
    public final double eastLon_DEG;
    public final double southLat_DEG;
    public final double northLat_DEG;
    public final double area_KM2;
    public final double area_full;
    public final int container;
    public final int ancestor;

    public GshhsPolygonHeader(DataInput in) throws IOException, UnrecognizedValueException {
        boolean riverLake;
        this.id = in.readInt();
        this.numVertices = in.readInt();
        int flag = in.readInt();
        int typeByte = flag & 0xFF;
        int versionByte = flag >> 8 & 0xFF;
        if (!supportedVersions.contains(versionByte)) {
            throw new UnrecognizedValueException("version", versionByte);
        }
        this.crossesGreenwich = (flag >> 16 & 0xFF) == 1;
        int dataSourceByte = flag >> 24 & 1;
        switch (dataSourceByte) {
            case 0: {
                this.dataSource = PolygonDataSource.wdb2;
                break;
            }
            case 1: {
                this.dataSource = PolygonDataSource.wvs;
                break;
            }
            default: {
                throw new UnrecognizedValueException("data source", dataSourceByte);
            }
        }
        boolean bl = riverLake = (flag >> 25 & 1) == 1;
        if (versionByte == 7 && riverLake) {
            this.type = PolygonType.riverLake;
        } else {
            switch (typeByte) {
                case 1: {
                    this.type = PolygonType.land;
                    break;
                }
                case 2: {
                    this.type = PolygonType.lake;
                    break;
                }
                case 3: {
                    this.type = PolygonType.islandInLake;
                    break;
                }
                case 4: {
                    this.type = PolygonType.pondInIslandInLake;
                    break;
                }
                default: {
                    this.type = PolygonType.lake;
                }
            }
        }
        this.westLon_DEG = 1.0E-6 * (double)in.readInt();
        this.eastLon_DEG = 1.0E-6 * (double)in.readInt();
        this.southLat_DEG = 1.0E-6 * (double)in.readInt();
        this.northLat_DEG = 1.0E-6 * (double)in.readInt();
        this.area_KM2 = 0.1 * (double)in.readInt();
        if (versionByte == 7) {
            this.area_full = 0.1 * (double)in.readInt();
            this.container = in.readInt();
            this.ancestor = in.readInt();
        } else {
            this.area_full = Double.NaN;
            this.container = -2;
            this.ancestor = -2;
        }
    }

    static {
        supportedVersions.add(7);
        supportedVersions.add(6);
        supportedVersions.add(4);
    }

    public static class UnrecognizedValueException
    extends Exception {
        private static final long serialVersionUID = 2928195545196276594L;

        public UnrecognizedValueException(String fieldName, int value) {
            super(String.format("Unrecognized value for %s: %d", fieldName, value));
        }
    }

    public static enum PolygonDataSource {
        wdb2,
        wvs;

    }

    public static enum PolygonType {
        land(1),
        lake(2),
        islandInLake(3),
        pondInIslandInLake(4),
        riverLake(2);

        public final int level;

        private PolygonType(int level) {
            this.level = level;
        }
    }
}

