/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.shoreline.gshhs;

import com.metsci.glimpse.charts.shoreline.LandBox;
import com.metsci.glimpse.charts.shoreline.LandFile;
import com.metsci.glimpse.charts.shoreline.LandVertex;
import com.metsci.glimpse.charts.shoreline.gshhs.GshhsPolygonHeader;
import com.metsci.glimpse.util.Pair;
import com.metsci.glimpse.util.geo.LatLonGeo;
import com.metsci.glimpse.util.io.LittleEndianDataInput;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class GshhsFile
extends LandFile {
    private static final Logger logger = Logger.getLogger(GshhsFile.class.getName());

    public GshhsFile(File file, LatLonGeo swCorner, LatLonGeo neCorner) throws IOException, GshhsPolygonHeader.UnrecognizedValueException {
        this(file, new LandBox(swCorner, neCorner, false));
    }

    public GshhsFile(File file, LandBox box) throws IOException, GshhsPolygonHeader.UnrecognizedValueException {
        super((List)GshhsFile.readSegments(file, box).first(), box, false);
    }

    public GshhsFile(InputStream stream, LandBox box, boolean isLittleEndian) throws IOException, GshhsPolygonHeader.UnrecognizedValueException {
        super((List)GshhsFile.readSegments0(stream, box, isLittleEndian).first(), box, false);
    }

    @Deprecated
    public static Pair<List<List<LandVertex>>, List<GshhsPolygonHeader>> readSegments(File file, LandBox box) throws IOException, GshhsPolygonHeader.UnrecognizedValueException {
        try {
            return GshhsFile.readSegments0(file, box, false);
        }
        catch (GshhsPolygonHeader.UnrecognizedValueException e) {
            return GshhsFile.readSegments0(file, box, true);
        }
    }

    private static Pair<List<List<LandVertex>>, List<GshhsPolygonHeader>> readSegments0(File file, LandBox box1, boolean isLittleEndian) throws IOException, GshhsPolygonHeader.UnrecognizedValueException {
        return GshhsFile.readSegments0(new FileInputStream(file), box1, isLittleEndian);
    }

    private static Pair<List<List<LandVertex>>, List<GshhsPolygonHeader>> readSegments0(InputStream unbufferedInputStream, LandBox box1, boolean isLittleEndian) throws IOException, GshhsPolygonHeader.UnrecognizedValueException {
        FilterInputStream stream = null;
        ArrayList<ArrayList<LandVertex>> segments = new ArrayList<ArrayList<LandVertex>>();
        ArrayList<GshhsPolygonHeader> headers = new ArrayList<GshhsPolygonHeader>();
        try {
            try {
                stream = new DataInputStream(new BufferedInputStream(unbufferedInputStream));
                FilterInputStream in = isLittleEndian ? new LittleEndianDataInput((DataInput)((Object)stream)) : stream;
                while (true) {
                    GshhsPolygonHeader header = new GshhsPolygonHeader((DataInput)((Object)in));
                    boolean shiftWholePolygon = !header.crossesGreenwich && header.westLon_DEG >= 180.0;
                    boolean isAntarctica = header.southLat_DEG == -90.0 && header.westLon_DEG == 0.0 && header.eastLon_DEG == 360.0;
                    List<LandVertex> segment = new ArrayList<LandVertex>(header.numVertices);
                    for (int i = 0; i < header.numVertices; ++i) {
                        double vertexLon_DEG = 1.0E-6 * (double)in.readInt();
                        double vertexLat_DEG = 1.0E-6 * (double)in.readInt();
                        if (header.crossesGreenwich && vertexLon_DEG >= 270.0) {
                            vertexLon_DEG -= 360.0;
                        }
                        if (shiftWholePolygon) {
                            vertexLon_DEG -= 360.0;
                        }
                        if (isAntarctica && vertexLon_DEG >= 180.0) {
                            vertexLon_DEG -= 360.0;
                        }
                        segment.add(new LandVertex(vertexLat_DEG, vertexLon_DEG));
                    }
                    if (isAntarctica) {
                        segment = GshhsFile.rebreakAntarcticaSegment(segment);
                    }
                    segments.add((ArrayList<LandVertex>)segment);
                    headers.add(header);
                }
            }
            catch (EOFException e) {
                Pair pair = new Pair(segments, headers);
                return pair;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static List<LandVertex> rebreakAntarcticaSegment(List<LandVertex> segment) {
        for (int i = 0; i < segment.size(); ++i) {
            LandVertex vertex = segment.get(i);
            if (!(vertex.lon > 0.0)) continue;
            List<LandVertex> newSegment = segment.subList(i, segment.size());
            newSegment.addAll(segment.subList(0, i));
            return newSegment;
        }
        logger.warning("Failed to rebreak Antarctica segment");
        return segment;
    }
}

