/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.shoreline;

import com.metsci.glimpse.util.geo.datum.DatumWgs84;
import com.metsci.glimpse.util.units.Angle;

public class LandVertex {
    private static final double distancePerDegree_SU = Math.PI * DatumWgs84.meanRadius / 180.0;
    public final double lat;
    public final double lon;

    public LandVertex(double lat_DEG, double lon_DEG) {
        this.lat = lat_DEG;
        this.lon = lon_DEG;
    }

    public double getDistanceX_SU(double longitude) {
        return (longitude - this.lon) * Math.cos(Angle.degreesToRadians((double)this.lat)) * distancePerDegree_SU;
    }

    public double getDistanceX_SU(LandVertex vertex) {
        return this.getDistanceX_SU(vertex.lon);
    }

    public double getDistanceY_SU(double latitude) {
        return (latitude - this.lat) * distancePerDegree_SU;
    }

    public double getDistanceY_SU(LandVertex vertex) {
        return this.getDistanceY_SU(vertex.lat);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LandVertex)) {
            return false;
        }
        LandVertex v = (LandVertex)o;
        return v.lat == this.lat && v.lon == this.lon;
    }

    public int hashCode() {
        long a = Double.doubleToLongBits(this.lat);
        int a1 = (int)(a & 0xFFFFFFL);
        int a2 = (int)(a >> 32 & 0xFFFFFFL);
        long b = Double.doubleToLongBits(this.lon);
        int b1 = (int)(b & 0xFFFFFFL);
        int b2 = (int)(b >> 32 & 0xFFFFFFL);
        int hash = this.getClass().getName().hashCode();
        hash = 31 * hash + a1;
        hash = 31 * hash + a2;
        hash = 31 * hash + b1;
        hash = 31 * hash + b2;
        return hash;
    }
}

