/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.shoreline;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.charts.shoreline.LandFile;
import com.metsci.glimpse.charts.shoreline.LandShape;
import com.metsci.glimpse.charts.shoreline.LandShapeCapable;
import com.metsci.glimpse.charts.shoreline.ndgc.NgdcFile2;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.painter.base.GlimpsePainter2D;
import com.metsci.glimpse.painter.shape.PolygonPainter;
import com.metsci.glimpse.support.polygon.Polygon;
import com.metsci.glimpse.util.geo.LatLonGeo;
import com.metsci.glimpse.util.geo.projection.GeoProjection;
import com.metsci.glimpse.util.vector.Vector2d;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.media.opengl.GLContext;

public class LandShapePainter
extends GlimpsePainter2D {
    protected static final int LAND_GROUP_ID = 1337;
    protected PolygonPainter polygonPainter = new PolygonPainter();
    protected int landPolygonCounter = 0;
    protected Rectangle2D bounds;

    public LandShapePainter() {
        this.setFillColor(0.5921569f, 0.59607846f, 0.41960785f, 1.0f);
        this.setLineColor(0.4392157f, 0.54901963f, 0.29803923f, 1.0f);
        this.setLineWidth(2);
        this.setFill(true);
    }

    @Deprecated
    public void loadLandFile(InputStream in, GeoProjection tangentPlane) throws IOException {
        this.loadNdgcLandFile(in, tangentPlane);
    }

    public void loadNdgcLandFile(InputStream in, GeoProjection tangentPlane) throws IOException {
        this.loadNgdcLandFile0(in, tangentPlane);
    }

    @Deprecated
    public void loadLandFile(String file, GeoProjection tangentPlane) throws IOException {
        this.loadNgdcLandFile(file, tangentPlane);
    }

    public void loadNgdcLandFile(String file, GeoProjection tangentPlane) throws IOException {
        this.loadNgdcLandFile0(new FileInputStream(file), tangentPlane);
    }

    @Deprecated
    public void loadLandFile(File file, GeoProjection tangentPlane) throws IOException {
        this.loadNgdcLandFile(file, tangentPlane);
    }

    public void loadNgdcLandFile(File file, GeoProjection tangentPlane) throws IOException {
        this.loadNgdcLandFile0(new FileInputStream(file), tangentPlane);
    }

    @Deprecated
    public void loadLandFileAndCenterAxis(File file, GeoProjection tangentPlane, Axis2D axis) throws IOException {
        this.loadNgdcLandFileAndCenterAxis(file, tangentPlane, axis);
    }

    public void loadNgdcLandFileAndCenterAxis(File file, GeoProjection tangentPlane, Axis2D axis) throws IOException {
        NgdcFile2 ngdcFile = new NgdcFile2(new FileInputStream(file));
        this.loadLandFileAndCenterAxis(ngdcFile, tangentPlane, axis);
    }

    public void loadLandFileAndCenterAxis(LandShapeCapable landFile, GeoProjection projection, Axis2D axis) throws IOException {
        this.loadLandFileAndCenterAxis(landFile.toShape(), projection, axis);
    }

    public void loadLandFileAndCenterAxis(LandShape landShape, GeoProjection projection, Axis2D axis) throws IOException {
        Shape shape = this.loadLandFile0(landShape, projection);
        Rectangle2D localBounds = shape.getBounds2D();
        if (this.bounds == null) {
            this.bounds = new Rectangle2D.Double();
            this.bounds.setRect(localBounds);
        } else {
            this.bounds.add(localBounds);
        }
        axis.getAxisX().setMin(this.bounds.getMinX());
        axis.getAxisX().setMax(this.bounds.getMaxX());
        axis.getAxisY().setMin(this.bounds.getMinY());
        axis.getAxisY().setMax(this.bounds.getMaxY());
    }

    protected Shape loadNgdcLandFile0(InputStream in, GeoProjection tangentPlane) throws IOException {
        NgdcFile2 ngdcFile = new NgdcFile2(in);
        return this.loadLandFile0(ngdcFile.toShape(), tangentPlane);
    }

    protected Shape loadLandFile0(LandFile landFile, GeoProjection tangentPlane) throws IOException {
        return this.loadLandFile0(landFile.toShape(), tangentPlane);
    }

    protected Shape loadLandFile0(LandShape landShape, final GeoProjection tangentPlane) {
        Shape shape = landShape.getFillShape(new LandShape.VertexConverter(){

            @Override
            public void toXY(double lat, double lon, Point2D.Double xy) {
                Vector2d vector = tangentPlane.project(LatLonGeo.fromDeg((double)lat, (double)lon));
                xy.x = vector.getX();
                xy.y = vector.getY();
            }
        });
        Polygon p = new Polygon();
        PathIterator iter = shape.getPathIterator(null);
        double[] vertices = new double[6];
        Polygon.Loop.LoopBuilder b = new Polygon.Loop.LoopBuilder();
        while (!iter.isDone()) {
            iter.next();
            int type = iter.currentSegment(vertices);
            if (type == 4) {
                p.add(b.complete(Polygon.Interior.onRight));
                this.addPolygon(p);
                p = new Polygon();
                b = new Polygon.Loop.LoopBuilder();
                continue;
            }
            if (type == 1) {
                b.addVertices(vertices, 1);
                continue;
            }
            if (type == 0) {
                p.add(b.complete(Polygon.Interior.onRight));
                this.addPolygon(p);
                p = new Polygon();
                b = new Polygon.Loop.LoopBuilder();
                b.addVertices(vertices, 1);
                continue;
            }
            throw new UnsupportedOperationException("Shape Not Supported.");
        }
        return shape;
    }

    protected void addPolygon(Polygon p) {
        this.polygonPainter.addPolygon(1337, this.landPolygonCounter++, Long.MIN_VALUE, Long.MAX_VALUE, p, 0.0f);
    }

    public void setLineColor(float r, float g, float b, float a) {
        this.polygonPainter.setLineColor(1337, r, g, b, a);
    }

    public void setLineColor(float[] rgba) {
        this.polygonPainter.setLineColor(1337, rgba);
    }

    public void setLineWidth(int width) {
        this.polygonPainter.setLineWidth(1337, (float)width);
    }

    public void setShowLines(boolean show) {
        this.polygonPainter.setShowLines(1337, show);
    }

    public void setPolyDotted(byte[] stipple) {
        this.polygonPainter.setPolyDotted(1337, stipple);
    }

    public void setPolyDotted(boolean dotted) {
        this.polygonPainter.setPolyDotted(1337, dotted);
    }

    public void setLineDotted(boolean dotted) {
        this.polygonPainter.setLineDotted(1337, dotted);
    }

    public void setLineDotted(int stippleFactor, short stipplePattern) {
        this.polygonPainter.setLineDotted(1337, stippleFactor, stipplePattern);
    }

    public void setFill(boolean show) {
        this.polygonPainter.setFill(1337, show);
    }

    public void setFillColor(float[] rgba) {
        this.polygonPainter.setFillColor(1337, rgba);
    }

    public void setFillColor(float r, float g, float b, float a) {
        this.polygonPainter.setFillColor(1337, r, g, b, a);
    }

    public void deleteAll() {
        this.polygonPainter.deleteAll();
    }

    public void dispose(GLContext context) {
        this.polygonPainter.dispose(context);
    }

    public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis2D axis) {
        this.polygonPainter.paintTo(context, bounds, axis);
    }
}

