/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.shoreline;

import com.metsci.glimpse.charts.shoreline.LandBox;
import com.metsci.glimpse.charts.shoreline.LandSegment;
import com.metsci.glimpse.charts.shoreline.LandVertex;
import com.metsci.glimpse.util.geo.LatLonGeo;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LandShape {
    private final List<LandSegment> segments;
    private final LandVertex swCorner;
    private final LandVertex neCorner;
    private final LandBox box;
    private final Shape suShape;
    private final VertexConverter suConverter;
    private final boolean invertFill;

    public LandShape(List<LandSegment> segments, LandBox box) {
        assert (segments != null);
        this.box = box;
        this.segments = Collections.unmodifiableList(new ArrayList<LandSegment>(segments));
        this.swCorner = new LandVertex(box.southLat, box.westLon);
        this.neCorner = new LandVertex(box.northLat, box.eastLon);
        this.suConverter = new VertexConverter(){

            @Override
            public void toXY(double lat, double lon, Point2D.Double xy) {
                xy.x = LandShape.this.swCorner.getDistanceX_SU(lon);
                xy.y = LandShape.this.swCorner.getDistanceY_SU(lat);
            }
        };
        Shape rawSuShape = this.getRawFillShape(this.suConverter);
        this.invertFill = rawSuShape.contains(0.0, 0.0) != box.isSwCornerLand;
        this.suShape = this.invertFill ? this.invert(rawSuShape, this.suConverter) : rawSuShape;
    }

    public boolean isLand(double latDeg, double lonDeg) {
        Point2D.Double xy = new Point2D.Double();
        this.suConverter.toXY(latDeg, lonDeg, xy);
        return this.suShape.contains(xy.getX(), xy.getY());
    }

    public Shape getStrokeShape(VertexConverter converter) {
        Path2D.Double stroke = new Path2D.Double();
        Point2D.Double xy = new Point2D.Double();
        for (LandSegment segment : this.segments) {
            LandVertex vertex0 = segment.vertices.get(0);
            converter.toXY(vertex0.lat, vertex0.lon, xy);
            ((Path2D)stroke).moveTo(xy.getX(), xy.getY());
            for (int i = 1; i < segment.vertices.size(); ++i) {
                LandVertex vertex = segment.vertices.get(i);
                converter.toXY(vertex.lat, vertex.lon, xy);
                ((Path2D)stroke).lineTo(xy.getX(), xy.getY());
            }
        }
        return stroke;
    }

    public Shape getFillShape(VertexConverter converter) {
        Shape fill = this.getRawFillShape(converter);
        return this.invertFill ? this.invert(fill, converter) : fill;
    }

    private Shape getRawFillShape(VertexConverter converter) {
        Path2D.Double fill = new Path2D.Double(0);
        Point2D.Double xy = new Point2D.Double();
        for (LandSegment segment : this.segments) {
            if (!segment.isFillable) continue;
            LandVertex vertex0 = segment.vertices.get(0);
            converter.toXY(vertex0.lat, vertex0.lon, xy);
            ((Path2D)fill).moveTo(xy.getX(), xy.getY());
            for (int i = 1; i < segment.vertices.size(); ++i) {
                LandVertex vertex = segment.vertices.get(i);
                converter.toXY(vertex.lat, vertex.lon, xy);
                ((Path2D)fill).lineTo(xy.getX(), xy.getY());
            }
            for (LandVertex ghostVertex : segment.ghostVertices) {
                converter.toXY(ghostVertex.lat, ghostVertex.lon, xy);
                ((Path2D)fill).lineTo(xy.getX(), xy.getY());
            }
            converter.toXY(vertex0.lat, vertex0.lon, xy);
            ((Path2D)fill).lineTo(xy.getX(), xy.getY());
        }
        return fill;
    }

    private Shape invert(Shape shape, VertexConverter converter) {
        Point2D.Double sw = new Point2D.Double();
        converter.toXY(this.swCorner.lat, this.swCorner.lon, sw);
        Point2D.Double ne = new Point2D.Double();
        converter.toXY(this.neCorner.lat, this.neCorner.lon, ne);
        double x = Math.min(sw.getX(), ne.getX());
        double y = Math.min(sw.getY(), ne.getY());
        double w = Math.abs(sw.getX() - ne.getX());
        double h = Math.abs(sw.getY() - ne.getY());
        Area inverted = new Area(new Rectangle2D.Double(x, y, w, h));
        inverted.subtract(new Area(shape));
        return inverted;
    }

    public LatLonGeo getSwCorner() {
        return LatLonGeo.fromDeg((double)this.swCorner.lat, (double)this.swCorner.lon);
    }

    public LatLonGeo getNeCorner() {
        return LatLonGeo.fromDeg((double)this.neCorner.lat, (double)this.neCorner.lon);
    }

    public List<LandSegment> getSegments() {
        return this.segments;
    }

    public LandBox getLandBox() {
        return this.box;
    }

    public static interface VertexConverter {
        public void toXY(double var1, double var3, Point2D.Double var5);
    }
}

