/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.shoreline;

import com.metsci.glimpse.charts.shoreline.LandBox;
import com.metsci.glimpse.charts.shoreline.LandSegment;
import com.metsci.glimpse.charts.shoreline.LandVertex;
import java.util.ArrayList;
import java.util.List;

public class LandSegmentFactory {
    private final LandBox box;

    public LandSegmentFactory(LandBox box) {
        this.box = box;
    }

    public LandSegment newLandSegment(List<LandVertex> vertices) {
        LandVertex end;
        LandVertex start = vertices.get(0);
        if (start.equals(end = vertices.get(vertices.size() - 1))) {
            return LandSegment.newFillableSegment(vertices);
        }
        Edge startEdge = Edge.NONE;
        if (start.lat >= this.box.northLat) {
            startEdge = Edge.NORTH;
        } else if (start.lat <= this.box.southLat) {
            startEdge = Edge.SOUTH;
        } else if (start.lon >= this.box.eastLon) {
            startEdge = Edge.EAST;
        } else if (start.lon <= this.box.westLon) {
            startEdge = Edge.WEST;
        }
        Edge endEdge = Edge.NONE;
        if (end.lat >= this.box.northLat) {
            endEdge = Edge.NORTH;
        } else if (end.lat <= this.box.southLat) {
            endEdge = Edge.SOUTH;
        } else if (end.lon >= this.box.eastLon) {
            endEdge = Edge.EAST;
        } else if (end.lon <= this.box.westLon) {
            endEdge = Edge.WEST;
        }
        if (startEdge == Edge.NONE || endEdge == Edge.NONE) {
            return LandSegment.newUnfillableSegment(vertices);
        }
        ArrayList<LandVertex> ghostVertices = new ArrayList<LandVertex>();
        if (!startEdge.isSame(endEdge)) {
            if (startEdge.isOpposite(endEdge)) {
                switch (startEdge) {
                    case NORTH: 
                    case SOUTH: {
                        ghostVertices.add(new LandVertex(end.lat, this.box.eastLon));
                        ghostVertices.add(new LandVertex(start.lat, this.box.eastLon));
                        break;
                    }
                    case EAST: 
                    case WEST: {
                        ghostVertices.add(new LandVertex(this.box.northLat, end.lon));
                        ghostVertices.add(new LandVertex(this.box.northLat, start.lon));
                    }
                }
            } else if (startEdge.isAdjacent(endEdge)) {
                switch (startEdge) {
                    case NORTH: 
                    case SOUTH: {
                        ghostVertices.add(new LandVertex(start.lat, end.lon));
                        break;
                    }
                    case EAST: 
                    case WEST: {
                        ghostVertices.add(new LandVertex(end.lat, start.lon));
                    }
                }
            }
        }
        return LandSegment.newFillableSegment(vertices, ghostVertices);
    }

    private static enum Edge {
        NONE,
        EAST,
        WEST,
        NORTH,
        SOUTH;


        public boolean isSame(Edge edge) {
            return this != NONE && this == edge;
        }

        public boolean isOpposite(Edge edge) {
            switch (this) {
                case EAST: {
                    return edge == WEST;
                }
                case WEST: {
                    return edge == EAST;
                }
                case NORTH: {
                    return edge == SOUTH;
                }
                case SOUTH: {
                    return edge == NORTH;
                }
            }
            return false;
        }

        public boolean isAdjacent(Edge edge) {
            switch (this) {
                case EAST: {
                    return edge == NORTH || edge == SOUTH;
                }
                case WEST: {
                    return edge == NORTH || edge == SOUTH;
                }
                case NORTH: {
                    return edge == EAST || edge == WEST;
                }
                case SOUTH: {
                    return edge == EAST || edge == WEST;
                }
            }
            return false;
        }
    }
}

