/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.shoreline;

import com.metsci.glimpse.charts.shoreline.LandBox;
import com.metsci.glimpse.charts.shoreline.LandSegment;
import com.metsci.glimpse.charts.shoreline.LandSegmentFactory;
import com.metsci.glimpse.charts.shoreline.LandShape;
import com.metsci.glimpse.charts.shoreline.LandShapeCapable;
import com.metsci.glimpse.charts.shoreline.LandVertex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class LandFile
implements LandShapeCapable {
    private final LandShape _shape;

    protected LandFile(List<List<LandVertex>> segments, LandBox box, boolean allowSegmentReversal) {
        if (segments == null || box == null) {
            this._shape = null;
            return;
        }
        ArrayList<List<LandVertex>> segments2 = new ArrayList<List<LandVertex>>(segments.size());
        for (List<LandVertex> segment : segments) {
            if (segment.isEmpty()) continue;
            segments2.add(new ArrayList<LandVertex>(segment));
        }
        LandFile.joinConnectedSegments(segments2, allowSegmentReversal);
        List<LandSegment> segments3 = Collections.unmodifiableList(LandFile.toLandSegments(segments2, box));
        this._shape = new LandShape(segments3, box);
    }

    private static void joinConnectedSegments(List<List<LandVertex>> segments, boolean allowSegmentReversal) {
        int joinlessLoopsRemaining = segments.size();
        while (joinlessLoopsRemaining > 0) {
            List<LandVertex> base = segments.remove(0);
            if (base.isEmpty()) {
                --joinlessLoopsRemaining;
                continue;
            }
            boolean anyJoins = false;
            Iterator<List<LandVertex>> i = segments.iterator();
            while (i.hasNext()) {
                List<LandVertex> extension = i.next();
                if (extension.get(0).equals(base.get(base.size() - 1))) {
                    base.addAll(extension);
                    i.remove();
                    anyJoins = true;
                    continue;
                }
                if (allowSegmentReversal && extension.get(extension.size() - 1).equals(base.get(base.size() - 1))) {
                    Collections.reverse(extension);
                    base.addAll(extension);
                    i.remove();
                    anyJoins = true;
                    continue;
                }
                if (!allowSegmentReversal || !extension.get(0).equals(base.get(0))) continue;
                Collections.reverse(base);
                base.addAll(extension);
                i.remove();
                anyJoins = true;
            }
            segments.add(base);
            joinlessLoopsRemaining = anyJoins ? segments.size() : joinlessLoopsRemaining - 1;
        }
    }

    private static List<LandSegment> toLandSegments(List<List<LandVertex>> segments, LandBox box) {
        LandSegmentFactory segmentFactory = new LandSegmentFactory(box);
        ArrayList<LandSegment> segments2 = new ArrayList<LandSegment>();
        for (List<LandVertex> vertices : segments) {
            segments2.add(segmentFactory.newLandSegment(vertices));
        }
        return segments2;
    }

    @Override
    public LandShape toShape() {
        return this._shape;
    }
}

