/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.raster;

import com.metsci.glimpse.charts.raster.IntPoint2d;
import com.metsci.glimpse.charts.vector.MercatorProjection;
import com.metsci.glimpse.gl.texture.ColorTexture1D;
import com.metsci.glimpse.support.projection.FlatProjection;
import com.metsci.glimpse.support.projection.GenericProjection;
import com.metsci.glimpse.support.projection.Projection;
import com.metsci.glimpse.support.texture.ByteTextureProjected2D;
import com.metsci.glimpse.util.Pair;
import com.metsci.glimpse.util.geo.LatLonGeo;
import com.metsci.glimpse.util.geo.LatLonRect;
import com.metsci.glimpse.util.geo.datum.Datum;
import com.metsci.glimpse.util.geo.projection.GeoProjection;
import com.metsci.glimpse.util.math.stat.StatCollectorNDim;
import com.metsci.glimpse.util.vector.Vector2d;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import java.util.Vector;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class BsbRasterData {
    private final String _imageName;
    private final String _header;
    private final Set<Pair<IntPoint2d, LatLonGeo>> _registrationPoints;
    private final byte[] _imageData;
    private final IndexColorModel _colorModel;
    private final int _width_PIXELS;
    private final int _height_PIXELS;

    private BsbRasterData(String imageName, String header, int width_PIXELS, int height_PIXELS, byte[] imageData, IndexColorModel colorModel, Set<Pair<IntPoint2d, LatLonGeo>> registrationPoints) {
        this._imageName = imageName;
        this._header = header;
        this._imageData = imageData;
        this._colorModel = colorModel;
        this._width_PIXELS = width_PIXELS;
        this._height_PIXELS = height_PIXELS;
        this._registrationPoints = registrationPoints;
    }

    public static BsbRasterData readImage(InputStream in) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in);
        DataInputStream dis = new DataInputStream(bis);
        String header = BsbRasterData.extractAsciiHeader(dis);
        int[] dim = BsbRasterData.extractDimension(header);
        IndexColorModel icm = BsbRasterData.extractColorModel(header);
        byte colorDepth = dis.readByte();
        byte[] ucData = new byte[dim[0] * dim[1]];
        BsbRasterData.decodeImageData(dis, ucData, colorDepth, dim[1]);
        return new BsbRasterData(BsbRasterData.extractImageName(header), header, dim[0], dim[1], ucData, icm, BsbRasterData.extractRegistrationPoints(header));
    }

    public IndexColorModel getColorModel() {
        return this._colorModel;
    }

    private static String extractAsciiHeader(DataInputStream stream) throws IOException {
        StringBuilder builder = new StringBuilder();
        int thisByte = 0;
        int lastByte = 0;
        while (lastByte != 26 || thisByte != 0) {
            lastByte = thisByte;
            thisByte = stream.readByte();
            builder.append((char)thisByte);
        }
        return builder.toString();
    }

    private static Vector<Pair<String, String>> extractTokenData(String header, String tokenPattern) {
        Pattern pattern = Pattern.compile("^\\w{3,}/", 8);
        Matcher matcher = pattern.matcher(header);
        String[] items = pattern.split(header);
        Vector<Pair<String, String>> results = new Vector<Pair<String, String>>();
        for (int i = 1; i < items.length; ++i) {
            matcher.find();
            if (!matcher.group().replace("/", "").matches(tokenPattern)) continue;
            results.add((Pair<String, String>)new Pair((Object)matcher.group().replace("/", ""), (Object)items[i]));
        }
        return results;
    }

    private static int[] extractDimension(String header) {
        Vector<Pair<String, String>> allTokenData = BsbRasterData.extractTokenData(header, "BSB");
        String tokenData = (String)allTokenData.get(0).second();
        Scanner s = new Scanner(tokenData);
        s.findWithinHorizon("RA\\s*=\\s*(\\d+)\\s*,\\s*(\\d+)", tokenData.length());
        MatchResult results = s.match();
        int width_PIXELS = Integer.parseInt(results.group(1));
        int height_PIXELS = Integer.parseInt(results.group(2));
        return new int[]{width_PIXELS, height_PIXELS};
    }

    private static String extractImageName(String header) {
        Vector<Pair<String, String>> allTokenData = BsbRasterData.extractTokenData(header, "BSB");
        String tokenData = (String)allTokenData.get(0).second();
        Scanner s = new Scanner(tokenData);
        s.findWithinHorizon("NA=([\\w;\\s]+)", tokenData.length());
        return s.match().group(1);
    }

    private static Set<Pair<IntPoint2d, LatLonGeo>> extractRegistrationPoints(String header) {
        HashSet<Pair<IntPoint2d, LatLonGeo>> refPoints = new HashSet<Pair<IntPoint2d, LatLonGeo>>();
        Vector<Pair<String, String>> allTokenData = BsbRasterData.extractTokenData(header, "REF");
        for (Pair<String, String> tokenData : allTokenData) {
            Scanner s = new Scanner(((String)tokenData.second()).replaceAll("\r\n", "")).useDelimiter(",");
            s.nextInt();
            int x = s.nextInt();
            int y = s.nextInt();
            double lat_DEG = s.nextDouble();
            double lon_DEG = s.nextDouble();
            refPoints.add((Pair<IntPoint2d, LatLonGeo>)new Pair((Object)new IntPoint2d(x, y), (Object)new LatLonGeo(lat_DEG, lon_DEG)));
        }
        return refPoints;
    }

    private static IndexColorModel extractColorModel(String header) {
        Vector<Pair<String, String>> allTokenData = BsbRasterData.extractTokenData(header, "DAY");
        byte[] r = new byte[16];
        byte[] g = new byte[16];
        byte[] b = new byte[16];
        for (Pair<String, String> tokenData : allTokenData) {
            Scanner s = new Scanner((String)tokenData.second());
            s.findWithinHorizon("\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+),\\s*(\\d+)", ((String)tokenData.second()).length());
            MatchResult results = s.match();
            int i = Integer.parseInt(results.group(1));
            int rd = Integer.parseInt(results.group(2));
            int gn = Integer.parseInt(results.group(3));
            int bl = Integer.parseInt(results.group(4));
            Color color = BsbRasterData.transform(new Color(rd, gn, bl), 1.0);
            r[i] = (byte)color.getRed();
            g[i] = (byte)color.getGreen();
            b[i] = (byte)color.getBlue();
        }
        return new IndexColorModel(8, 16, r, g, b);
    }

    private static final Color transform(Color color, double v) {
        int rd = (int)((double)color.getRed() * v + (1.0 - v) * 0.0);
        int gn = (int)((double)color.getGreen() * v + (1.0 - v) * 0.0);
        int bl = (int)((double)color.getBlue() * v + (1.0 - v) * 0.0);
        return new Color(rd, gn, bl);
    }

    private static void decodeImageData(DataInputStream stream, byte[] cData, int numColorBits, int numRows) throws IOException {
        byte colorMask = (byte)((1 << numColorBits) - 1 << 7 - numColorBits);
        byte countMask = (byte)((1 << 7 - numColorBits) - 1);
        int nextByte = 0;
        int iPix = 0;
        for (int i = 0; i < numRows; ++i) {
            BsbRasterData.readRowNumber(stream);
            while ((nextByte = stream.readUnsignedByte()) != 0) {
                byte colorValue = (byte)((nextByte & colorMask) >> 7 - numColorBits);
                int runLength = nextByte & countMask;
                while ((nextByte & 0x80) != 0) {
                    nextByte = stream.readUnsignedByte();
                    runLength = runLength * 128 + (nextByte & 0x7F);
                }
                for (int j = 0; j < runLength + 1; ++j) {
                    cData[iPix++] = colorValue;
                }
            }
        }
    }

    private static int readRowNumber(DataInputStream stream) throws IOException {
        int nextByte;
        int lineNumber = 0;
        do {
            nextByte = stream.readUnsignedByte();
            lineNumber = lineNumber * 128 + (nextByte & 0x7F);
        } while ((nextByte & 0x80) != 0);
        return lineNumber;
    }

    private double distance(double x1, double y1, double x2, double y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public Projection getProjection(GeoProjection plane, MercatorProjection projection, int resolution) {
        FlatProjection flatProjection = this.getProjection(projection);
        double sizeX = flatProjection.getMaxX() - flatProjection.getMinX();
        double sizeY = flatProjection.getMaxY() - flatProjection.getMinY();
        double minX = flatProjection.getMinX();
        double minY = flatProjection.getMinY();
        double[][] coordsX = new double[resolution][resolution];
        double[][] coordsY = new double[resolution][resolution];
        for (int x = 0; x < resolution; ++x) {
            for (int y = 0; y < resolution; ++y) {
                double fracX = (double)x / (double)(resolution - 1);
                double fracY = (double)y / (double)(resolution - 1);
                double valX = minX + fracX * sizeX;
                double valY = minY + fracY * sizeY;
                LatLonGeo geo = projection.unproject(valX, valY);
                Vector2d planePoint = plane.project(geo);
                coordsX[x][y] = planePoint.getX();
                coordsY[x][y] = planePoint.getY();
            }
        }
        return new GenericProjection(coordsX, coordsY);
    }

    public LatLonGeo estimateCenterLatLon() {
        if (this._registrationPoints.size() == 0) {
            return null;
        }
        StatCollectorNDim center = new StatCollectorNDim(3);
        for (Pair<IntPoint2d, LatLonGeo> pair : this._registrationPoints) {
            LatLonRect posit = ((LatLonGeo)pair.second()).toLatLonRect((Datum)Datum.wgs84sphere);
            center.addElement(new double[]{posit.getX(), posit.getY(), posit.getZ()});
        }
        double[] centerXYZ = center.getMean();
        LatLonRect centerLLR = LatLonRect.fromXyz((double)centerXYZ[0], (double)centerXYZ[1], (double)centerXYZ[2]);
        return centerLLR.toLatLonGeo((Datum)Datum.wgs84sphere);
    }

    public FlatProjection getProjection(MercatorProjection projection) {
        if (this._registrationPoints == null || this._registrationPoints.isEmpty()) {
            return null;
        }
        Pair<IntPoint2d, LatLonGeo> point1 = this._registrationPoints.iterator().next();
        Pair<IntPoint2d, LatLonGeo> point2 = null;
        double maxDistance = Double.NEGATIVE_INFINITY;
        for (Pair<IntPoint2d, LatLonGeo> pair : this._registrationPoints) {
            double distance;
            if (((IntPoint2d)pair.first()).x == ((IntPoint2d)point1.first()).x || ((IntPoint2d)pair.first()).y == ((IntPoint2d)point1.first()).y || !((distance = this.distance(((IntPoint2d)pair.first()).x, ((IntPoint2d)pair.first()).y, ((IntPoint2d)point1.first()).x, ((IntPoint2d)point1.first()).y)) > maxDistance)) continue;
            maxDistance = distance;
            point2 = pair;
            break;
        }
        if (point2 == null) {
            return null;
        }
        LatLonGeo latlon1 = (LatLonGeo)point1.second();
        LatLonGeo latlon2 = (LatLonGeo)point2.second();
        double x1 = ((IntPoint2d)point1.first()).x;
        double x2 = ((IntPoint2d)point2.first()).x;
        double y1 = ((IntPoint2d)point1.first()).y;
        double y2 = ((IntPoint2d)point2.first()).y;
        Vector2d projected1 = projection.project(latlon1);
        Vector2d projected2 = projection.project(latlon2);
        double pixelDiffX = Math.abs(x1 - x2);
        double projDiffX = Math.abs(projected1.getX() - projected2.getX());
        double pixelToProjX = pixelDiffX / projDiffX;
        double pixelDiffY = Math.abs(y1 - y2);
        double projDiffY = Math.abs(projected1.getY() - projected2.getY());
        double pixelToProjY = pixelDiffY / projDiffY;
        double minX = projected1.getX() - x1 / pixelToProjX;
        double maxX = projected1.getX() + ((double)this._width_PIXELS - x1) / pixelToProjX;
        double minY = projected1.getY() + y1 / pixelToProjY;
        double maxY = projected1.getY() - ((double)this._height_PIXELS - y1) / pixelToProjY;
        return new FlatProjection(minX, maxX, minY, maxY);
    }

    public final BufferedImage generateBufferedImage() {
        DataBufferByte dbuf = new DataBufferByte(this._imageData, this._width_PIXELS * this._height_PIXELS, 0);
        dbuf.getNumBanks();
        int[] bitMasks = new int[]{15};
        SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(0, this._width_PIXELS, this._height_PIXELS, bitMasks);
        WritableRaster raster = Raster.createWritableRaster(sampleModel, dbuf, null);
        return new BufferedImage(this._colorModel, raster, true, null);
    }

    public final String getName() {
        return this._imageName;
    }

    public final String getHeader() {
        return this._header;
    }

    public final Set<Pair<IntPoint2d, LatLonGeo>> getRegistrationPoints() {
        return this._registrationPoints;
    }

    public final ColorTexture1D getColorTexture() {
        ColorTexture1D texture = new ColorTexture1D(16);
        texture.mutate(new ColorTexture1D.MutatorColor1D(){

            public void mutate(FloatBuffer floatBuffer, int dim) {
                for (int i = 0; i < dim; ++i) {
                    floatBuffer.put((float)BsbRasterData.this._colorModel.getRed(i) / 255.0f);
                    floatBuffer.put((float)BsbRasterData.this._colorModel.getGreen(i) / 255.0f);
                    floatBuffer.put((float)BsbRasterData.this._colorModel.getBlue(i) / 255.0f);
                    floatBuffer.put((float)BsbRasterData.this._colorModel.getAlpha(i) / 255.0f);
                }
            }
        });
        return texture;
    }

    public final ByteTextureProjected2D getDataTexture() {
        ByteTextureProjected2D texture = new ByteTextureProjected2D(this._width_PIXELS, this._height_PIXELS);
        texture.mutate(new ByteTextureProjected2D.MutatorByte2D(){

            public void mutate(ByteBuffer data, int dataSizeX, int dataSizeY) {
                for (int y = 0; y < dataSizeY; ++y) {
                    for (int x = 0; x < dataSizeX; ++x) {
                        data.put(BsbRasterData.this._imageData[x + dataSizeX * y]);
                    }
                }
            }
        });
        return texture;
    }
}

