/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.bathy;

import com.metsci.glimpse.charts.bathy.Render;
import com.metsci.glimpse.util.geo.LatLonGeo;
import com.metsci.glimpse.util.geo.projection.GeoProjection;
import com.metsci.glimpse.util.vector.Vector2d;
import java.util.ArrayList;
import java.util.List;

public class RecordVertices
implements Render {
    protected List<Float> coordsX = new ArrayList<Float>();
    protected List<Float> coordsY = new ArrayList<Float>();
    protected GeoProjection projection;

    public RecordVertices(GeoProjection projection) {
        this.projection = projection;
    }

    @Override
    public void drawContour(double startX, double startY, double endX, double endY, double contourLevel) {
        Vector2d startVertex = this.projection.project(LatLonGeo.fromDeg((double)startY, (double)startX));
        Vector2d endVertex = this.projection.project(LatLonGeo.fromDeg((double)endY, (double)endX));
        this.coordsX.add(Float.valueOf((float)startVertex.getX()));
        this.coordsY.add(Float.valueOf((float)startVertex.getY()));
        this.coordsX.add(Float.valueOf((float)endVertex.getX()));
        this.coordsY.add(Float.valueOf((float)endVertex.getY()));
    }

    public float[] getCoordsX() {
        float[] coordsArrayX = new float[this.coordsX.size()];
        for (int i = 0; i < this.coordsX.size(); ++i) {
            coordsArrayX[i] = this.coordsX.get(i).floatValue();
        }
        return coordsArrayX;
    }

    public float[] getCoordsY() {
        float[] coordsArrayY = new float[this.coordsY.size()];
        for (int i = 0; i < this.coordsY.size(); ++i) {
            coordsArrayY[i] = this.coordsY.get(i).floatValue();
        }
        return coordsArrayY;
    }
}

