/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.bathy;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.charts.bathy.ContourData;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.painter.base.GlimpsePainter2D;
import com.sun.opengl.util.BufferUtil;
import java.nio.FloatBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class ContourPainter
extends GlimpsePainter2D {
    protected float[] lineColor = new float[]{0.5f, 0.5f, 0.5f, 0.5f};
    protected float lineWidth = 1.0f;
    protected float[] coordsX;
    protected float[] coordsY;
    protected boolean initialized;
    protected int[] bufferHandle;
    protected FloatBuffer dataBuffer;
    protected int totalPointCount;

    public ContourPainter(ContourData data) {
        this(data.getCoordsX(), data.getCoordsY());
    }

    public ContourPainter(float[] coordsX, float[] coordsY) {
        int size;
        this.coordsX = coordsX;
        this.coordsY = coordsY;
        this.totalPointCount = size = Math.min(coordsX.length, coordsY.length);
        this.dataBuffer = BufferUtil.newFloatBuffer((int)(size * 2));
        for (int i = 0; i < size; ++i) {
            this.dataBuffer.put(coordsX[i]).put(coordsY[i]);
        }
    }

    public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis2D axis) {
        GL gl = context.getGL();
        if (!this.initialized) {
            this.bufferHandle = new int[1];
            gl.glGenBuffers(1, this.bufferHandle, 0);
            gl.glBindBuffer(34962, this.bufferHandle[0]);
            gl.glBufferData(34962, this.totalPointCount * 2 * 4, this.dataBuffer.rewind(), 35044);
            this.glHandleError(gl);
            this.initialized = true;
        }
        gl.glBindBuffer(34962, this.bufferHandle[0]);
        gl.glVertexPointer(2, 5126, 0, 0L);
        gl.glEnableClientState(32884);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(axis.getMinX(), axis.getMaxX(), axis.getMinY(), axis.getMaxY(), -1.0, 1.0);
        gl.glColor4fv(this.lineColor, 0);
        gl.glLineWidth(this.lineWidth);
        gl.glEnable(2848);
        gl.glBlendFunc(770, 771);
        gl.glEnable(3042);
        gl.glDrawArrays(1, 0, this.totalPointCount);
        gl.glDisable(3042);
        gl.glDisable(2848);
        gl.glDisableClientState(32884);
    }

    public void setLineColor(float r, float g, float b, float a) {
        this.lineColor[0] = r;
        this.lineColor[1] = g;
        this.lineColor[2] = b;
        this.lineColor[3] = a;
    }

    public void setLineWidth(float width) {
        this.lineWidth = width;
    }

    public void dispose(GLContext context) {
        if (this.initialized) {
            context.getGL().glDeleteBuffers(1, this.bufferHandle, 0);
        }
    }
}

