/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.bathy;

import com.metsci.glimpse.charts.bathy.BathymetryData;
import com.metsci.glimpse.charts.bathy.Conrec;
import com.metsci.glimpse.charts.bathy.RecordVertices;
import com.metsci.glimpse.util.geo.projection.GeoProjection;
import java.util.Arrays;

public class ContourData {
    private RecordVertices contours;

    public ContourData(BathymetryData bathymetryData, GeoProjection tp, double[] levels) {
        Arrays.sort(levels);
        this.contours = new RecordVertices(tp);
        try {
            Conrec contourCalculator = new Conrec(this.contours);
            double[][] bathyData = bathymetryData.getData();
            int sizeX = bathyData.length;
            int sizeY = bathyData[0].length;
            contourCalculator.contour(bathyData, 0, sizeX - 1, 0, sizeY - 1, this.getLongitudes(bathymetryData), this.getLatitudes(bathymetryData), levels.length, levels);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public float[] getCoordsX() {
        return this.contours.getCoordsX();
    }

    public float[] getCoordsY() {
        return this.contours.getCoordsY();
    }

    protected double[] getLatitudes(BathymetryData bathymetryDataSet) {
        double startLat = bathymetryDataSet.getStartLat();
        double heightStep = bathymetryDataSet.getHeightStep();
        int imageHeight = bathymetryDataSet.getImageHeight();
        double[] latitudes = new double[imageHeight];
        for (int i = 0; i < imageHeight; ++i) {
            latitudes[i] = startLat + (double)i * heightStep;
        }
        return latitudes;
    }

    protected double[] getLongitudes(BathymetryData bathymetryDataSet) {
        double startLon = bathymetryDataSet.getStartLon();
        double widthStep = bathymetryDataSet.getWidthStep();
        int imageWidth = bathymetryDataSet.getImageWidth();
        double[] longitudes = new double[imageWidth];
        for (int i = 0; i < imageWidth; ++i) {
            longitudes[i] = startLon + (double)i * widthStep;
        }
        return longitudes;
    }
}

