/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.bathy;

import com.metsci.glimpse.charts.bathy.Render;

public class Conrec {
    private double[] h = new double[5];
    private int[] sh = new int[5];
    private double[] xh = new double[5];
    private double[] yh = new double[5];
    private Render render = null;

    public Conrec(Render render) throws Exception {
        if (render == null) {
            throw new Exception("Render null");
        }
        this.render = render;
    }

    public void contour(double[][] d, int ilb, int iub, int jlb, int jub, double[] x, double[] y, int nc, double[] z) {
        double x1 = 0.0;
        double x2 = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        int[] im = new int[]{0, 1, 1, 0};
        int[] jm = new int[]{0, 0, 1, 1};
        int[][][] castab = new int[][][]{new int[][]{{0, 0, 8}, {0, 2, 5}, {7, 6, 9}}, new int[][]{{0, 3, 4}, {1, 3, 1}, {4, 3, 0}}, new int[][]{{9, 6, 7}, {5, 2, 0}, {8, 0, 0}}};
        for (int j = jub - 1; j >= jlb; --j) {
            for (int i = ilb; i <= iub - 1; ++i) {
                double temp1 = Math.min(d[i][j], d[i][j + 1]);
                double temp2 = Math.min(d[i + 1][j], d[i + 1][j + 1]);
                double dmin = Math.min(temp1, temp2);
                temp1 = Math.max(d[i][j], d[i][j + 1]);
                double dmax = Math.max(temp1, temp2 = Math.max(d[i + 1][j], d[i + 1][j + 1]));
                if (!(dmax >= z[0]) || !(dmin <= z[nc - 1])) continue;
                for (int k = 0; k < nc; ++k) {
                    int m;
                    if (!(z[k] >= dmin) || !(z[k] <= dmax)) continue;
                    for (m = 4; m >= 0; --m) {
                        if (m > 0) {
                            this.h[m] = d[i + im[m - 1]][j + jm[m - 1]] - z[k];
                            this.xh[m] = x[i + im[m - 1]];
                            this.yh[m] = y[j + jm[m - 1]];
                        } else {
                            this.h[0] = 0.25 * (this.h[1] + this.h[2] + this.h[3] + this.h[4]);
                            this.xh[0] = 0.5 * (x[i] + x[i + 1]);
                            this.yh[0] = 0.5 * (y[j] + y[j + 1]);
                        }
                        this.sh[m] = this.h[m] > 0.0 ? 1 : (this.h[m] < 0.0 ? -1 : 0);
                    }
                    for (m = 1; m <= 4; ++m) {
                        int m1 = m;
                        int m2 = 0;
                        int m3 = m != 4 ? m + 1 : 1;
                        int case_value = castab[this.sh[m1] + 1][this.sh[m2] + 1][this.sh[m3] + 1];
                        if (case_value == 0) continue;
                        switch (case_value) {
                            case 1: {
                                x1 = this.xh[m1];
                                y1 = this.yh[m1];
                                x2 = this.xh[m2];
                                y2 = this.yh[m2];
                                break;
                            }
                            case 2: {
                                x1 = this.xh[m2];
                                y1 = this.yh[m2];
                                x2 = this.xh[m3];
                                y2 = this.yh[m3];
                                break;
                            }
                            case 3: {
                                x1 = this.xh[m3];
                                y1 = this.yh[m3];
                                x2 = this.xh[m1];
                                y2 = this.yh[m1];
                                break;
                            }
                            case 4: {
                                x1 = this.xh[m1];
                                y1 = this.yh[m1];
                                x2 = this.xsect(m2, m3);
                                y2 = this.ysect(m2, m3);
                                break;
                            }
                            case 5: {
                                x1 = this.xh[m2];
                                y1 = this.yh[m2];
                                x2 = this.xsect(m3, m1);
                                y2 = this.ysect(m3, m1);
                                break;
                            }
                            case 6: {
                                x1 = this.xh[m3];
                                y1 = this.yh[m3];
                                x2 = this.xsect(m1, m2);
                                y2 = this.ysect(m1, m2);
                                break;
                            }
                            case 7: {
                                x1 = this.xsect(m1, m2);
                                y1 = this.ysect(m1, m2);
                                x2 = this.xsect(m2, m3);
                                y2 = this.ysect(m2, m3);
                                break;
                            }
                            case 8: {
                                x1 = this.xsect(m2, m3);
                                y1 = this.ysect(m2, m3);
                                x2 = this.xsect(m3, m1);
                                y2 = this.ysect(m3, m1);
                                break;
                            }
                            case 9: {
                                x1 = this.xsect(m3, m1);
                                y1 = this.ysect(m3, m1);
                                x2 = this.xsect(m1, m2);
                                y2 = this.ysect(m1, m2);
                                break;
                            }
                        }
                        this.render.drawContour(x1, y1, x2, y2, z[k]);
                    }
                }
            }
        }
    }

    private double xsect(int p1, int p2) {
        return (this.h[p2] * this.xh[p1] - this.h[p1] * this.xh[p2]) / (this.h[p2] - this.h[p1]);
    }

    private double ysect(int p1, int p2) {
        return (this.h[p2] * this.yh[p1] - this.h[p1] * this.yh[p2]) / (this.h[p2] - this.h[p1]);
    }
}

