/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.bathy;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.support.projection.Projection;
import com.metsci.glimpse.support.projection.TangentPlaneProjection;
import com.metsci.glimpse.support.texture.FloatTextureProjected2D;
import com.metsci.glimpse.util.geo.LatLonGeo;
import com.metsci.glimpse.util.geo.projection.GeoProjection;
import com.metsci.glimpse.util.vector.Vector2d;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Comparator;
import java.util.TreeSet;

public class BathymetryData {
    protected double widthStep;
    protected double heightStep;
    protected double startLon;
    protected double startLat;
    protected int imageHeight;
    protected int imageWidth;
    protected GeoProjection projection;
    protected double[][] data;

    public BathymetryData(InputStream in, GeoProjection projection) throws IOException {
        this.projection = projection;
        this.read(in, projection);
    }

    protected void read(InputStream in, GeoProjection tp) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        TreeSet<Row> rows = new TreeSet<Row>(new Comparator<Row>(){

            @Override
            public int compare(Row o1, Row o2) {
                int latComparison = Double.compare(o1.centerLat, o2.centerLat);
                return latComparison != 0 ? latComparison : Double.compare(o1.centerLon, o2.centerLon);
            }
        });
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.trim().isEmpty()) continue;
            String[] tokens = line.trim().split("[ ]+");
            float lon = Float.parseFloat(tokens[0]);
            float lat = Float.parseFloat(tokens[1]);
            float depth = Float.parseFloat(tokens[2]);
            rows.add(new Row(lat, lon, depth));
        }
        TreeSet<Row> uniqueLatitudes = new TreeSet<Row>(new Comparator<Row>(){

            @Override
            public int compare(Row o1, Row o2) {
                return Double.compare(o1.centerLat, o2.centerLat);
            }
        });
        TreeSet<Row> uniqueLongitudes = new TreeSet<Row>(new Comparator<Row>(){

            @Override
            public int compare(Row o1, Row o2) {
                return Double.compare(o1.centerLon, o2.centerLon);
            }
        });
        uniqueLatitudes.addAll(rows);
        uniqueLongitudes.addAll(rows);
        this.imageHeight = uniqueLatitudes.size();
        this.imageWidth = uniqueLongitudes.size();
        this.widthStep = 0.0;
        Row prevRow = null;
        for (Row row : uniqueLongitudes) {
            if (prevRow != null) {
                this.widthStep += (double)(row.centerLon - prevRow.centerLon);
            }
            prevRow = row;
        }
        this.widthStep /= (double)(uniqueLongitudes.size() - 1);
        this.heightStep = 0.0;
        prevRow = null;
        for (Row row : uniqueLatitudes) {
            if (prevRow != null) {
                this.heightStep += (double)(row.centerLat - prevRow.centerLat);
            }
            prevRow = row;
        }
        this.heightStep /= (double)(uniqueLatitudes.size() - 1);
        this.startLon = (double)((Row)uniqueLongitudes.first()).centerLon - 0.5 * this.widthStep;
        this.startLat = (double)((Row)uniqueLatitudes.first()).centerLat - 0.5 * this.heightStep;
        this.data = new double[this.imageWidth][this.imageHeight];
        for (Row row : rows) {
            int x = (int)Math.floor(((double)row.centerLon - this.startLon) / this.widthStep);
            int y = (int)Math.floor(((double)row.centerLat - this.startLat) / this.heightStep);
            if (x < 0) {
                x = 0;
            }
            if (x >= this.imageWidth) {
                x = this.imageWidth - 1;
            }
            if (y < 0) {
                y = 0;
            }
            if (y >= this.imageHeight) {
                y = this.imageHeight - 1;
            }
            this.data[x][y] = row.depth;
        }
    }

    public FloatTextureProjected2D getTexture() {
        FloatTextureProjected2D texture = new FloatTextureProjected2D(this.imageWidth, this.imageHeight);
        TangentPlaneProjection projection = this.getProjection();
        texture.setProjection((Projection)projection);
        texture.setData(this.data);
        return texture;
    }

    public TangentPlaneProjection getProjection() {
        double endLat = this.startLat + this.heightStep * (double)this.imageHeight;
        double endLon = this.startLon + this.widthStep * (double)this.imageWidth;
        return new TangentPlaneProjection(this.projection, this.startLat, endLat, this.startLon, endLon, false);
    }

    public void setAxisBounds(Axis2D axis) {
        axis.getAxisX().setMin(this.getMinX());
        axis.getAxisX().setMax(this.getMaxX());
        axis.getAxisY().setMin(this.getMinY());
        axis.getAxisY().setMax(this.getMaxY());
    }

    public double getStartLon() {
        return this.startLon;
    }

    public double getStartLat() {
        return this.startLat;
    }

    public double getWidthStep() {
        return this.widthStep;
    }

    public double getHeightStep() {
        return this.heightStep;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public double getMinX() {
        Vector2d swCorner = this.projection.project(LatLonGeo.fromDeg((double)this.startLat, (double)this.startLon));
        Vector2d neCorner = this.projection.project(LatLonGeo.fromDeg((double)(this.startLat + this.heightStep * (double)this.imageHeight), (double)(this.startLon + this.widthStep * (double)this.imageWidth)));
        return Math.min(swCorner.getX(), neCorner.getX());
    }

    public double getMaxX() {
        Vector2d swCorner = this.projection.project(LatLonGeo.fromDeg((double)this.startLat, (double)this.startLon));
        Vector2d neCorner = this.projection.project(LatLonGeo.fromDeg((double)(this.startLat + this.heightStep * (double)this.imageHeight), (double)(this.startLon + this.widthStep * (double)this.imageWidth)));
        return Math.max(swCorner.getX(), neCorner.getX());
    }

    public double getMinY() {
        Vector2d swCorner = this.projection.project(LatLonGeo.fromDeg((double)this.startLat, (double)this.startLon));
        Vector2d neCorner = this.projection.project(LatLonGeo.fromDeg((double)(this.startLat + this.heightStep * (double)this.imageHeight), (double)(this.startLon + this.widthStep * (double)this.imageWidth)));
        return Math.min(swCorner.getY(), neCorner.getY());
    }

    public double getMaxY() {
        Vector2d swCorner = this.projection.project(LatLonGeo.fromDeg((double)this.startLat, (double)this.startLon));
        Vector2d neCorner = this.projection.project(LatLonGeo.fromDeg((double)(this.startLat + this.heightStep * (double)this.imageHeight), (double)(this.startLon + this.widthStep * (double)this.imageWidth)));
        return Math.max(swCorner.getY(), neCorner.getY());
    }

    public double[][] getData() {
        return this.data;
    }

    private static class Row {
        public float centerLat;
        public float centerLon;
        public float depth;

        public Row(float centerLat, float centerLon, float depth) {
            this.centerLat = centerLat;
            this.centerLon = centerLon;
            this.depth = depth;
        }
    }
}

