/*
 * Copyright (c) 2012, Metron, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Metron, Inc. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL METRON, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.metsci.glimpse.axis.painter.label;


/**
 * Works identically to {@link GridAxisLabelHandler}, but does not attempt to use "milli" or
 * "kilo" prefixes in axis labels.
 */
public class GridAxisLabelHandlerSimpleUnits extends GridAxisLabelHandler
{
    public GridAxisLabelHandlerSimpleUnits( )
    {
        super( );
    }

    @Override
    protected String axisLabel( int order )
    {
        String pad = axisLabel.length( ) > 0 ? " " : "";

        if ( axisUnits.length( ) == 0 )
        {
            switch ( order )
            {
                case 0: return axisLabel;
                case 3: return axisLabel + pad + "(x 1,000)";
                case -3: return axisLabel + pad + "(x 0.001)";
                default: return axisLabel + pad + "(x 10^" + order + ")";
            }
        }
        else
        {
            switch ( order )
            {
                case 0: return axisLabel + pad + "(" + axisUnits + ")";
                case 3: return axisLabel + pad + "(x 1,000 " + axisUnits + ")";
                case -3: return axisLabel + pad + "(x 0.001 " + axisUnits + ")";
                default: return axisLabel + pad + "(x 10^" + order + " " + axisUnits + ")";
            }
        }
    }
}
