/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.shader.geometry;

import com.metsci.glimpse.gl.shader.Shader;
import com.metsci.glimpse.gl.shader.ShaderSource;
import com.metsci.glimpse.gl.shader.ShaderType;
import com.metsci.glimpse.util.io.StreamOpener;
import com.metsci.glimpse.util.logging.LoggerUtils;
import com.sun.opengl.impl.error.Error;
import java.io.IOException;
import java.util.logging.Logger;
import javax.media.opengl.GL;

public class SimpleShader
extends Shader {
    private static final Logger logger = Logger.getLogger(SimpleShader.class.getName());

    public SimpleShader(String name, ShaderType type, String shaderFile) {
        super(name, type, SimpleShader.getSource(shaderFile));
    }

    public static Shader passVertex() {
        return new SimpleShader("passthrough", ShaderType.vertex, "shaders/geometry/passthrough.vs");
    }

    public static Shader passFragment() {
        return new SimpleShader("passthrough", ShaderType.fragment, "shaders/geometry/passthrough.fs");
    }

    public static ShaderSource getSource(String shaderFile) {
        try {
            return new ShaderSource(shaderFile, StreamOpener.fileThenResource);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected void logGlError(GL gl) {
        int error = gl.glGetError();
        if (error != 0) {
            String errorString = Error.gluErrorString((int)error);
            LoggerUtils.logWarning((Logger)logger, (String)"GL error (%d): %s", (Object[])new Object[]{error, errorString});
        }
    }

    @Override
    public boolean preLink(GL gl, int glProgramHandle) {
        return true;
    }

    @Override
    public void preDisplay(GL gl) {
    }

    @Override
    public void postDisplay(GL gl) {
    }
}

