/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.shader.geometry;

import com.metsci.glimpse.gl.shader.ShaderType;
import com.metsci.glimpse.support.shader.geometry.SimpleShader;
import javax.media.opengl.GL;

public class SimpleGeometryShader
extends SimpleShader {
    public final int inType;
    public final int outType;
    private final int maxVertices;

    public SimpleGeometryShader(String name, String shaderFile, int inType, int outType, int maxVertices) {
        super(name, ShaderType.geometry, shaderFile);
        this.inType = inType;
        this.outType = outType;
        this.maxVertices = maxVertices;
    }

    public static SimpleGeometryShader passGeometry(int inType, int outType, int maxVertices) {
        return new SimpleGeometryShader("passthrough", "shaders/geometry/passthrough.gs", inType, outType, maxVertices);
    }

    public static SimpleGeometryShader pointsToFixedSizeNGons(final boolean solid, final int N, final float radius) {
        return new SimpleGeometryShader("ngons" + N, "shaders/geometry/n_gon.gs", 0, solid ? 5 : 3, solid ? 3 * (N - 1) : N + 1){

            @Override
            public void preDisplay(GL gl) {
                this.getArg("N").setValue(N);
                this.getArg("radius").setValue(Float.valueOf(radius));
                this.getArg("solid").setValue(solid);
            }
        };
    }

    public static SimpleGeometryShader pointsToPixelSizedNGons(final boolean solid, final int N, final int radiusPixels) {
        return new SimpleGeometryShader("ngons" + N, "shaders/geometry/pixel_n_gon.gs", 0, solid ? 5 : 3, solid ? 3 * (N - 1) : N + 1){

            @Override
            public void preDisplay(GL gl) {
                this.getArg("N").setValue(N);
                int[] viewport = new int[4];
                gl.glGetIntegerv(2978, viewport, 0);
                int widthPixels = viewport[2];
                int heightPixels = viewport[3];
                float widthClip = (float)radiusPixels * 2.0f / (float)widthPixels;
                float heightClip = (float)radiusPixels * 2.0f / (float)heightPixels;
                this.getArg("radiusX").setValue(Float.valueOf(widthClip));
                this.getArg("radiusY").setValue(Float.valueOf(heightClip));
                this.getArg("solid").setValue(solid);
            }
        };
    }

    public static SimpleGeometryShader linesToVariableSizeNGons(final boolean solid, final int N) {
        return new SimpleGeometryShader("variable_ngons" + N, "shaders/geometry/variable_n_gon.gs", 1, solid ? 5 : 3, solid ? 3 * (N - 1) : N + 1){

            @Override
            public void preDisplay(GL gl) {
                this.getArg("N").setValue(N);
                this.getArg("solid").setValue(solid);
            }
        };
    }

    public static SimpleGeometryShader linesToXs() {
        return new SimpleGeometryShader("xs", "shaders/geometry/x.gs", 1, 3, 5);
    }

    @Override
    public boolean preLink(GL gl, int glProgramHandle) {
        gl.glProgramParameteriEXT(glProgramHandle, 36315, this.inType);
        this.logGlError(gl);
        gl.glProgramParameteriEXT(glProgramHandle, 36316, this.outType);
        this.logGlError(gl);
        gl.glProgramParameteriEXT(glProgramHandle, 36314, this.maxVertices);
        this.logGlError(gl);
        return true;
    }
}

