/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.projection;

import com.metsci.glimpse.support.projection.InvertibleProjection;
import com.metsci.glimpse.support.projection.Projection;
import com.metsci.glimpse.util.units.Angle;
import com.metsci.glimpse.util.units.Azimuth;

public class PolarProjection
implements Projection,
InvertibleProjection {
    protected double minRange;
    protected double maxRange;
    protected double startTheta;
    protected double endTheta;
    protected double centerX;
    protected double centerY;
    protected double diffRange;
    protected double diffTheta;
    protected boolean rangeIsX;

    public PolarProjection(double centerX, double centerY, double minRange, double maxRange, double startTheta, double endTheta, boolean rangeIsX) {
        this.rangeIsX = rangeIsX;
        this.centerX = centerX;
        this.centerY = centerY;
        this.minRange = minRange;
        this.maxRange = maxRange;
        this.diffRange = this.maxRange - this.minRange;
        if (startTheta < endTheta) {
            this.startTheta = startTheta;
            this.endTheta = endTheta;
            this.diffTheta = endTheta - startTheta;
        } else {
            this.startTheta = Angle.normalizeAngle360((double)startTheta);
            this.endTheta = Angle.normalizeAngle360((double)endTheta);
            this.diffTheta = this.diffTheta(this.startTheta, this.endTheta);
        }
    }

    public PolarProjection(double centerX, double centerY, double minRange, double maxRange, double startTheta, double endTheta) {
        this(centerX, centerY, minRange, maxRange, startTheta, endTheta, true);
    }

    public PolarProjection(double minRange, double maxRange, double startTheta, double endTheta, boolean rangeIsX) {
        this(0.0, 0.0, minRange, maxRange, startTheta, endTheta, true);
    }

    public PolarProjection(double minRange, double maxRange, double startTheta, double endTheta) {
        this(minRange, maxRange, startTheta, endTheta, true);
    }

    public double diffTheta(double startTheta, double endTheta) {
        if (startTheta < endTheta) {
            return endTheta - startTheta;
        }
        return 360.0 - startTheta + endTheta;
    }

    public double getMinRange() {
        return this.minRange;
    }

    public double getMaxRange() {
        return this.maxRange;
    }

    public double getStartTheta() {
        return this.startTheta;
    }

    public double getEndTheta() {
        return this.endTheta;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public double getCenterY() {
        return this.centerY;
    }

    @Override
    public void getVertexXY(double textureFractionX, double textureFractionY, float[] resultXY) {
        double textureIndexRange = this.rangeIsX ? textureFractionX : textureFractionY;
        double textureIndexTheta = !this.rangeIsX ? textureFractionX : textureFractionY;
        double theta = Azimuth.fromNavDeg((double)(this.startTheta + this.diffTheta * textureIndexTheta));
        double range = this.minRange + this.diffRange * textureIndexRange;
        resultXY[0] = (float)(range * Math.cos(theta) + this.centerX);
        resultXY[1] = (float)(range * Math.sin(theta) + this.centerY);
    }

    @Override
    public void getVertexXYZ(double textureFractionX, double textureFractionY, float[] resultXYZ) {
        this.getVertexXY(textureFractionX, textureFractionY, resultXYZ);
        resultXYZ[2] = 0.0f;
    }

    @Override
    public int getSizeX(int textureSizeX) {
        return this.rangeIsX ? 1 : textureSizeX;
    }

    @Override
    public int getSizeY(int textureSizeY) {
        return !this.rangeIsX ? 1 : textureSizeY;
    }

    @Override
    public double getTextureFractionX(double vertexX, double vertexY) {
        return this.getTextureFraction(vertexX, vertexY, true);
    }

    @Override
    public double getTextureFractionY(double vertexX, double vertexY) {
        return this.getTextureFraction(vertexX, vertexY, false);
    }

    protected double getTextureFraction(double vertexX, double vertexY, boolean getX) {
        double frac;
        double x = vertexX - this.centerX;
        double y = vertexY - this.centerY;
        if (this.rangeIsX ^ getX) {
            double theta = Angle.normalizeAngle360((double)Azimuth.toNavDeg((double)Math.atan2(y, x)));
            double thetaMinusStart = this.startTheta > theta ? 360.0 - this.startTheta + theta : theta - this.startTheta;
            frac = thetaMinusStart / this.diffTheta;
            if (frac < 0.0) {
                frac = 1.0 + frac;
            }
        } else {
            double range = Math.sqrt(x * x + y * y);
            frac = (range - this.minRange) / this.diffRange;
        }
        return frac;
    }
}

