/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.projection;

import com.metsci.glimpse.support.projection.InvertibleProjection;
import com.metsci.glimpse.support.projection.Projection;

public class FlatProjection
implements Projection,
InvertibleProjection {
    protected double minX;
    protected double maxX;
    protected double minY;
    protected double maxY;
    protected double diffX;
    protected double diffY;

    public FlatProjection(double minX, double maxX, double minY, double maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.diffX = maxX - minX;
        this.diffY = maxY - minY;
    }

    @Override
    public void getVertexXY(double textureFractionX, double textureFractionY, float[] resultXY) {
        resultXY[0] = (float)(this.minX + this.diffX * textureFractionX);
        resultXY[1] = (float)(this.minY + this.diffY * textureFractionY);
    }

    @Override
    public void getVertexXYZ(double textureFractionX, double textureFractionY, float[] resultXYZ) {
        this.getVertexXY(textureFractionX, textureFractionY, resultXYZ);
        resultXYZ[2] = 0.0f;
    }

    @Override
    public int getSizeX(int textureSizeX) {
        return 1;
    }

    @Override
    public int getSizeY(int textureSizeY) {
        return 1;
    }

    @Override
    public double getTextureFractionX(double vertexX, double vertexY) {
        return (vertexX - this.minX) / this.diffX;
    }

    @Override
    public double getTextureFractionY(double vertexX, double vertexY) {
        return (vertexY - this.minY) / this.diffY;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }
}

