/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.font;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.packrect.BackingStoreManager;
import com.sun.opengl.impl.packrect.Rect;
import com.sun.opengl.impl.packrect.RectVisitor;
import com.sun.opengl.impl.packrect.RectanglePacker;
import com.sun.opengl.util.BufferUtil;
import com.sun.opengl.util.FPSAnimator;
import com.sun.opengl.util.j2d.TextureRenderer;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureCoords;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.text.AttributedString;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.glu.GLU;

public class AttributedTextRenderer {
    private static final boolean DEBUG = Debug.debug((String)"TextRenderer");
    private static final boolean DISABLE_GLYPH_CACHE = false;
    private static final boolean DRAW_BBOXES = false;
    static final int kSize = 256;
    private static final int CYCLES_PER_FLUSH = 100;
    private static final float MAX_VERTICAL_FRAGMENTATION = 0.7f;
    static final int kQuadsPerBuffer = 100;
    static final int kCoordsPerVertVerts = 3;
    static final int kCoordsPerVertTex = 2;
    static final int kVertsPerQuad = 4;
    static final int kTotalBufferSizeVerts = 400;
    static final int kTotalBufferSizeCoordsVerts = 1200;
    static final int kTotalBufferSizeCoordsTex = 800;
    static final int kTotalBufferSizeBytesVerts = 4800;
    static final int kTotalBufferSizeBytesTex = 3200;
    static final int kSizeInBytes_OneVertices_VertexData = 12;
    static final int kSizeInBytes_OneVertices_TexData = 8;
    private Font font;
    private boolean antialiased;
    private boolean useFractionalMetrics;
    private boolean mipmap;
    private RectanglePacker packer;
    private boolean haveMaxSize;
    private RenderDelegate renderDelegate;
    private TextureRenderer cachedBackingStore;
    private Graphics2D cachedGraphics;
    private FontRenderContext cachedFontRenderContext;
    private Map stringLocations = new HashMap();
    private GlyphProducer mGlyphProducer;
    private int numRenderCycles;
    private boolean inBeginEndPair;
    private boolean isOrthoMode;
    private int beginRenderingWidth;
    private int beginRenderingHeight;
    private boolean beginRenderingDepthTestDisabled;
    private boolean haveCachedColor;
    private float cachedR;
    private float cachedG;
    private float cachedB;
    private float cachedA;
    private Color cachedColor;
    private boolean needToResetColor;
    private Frame dbgFrame;
    private boolean debugged;
    Pipelined_QuadRenderer mPipelinedQuadRenderer;
    private boolean useVertexArrays = true;
    private boolean isExtensionAvailable_GL_VERSION_1_5;
    private boolean checkFor_isExtensionAvailable_GL_VERSION_1_5;
    private boolean smoothing = true;
    private char[] singleUnicode = new char[1];

    public AttributedTextRenderer(Font font) {
        this(font, false, false, null, false);
    }

    public AttributedTextRenderer(Font font, boolean mipmap) {
        this(font, false, false, null, mipmap);
    }

    public AttributedTextRenderer(Font font, boolean antialiased, boolean useFractionalMetrics) {
        this(font, antialiased, useFractionalMetrics, null, false);
    }

    public AttributedTextRenderer(Font font, boolean antialiased, boolean useFractionalMetrics, RenderDelegate renderDelegate) {
        this(font, antialiased, useFractionalMetrics, renderDelegate, false);
    }

    public AttributedTextRenderer(Font font, boolean antialiased, boolean useFractionalMetrics, RenderDelegate renderDelegate, boolean mipmap) {
        this.font = font;
        this.antialiased = antialiased;
        this.useFractionalMetrics = useFractionalMetrics;
        this.mipmap = mipmap;
        this.packer = new RectanglePacker((BackingStoreManager)new Manager(), 256, 256);
        if (renderDelegate == null) {
            renderDelegate = new DefaultRenderDelegate();
        }
        this.renderDelegate = renderDelegate;
        this.mGlyphProducer = new GlyphProducer(font.getNumGlyphs());
    }

    public Rectangle2D getBounds(String str) {
        return this.getBounds((CharSequence)str);
    }

    public Rectangle2D getBounds(CharSequence str) {
        Rect r = null;
        r = (Rect)this.stringLocations.get(str);
        if (r != null) {
            TextData data = (TextData)r.getUserData();
            return new Rectangle2D.Double(-data.origin().x, -data.origin().y, r.w(), r.h());
        }
        return this.normalize(this.renderDelegate.getBounds(str, this.font, this.getFontRenderContext()));
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        if (this.cachedFontRenderContext == null) {
            this.cachedFontRenderContext = this.getGraphics2D().getFontRenderContext();
        }
        return this.cachedFontRenderContext;
    }

    public void beginRendering(int width, int height) throws GLException {
        this.beginRendering(width, height, true);
    }

    public void beginRendering(int width, int height, boolean disableDepthTest) throws GLException {
        this.beginRendering(true, width, height, disableDepthTest);
    }

    public void begin3DRendering() throws GLException {
        this.beginRendering(false, 0, 0, false);
    }

    public void setColor(Color color) throws GLException {
        boolean noNeedForFlush;
        boolean bl = noNeedForFlush = this.haveCachedColor && this.cachedColor != null && color.equals(this.cachedColor);
        if (!noNeedForFlush) {
            this.flushGlyphPipeline();
        }
        this.getBackingStore().setColor(color);
        this.haveCachedColor = true;
        this.cachedColor = color;
    }

    public void setColor(float r, float g, float b, float a) throws GLException {
        boolean noNeedForFlush;
        boolean bl = noNeedForFlush = this.haveCachedColor && this.cachedColor == null && r == this.cachedR && g == this.cachedG && b == this.cachedB && a == this.cachedA;
        if (!noNeedForFlush) {
            this.flushGlyphPipeline();
        }
        this.getBackingStore().setColor(r, g, b, a);
        this.haveCachedColor = true;
        this.cachedR = r;
        this.cachedG = g;
        this.cachedB = b;
        this.cachedA = a;
        this.cachedColor = null;
    }

    public void draw(CharSequence str, int x, int y) throws GLException {
        this.draw3D(str, (float)x, (float)y, 0.0f, 1.0f);
    }

    public void draw(String str, int x, int y) throws GLException {
        this.draw3D(str, (float)x, (float)y, 0.0f, 1.0f);
    }

    public void drawFancy(AttributedString str, int x, int y) throws GLException {
        this.drawFancy(str, x, y, 0.0f, 1.0f);
    }

    public void draw3D(CharSequence str, float x, float y, float z, float scaleFactor) {
        this.internal_draw3D(str, x, y, z, scaleFactor);
    }

    public void draw3D(String str, float x, float y, float z, float scaleFactor) {
        this.internal_draw3D(str, x, y, z, scaleFactor);
    }

    public float getCharWidth(char inChar) {
        return this.mGlyphProducer.getGlyphPixelWidth(inChar);
    }

    public void flush() {
        this.flushGlyphPipeline();
    }

    public void endRendering() throws GLException {
        this.endRendering(true);
    }

    public void end3DRendering() throws GLException {
        this.endRendering(false);
    }

    public void dispose() throws GLException {
        this.packer.dispose();
        this.packer = null;
        this.cachedBackingStore = null;
        this.cachedGraphics = null;
        this.cachedFontRenderContext = null;
        if (this.dbgFrame != null) {
            this.dbgFrame.dispose();
        }
    }

    private static Rectangle2D preNormalize(Rectangle2D src) {
        int minX = (int)Math.floor(src.getMinX()) - 1;
        int minY = (int)Math.floor(src.getMinY()) - 1;
        int maxX = (int)Math.ceil(src.getMaxX()) + 1;
        int maxY = (int)Math.ceil(src.getMaxY()) + 1;
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    private Rectangle2D normalize(Rectangle2D src) {
        int boundary = (int)Math.max(1.0, 0.015 * (double)this.font.getSize());
        return new Rectangle2D.Double((int)Math.floor(src.getMinX() - (double)boundary), (int)Math.floor(src.getMinY() - (double)boundary), (int)Math.ceil(src.getWidth() + (double)(2 * boundary)), (int)Math.ceil(src.getHeight()) + 2 * boundary);
    }

    private TextureRenderer getBackingStore() {
        TextureRenderer renderer = (TextureRenderer)this.packer.getBackingStore();
        if (renderer != this.cachedBackingStore) {
            if (this.cachedGraphics != null) {
                this.cachedGraphics.dispose();
                this.cachedGraphics = null;
                this.cachedFontRenderContext = null;
            }
            this.cachedBackingStore = renderer;
        }
        return this.cachedBackingStore;
    }

    private Graphics2D getGraphics2D() {
        TextureRenderer renderer = this.getBackingStore();
        if (this.cachedGraphics == null) {
            this.cachedGraphics = renderer.createGraphics();
            this.cachedGraphics.setComposite(AlphaComposite.Src);
            this.cachedGraphics.setColor(Color.WHITE);
            this.cachedGraphics.setFont(this.font);
            this.cachedGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.antialiased ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            this.cachedGraphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, this.useFractionalMetrics ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }
        return this.cachedGraphics;
    }

    private void beginRendering(boolean ortho, int width, int height, boolean disableDepthTestForOrtho) {
        if (DEBUG && !this.debugged) {
            this.debug();
        }
        this.inBeginEndPair = true;
        this.isOrthoMode = ortho;
        this.beginRenderingWidth = width;
        this.beginRenderingHeight = height;
        this.beginRenderingDepthTestDisabled = disableDepthTestForOrtho;
        if (ortho) {
            this.getBackingStore().beginOrthoRendering(width, height, disableDepthTestForOrtho);
        } else {
            this.getBackingStore().begin3DRendering();
        }
        GL gl = GLU.getCurrentGL();
        gl.glPushClientAttrib(-1);
        if (!this.haveMaxSize) {
            int[] sz = new int[1];
            gl.glGetIntegerv(3379, sz, 0);
            this.packer.setMaxSize(sz[0], sz[0]);
            this.haveMaxSize = true;
        }
        if (this.needToResetColor && this.haveCachedColor) {
            if (this.cachedColor == null) {
                this.getBackingStore().setColor(this.cachedR, this.cachedG, this.cachedB, this.cachedA);
            } else {
                this.getBackingStore().setColor(this.cachedColor);
            }
            this.needToResetColor = false;
        }
        if (this.mipmap && !this.getBackingStore().isUsingAutoMipmapGeneration()) {
            if (DEBUG) {
                System.err.println("Disabled mipmapping in TextRenderer");
            }
            this.mipmap = false;
        }
    }

    private void endRendering(boolean ortho) throws GLException {
        this.flushGlyphPipeline();
        this.inBeginEndPair = false;
        GL gl = GLU.getCurrentGL();
        gl.glPopClientAttrib();
        if (this.is15Available(gl)) {
            try {
                gl.glBindBuffer(34962, 0);
            }
            catch (Exception e) {
                this.isExtensionAvailable_GL_VERSION_1_5 = false;
            }
        }
        if (ortho) {
            this.getBackingStore().endOrthoRendering();
        } else {
            this.getBackingStore().end3DRendering();
        }
        if (++this.numRenderCycles >= 100) {
            this.numRenderCycles = 0;
            if (DEBUG) {
                System.err.println("Clearing unused entries in endRendering()");
            }
            this.clearUnusedEntries();
        }
    }

    private void clearUnusedEntries() {
        final ArrayList deadRects = new ArrayList();
        this.packer.visit(new RectVisitor(){

            public void visit(Rect rect) {
                TextData data = (TextData)rect.getUserData();
                if (data.used()) {
                    data.clearUsed();
                } else {
                    deadRects.add(rect);
                }
            }
        });
        for (Rect r : deadRects) {
            this.packer.remove(r);
            this.stringLocations.remove(((TextData)r.getUserData()).string());
            int unicodeToClearFromCache = ((TextData)r.getUserData()).unicodeID;
            if (unicodeToClearFromCache <= 0) continue;
            this.mGlyphProducer.clearCacheEntry(unicodeToClearFromCache);
        }
        float frag = this.packer.verticalFragmentationRatio();
        if (!deadRects.isEmpty() && frag > 0.7f) {
            if (DEBUG) {
                System.err.println("Compacting TextRenderer backing store due to vertical fragmentation " + frag);
            }
            this.packer.compact();
        }
        if (DEBUG) {
            this.getBackingStore().markDirty(0, 0, this.getBackingStore().getWidth(), this.getBackingStore().getHeight());
        }
    }

    private void internal_draw3D(CharSequence str, float x, float y, float z, float scaleFactor) {
        List glyphs = this.mGlyphProducer.getGlyphs(str);
        for (Glyph glyph : glyphs) {
            float advance = glyph.draw3D(x, y, z, scaleFactor);
            x += advance * scaleFactor;
        }
    }

    public void drawFancy(AttributedString str, float x, float y, float z, float scaleFactor) {
        List glyphs = this.mGlyphProducer.getGlyphs(str);
        for (Glyph glyph : glyphs) {
            float advance = glyph.draw3D(x, y, z, scaleFactor);
            x += advance * scaleFactor;
        }
    }

    private void flushGlyphPipeline() {
        if (this.mPipelinedQuadRenderer != null) {
            this.mPipelinedQuadRenderer.draw();
        }
    }

    public void draw3D_ROBUST(AttributedString str2, float x, float y, float z, float scaleFactor) {
        Rect rect = (Rect)this.stringLocations.get(str2.toString());
        if (rect == null) {
            Graphics2D g = this.getGraphics2D();
            Rectangle2D origBBox = AttributedTextRenderer.preNormalize(this.renderDelegate.getBounds(str2, this.font, this.getFontRenderContext()));
            Rectangle2D bbox = this.normalize(origBBox);
            Point origin = new Point((int)(-bbox.getMinX()), (int)(-bbox.getMinY()));
            rect = new Rect(0, 0, (int)bbox.getWidth(), (int)bbox.getHeight(), (Object)new TextData(str2.toString(), origin, origBBox, -1));
            this.packer.add(rect);
            this.stringLocations.put(str2.toString(), rect);
            g = this.getGraphics2D();
            int strx = rect.x() + origin.x;
            int stry = rect.y() + origin.y;
            g.setComposite(AlphaComposite.Clear);
            g.fillRect(rect.x(), rect.y(), rect.w(), rect.h());
            g.setComposite(AlphaComposite.Src);
            this.renderDelegate.draw(g, str2, strx, stry);
            this.getBackingStore().markDirty(rect.x(), rect.y(), rect.w(), rect.h());
        }
        TextureRenderer renderer = this.getBackingStore();
        TextData data = (TextData)rect.getUserData();
        data.markUsed();
        Rectangle2D origRect = data.origRect();
        renderer.draw3DRect(x - scaleFactor * (float)data.origOriginX(), y - scaleFactor * ((float)origRect.getHeight() - (float)data.origOriginY()), z, rect.x() + (data.origin().x - data.origOriginX()), renderer.getHeight() - rect.y() - (int)origRect.getHeight() - (data.origin().y - data.origOriginY()), (int)origRect.getWidth(), (int)origRect.getHeight(), scaleFactor);
    }

    private void draw3D_ROBUST(CharSequence str, float x, float y, float z, float scaleFactor) {
        String curStr = str instanceof String ? (String)str : str.toString();
        Rect rect = (Rect)this.stringLocations.get(curStr);
        if (rect == null) {
            Graphics2D g = this.getGraphics2D();
            Rectangle2D origBBox = AttributedTextRenderer.preNormalize(this.renderDelegate.getBounds(curStr, this.font, this.getFontRenderContext()));
            Rectangle2D bbox = this.normalize(origBBox);
            Point origin = new Point((int)(-bbox.getMinX()), (int)(-bbox.getMinY()));
            rect = new Rect(0, 0, (int)bbox.getWidth(), (int)bbox.getHeight(), (Object)new TextData(curStr, origin, origBBox, -1));
            this.packer.add(rect);
            this.stringLocations.put(curStr, rect);
            g = this.getGraphics2D();
            int strx = rect.x() + origin.x;
            int stry = rect.y() + origin.y;
            g.setComposite(AlphaComposite.Clear);
            g.fillRect(rect.x(), rect.y(), rect.w(), rect.h());
            g.setComposite(AlphaComposite.Src);
            this.renderDelegate.draw(g, curStr, strx, stry);
            this.getBackingStore().markDirty(rect.x(), rect.y(), rect.w(), rect.h());
        }
        TextureRenderer renderer = this.getBackingStore();
        TextData data = (TextData)rect.getUserData();
        data.markUsed();
        Rectangle2D origRect = data.origRect();
        renderer.draw3DRect(x - scaleFactor * (float)data.origOriginX(), y - scaleFactor * ((float)origRect.getHeight() - (float)data.origOriginY()), z, rect.x() + (data.origin().x - data.origOriginX()), renderer.getHeight() - rect.y() - (int)origRect.getHeight() - (data.origin().y - data.origOriginY()), (int)origRect.getWidth(), (int)origRect.getHeight(), scaleFactor);
    }

    private void debug() {
        this.dbgFrame = new Frame("TextRenderer Debug Output");
        GLCanvas dbgCanvas = new GLCanvas(new GLCapabilities(), null, GLContext.getCurrent(), null);
        dbgCanvas.addGLEventListener((GLEventListener)new DebugListener(this.dbgFrame));
        this.dbgFrame.add((Component)dbgCanvas);
        final FPSAnimator anim = new FPSAnimator((GLAutoDrawable)dbgCanvas, 10);
        this.dbgFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        anim.stop();
                    }
                }).start();
            }
        });
        this.dbgFrame.setSize(256, 256);
        this.dbgFrame.setVisible(true);
        anim.start();
        this.debugged = true;
    }

    public void setUseVertexArrays(boolean useVertexArrays) {
        this.useVertexArrays = useVertexArrays;
    }

    public boolean getUseVertexArrays() {
        return this.useVertexArrays;
    }

    public void setSmoothing(boolean smoothing) {
        this.smoothing = smoothing;
        this.getBackingStore().setSmoothing(smoothing);
    }

    public boolean getSmoothing() {
        return this.smoothing;
    }

    private boolean is15Available(GL gl) {
        if (!this.checkFor_isExtensionAvailable_GL_VERSION_1_5) {
            this.isExtensionAvailable_GL_VERSION_1_5 = gl.isExtensionAvailable("GL_VERSION_1_5");
            this.checkFor_isExtensionAvailable_GL_VERSION_1_5 = true;
        }
        return this.isExtensionAvailable_GL_VERSION_1_5;
    }

    class DebugListener
    implements GLEventListener {
        private GLU glu = new GLU();
        private Frame frame;

        DebugListener(Frame frame) {
            this.frame = frame;
        }

        public void display(GLAutoDrawable drawable) {
            GL gl = drawable.getGL();
            gl.glClear(16640);
            if (AttributedTextRenderer.this.packer == null) {
                return;
            }
            TextureRenderer rend = AttributedTextRenderer.this.getBackingStore();
            final int w = rend.getWidth();
            final int h = rend.getHeight();
            rend.beginOrthoRendering(w, h);
            rend.drawOrthoRect(0, 0);
            rend.endOrthoRendering();
            if (this.frame.getWidth() != w || this.frame.getHeight() != h) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DebugListener.this.frame.setSize(w, h);
                    }
                });
            }
        }

        public void init(GLAutoDrawable drawable) {
        }

        public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        }

        public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
        }
    }

    class Pipelined_QuadRenderer {
        int mOutstandingGlyphsVerticesPipeline = 0;
        FloatBuffer mTexCoords;
        FloatBuffer mVertCoords;
        boolean usingVBOs;
        int mVBO_For_ResuableTileVertices;
        int mVBO_For_ResuableTileTexCoords;

        Pipelined_QuadRenderer() {
            GL gl = GLU.getCurrentGL();
            this.mVertCoords = BufferUtil.newFloatBuffer((int)1200);
            this.mTexCoords = BufferUtil.newFloatBuffer((int)800);
            this.usingVBOs = AttributedTextRenderer.this.is15Available(gl);
            if (this.usingVBOs) {
                try {
                    int[] vbos = new int[2];
                    gl.glGenBuffers(2, IntBuffer.wrap(vbos));
                    this.mVBO_For_ResuableTileVertices = vbos[0];
                    this.mVBO_For_ResuableTileTexCoords = vbos[1];
                    gl.glBindBuffer(34962, this.mVBO_For_ResuableTileVertices);
                    gl.glBufferData(34962, 4800, null, 35040);
                    gl.glBindBuffer(34962, this.mVBO_For_ResuableTileTexCoords);
                    gl.glBufferData(34962, 3200, null, 35040);
                }
                catch (Exception e) {
                    AttributedTextRenderer.this.isExtensionAvailable_GL_VERSION_1_5 = false;
                    this.usingVBOs = false;
                }
            }
        }

        public void glTexCoord2f(float v, float v1) {
            this.mTexCoords.put(v);
            this.mTexCoords.put(v1);
        }

        public void glVertex3f(float inX, float inY, float inZ) {
            this.mVertCoords.put(inX);
            this.mVertCoords.put(inY);
            this.mVertCoords.put(inZ);
            ++this.mOutstandingGlyphsVerticesPipeline;
            if (this.mOutstandingGlyphsVerticesPipeline >= 400) {
                this.draw();
            }
        }

        private void draw() {
            if (AttributedTextRenderer.this.useVertexArrays) {
                this.drawVertexArrays();
            } else {
                this.drawIMMEDIATE();
            }
        }

        private void drawVertexArrays() {
            if (this.mOutstandingGlyphsVerticesPipeline > 0) {
                GL gl = GLU.getCurrentGL();
                TextureRenderer renderer = AttributedTextRenderer.this.getBackingStore();
                Texture texture = renderer.getTexture();
                this.mVertCoords.rewind();
                this.mTexCoords.rewind();
                gl.glEnableClientState(32884);
                if (this.usingVBOs) {
                    gl.glBindBuffer(34962, this.mVBO_For_ResuableTileVertices);
                    gl.glBufferSubData(34962, 0, this.mOutstandingGlyphsVerticesPipeline * 12, (Buffer)this.mVertCoords);
                    gl.glVertexPointer(3, 5126, 0, 0L);
                } else {
                    gl.glVertexPointer(3, 5126, 0, (Buffer)this.mVertCoords);
                }
                gl.glEnableClientState(32888);
                if (this.usingVBOs) {
                    gl.glBindBuffer(34962, this.mVBO_For_ResuableTileTexCoords);
                    gl.glBufferSubData(34962, 0, this.mOutstandingGlyphsVerticesPipeline * 8, (Buffer)this.mTexCoords);
                    gl.glTexCoordPointer(2, 5126, 0, 0L);
                } else {
                    gl.glTexCoordPointer(2, 5126, 0, (Buffer)this.mTexCoords);
                }
                gl.glDrawArrays(7, 0, this.mOutstandingGlyphsVerticesPipeline);
                this.mVertCoords.rewind();
                this.mTexCoords.rewind();
                this.mOutstandingGlyphsVerticesPipeline = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drawIMMEDIATE() {
            if (this.mOutstandingGlyphsVerticesPipeline > 0) {
                TextureRenderer renderer = AttributedTextRenderer.this.getBackingStore();
                Texture texture = renderer.getTexture();
                GL gl = GLU.getCurrentGL();
                gl.glBegin(7);
                try {
                    int numberOfQuads = this.mOutstandingGlyphsVerticesPipeline / 4;
                    this.mVertCoords.rewind();
                    this.mTexCoords.rewind();
                    for (int i = 0; i < numberOfQuads; ++i) {
                        gl.glTexCoord2f(this.mTexCoords.get(), this.mTexCoords.get());
                        gl.glVertex3f(this.mVertCoords.get(), this.mVertCoords.get(), this.mVertCoords.get());
                        gl.glTexCoord2f(this.mTexCoords.get(), this.mTexCoords.get());
                        gl.glVertex3f(this.mVertCoords.get(), this.mVertCoords.get(), this.mVertCoords.get());
                        gl.glTexCoord2f(this.mTexCoords.get(), this.mTexCoords.get());
                        gl.glVertex3f(this.mVertCoords.get(), this.mVertCoords.get(), this.mVertCoords.get());
                        gl.glTexCoord2f(this.mTexCoords.get(), this.mTexCoords.get());
                        gl.glVertex3f(this.mVertCoords.get(), this.mVertCoords.get(), this.mVertCoords.get());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    gl.glEnd();
                    this.mVertCoords.rewind();
                    this.mTexCoords.rewind();
                    this.mOutstandingGlyphsVerticesPipeline = 0;
                }
            }
        }
    }

    class GlyphProducer {
        final int undefined = -2;
        FontRenderContext fontRenderContext = null;
        List glyphsOutput = new ArrayList();
        int[] unicodes2Glyphs;
        Glyph[] glyphCache;
        CharSequenceIterator iter = new CharSequenceIterator();

        GlyphProducer(int fontLengthInGlyphs) {
            this.unicodes2Glyphs = new int[512];
            this.glyphCache = new Glyph[fontLengthInGlyphs];
            this.clearAllCacheEntries();
        }

        public List getGlyphs(AttributedString str) {
            this.glyphsOutput.clear();
            this.glyphsOutput.add(new Glyph(str));
            return this.glyphsOutput;
        }

        public List getGlyphs(CharSequence inString) {
            boolean complex;
            this.glyphsOutput.clear();
            this.iter.initFromCharSequence(inString);
            GlyphVector fullRunGlyphVector = AttributedTextRenderer.this.font.createGlyphVector(AttributedTextRenderer.this.getFontRenderContext(), this.iter);
            boolean bl = complex = fullRunGlyphVector.getLayoutFlags() != 0;
            if (complex) {
                this.glyphsOutput.add(new Glyph(inString.toString(), false));
                return this.glyphsOutput;
            }
            int lengthInGlyphs = fullRunGlyphVector.getNumGlyphs();
            int i = 0;
            while (i < lengthInGlyphs) {
                Glyph glyph = this.getGlyph(inString, fullRunGlyphVector, i);
                if (glyph != null) {
                    this.glyphsOutput.add(glyph);
                    ++i;
                    continue;
                }
                StringBuffer buf = new StringBuffer();
                while (i < lengthInGlyphs && this.getGlyph(inString, fullRunGlyphVector, i) == null) {
                    buf.append(inString.charAt(i++));
                }
                this.glyphsOutput.add(new Glyph(buf.toString(), i < lengthInGlyphs));
            }
            return this.glyphsOutput;
        }

        public void clearCacheEntry(int unicodeID) {
            int glyphID = this.unicodes2Glyphs[unicodeID];
            if (glyphID != -2) {
                Glyph glyph = this.glyphCache[glyphID];
                if (glyph != null) {
                    glyph.clear();
                }
                this.glyphCache[glyphID] = null;
            }
            this.unicodes2Glyphs[unicodeID] = -2;
        }

        public void clearAllCacheEntries() {
            for (int i = 0; i < this.unicodes2Glyphs.length; ++i) {
                this.clearCacheEntry(i);
            }
        }

        public void register(Glyph glyph) {
            this.unicodes2Glyphs[glyph.getUnicodeID()] = glyph.getGlyphCode();
            this.glyphCache[glyph.getGlyphCode()] = glyph;
        }

        public float getGlyphPixelWidth(char unicodeID) {
            Glyph glyph = this.getGlyph(unicodeID);
            if (glyph != null) {
                return glyph.getAdvance();
            }
            ((AttributedTextRenderer)AttributedTextRenderer.this).singleUnicode[0] = unicodeID;
            GlyphVector gv = AttributedTextRenderer.this.font.createGlyphVector(this.fontRenderContext, AttributedTextRenderer.this.singleUnicode);
            return gv.getGlyphMetrics(0).getAdvance();
        }

        private Glyph getGlyph(CharSequence inString, GlyphVector fullRunGlyphVector, int index) {
            char unicodeID = inString.charAt(index);
            if (unicodeID >= this.unicodes2Glyphs.length) {
                return null;
            }
            int glyphID = this.unicodes2Glyphs[unicodeID];
            if (glyphID != -2) {
                return this.glyphCache[glyphID];
            }
            ((AttributedTextRenderer)AttributedTextRenderer.this).singleUnicode[0] = unicodeID;
            GlyphVector gv = AttributedTextRenderer.this.font.createGlyphVector(AttributedTextRenderer.this.getFontRenderContext(), AttributedTextRenderer.this.singleUnicode);
            return this.getGlyph(unicodeID, gv, fullRunGlyphVector.getGlyphMetrics(index));
        }

        private Glyph getGlyph(int unicodeID) {
            if (unicodeID >= this.unicodes2Glyphs.length) {
                return null;
            }
            int glyphID = this.unicodes2Glyphs[unicodeID];
            if (glyphID != -2) {
                return this.glyphCache[glyphID];
            }
            ((AttributedTextRenderer)AttributedTextRenderer.this).singleUnicode[0] = (char)unicodeID;
            GlyphVector gv = AttributedTextRenderer.this.font.createGlyphVector(AttributedTextRenderer.this.getFontRenderContext(), AttributedTextRenderer.this.singleUnicode);
            return this.getGlyph(unicodeID, gv, gv.getGlyphMetrics(0));
        }

        private Glyph getGlyph(int unicodeID, GlyphVector singleUnicodeGlyphVector, GlyphMetrics metrics) {
            int glyphCode = singleUnicodeGlyphVector.getGlyphCode(0);
            if (glyphCode >= this.glyphCache.length) {
                return null;
            }
            Glyph glyph = new Glyph(unicodeID, glyphCode, metrics.getAdvance(), singleUnicodeGlyphVector, this);
            this.register(glyph);
            return glyph;
        }
    }

    class Glyph {
        private int unicodeID;
        private int glyphCode;
        private GlyphProducer producer;
        private float advance;
        private GlyphVector singleUnicodeGlyphVector;
        private Rect glyphRectForTextureMapping;
        private String str;
        private boolean needAdvance;
        private AttributedString str2;

        public Glyph(int unicodeID, int glyphCode, float advance, GlyphVector singleUnicodeGlyphVector, GlyphProducer producer) {
            this.unicodeID = unicodeID;
            this.glyphCode = glyphCode;
            this.advance = advance;
            this.singleUnicodeGlyphVector = singleUnicodeGlyphVector;
            this.producer = producer;
        }

        public Glyph(String str, boolean needAdvance) {
            this.str = str;
            this.needAdvance = needAdvance;
        }

        public Glyph(AttributedString str2) {
            this.str2 = str2;
        }

        public int getUnicodeID() {
            return this.unicodeID;
        }

        public int getGlyphCode() {
            return this.glyphCode;
        }

        public float getAdvance() {
            return this.advance;
        }

        public float draw3D(float inX, float inY, float z, float scaleFactor) {
            if (this.str2 != null) {
                AttributedTextRenderer.this.draw3D_ROBUST(this.str2, inX, inY, z, scaleFactor);
                return 0.0f;
            }
            if (this.str != null) {
                AttributedTextRenderer.this.draw3D_ROBUST(this.str, inX, inY, z, scaleFactor);
                if (!this.needAdvance) {
                    return 0.0f;
                }
                GlyphVector gv = AttributedTextRenderer.this.font.createGlyphVector(AttributedTextRenderer.this.getFontRenderContext(), this.str);
                float totalAdvance = 0.0f;
                for (int i = 0; i < gv.getNumGlyphs(); ++i) {
                    totalAdvance += gv.getGlyphMetrics(i).getAdvance();
                }
                return totalAdvance;
            }
            if (this.glyphRectForTextureMapping == null) {
                this.upload();
            }
            try {
                if (AttributedTextRenderer.this.mPipelinedQuadRenderer == null) {
                    AttributedTextRenderer.this.mPipelinedQuadRenderer = new Pipelined_QuadRenderer();
                }
                TextureRenderer renderer = AttributedTextRenderer.this.getBackingStore();
                TextureCoords wholeImageTexCoords = renderer.getTexture().getImageTexCoords();
                float xScale = wholeImageTexCoords.right();
                float yScale = wholeImageTexCoords.bottom();
                Rect rect = this.glyphRectForTextureMapping;
                TextData data = (TextData)rect.getUserData();
                data.markUsed();
                Rectangle2D origRect = data.origRect();
                float x = inX - scaleFactor * (float)data.origOriginX();
                float y = inY - scaleFactor * ((float)origRect.getHeight() - (float)data.origOriginY());
                int texturex = rect.x() + (data.origin().x - data.origOriginX());
                int texturey = renderer.getHeight() - rect.y() - (int)origRect.getHeight() - (data.origin().y - data.origOriginY());
                int width = (int)origRect.getWidth();
                int height = (int)origRect.getHeight();
                float tx1 = xScale * (float)texturex / (float)renderer.getWidth();
                float ty1 = yScale * (1.0f - (float)texturey / (float)renderer.getHeight());
                float tx2 = xScale * (float)(texturex + width) / (float)renderer.getWidth();
                float ty2 = yScale * (1.0f - (float)(texturey + height) / (float)renderer.getHeight());
                AttributedTextRenderer.this.mPipelinedQuadRenderer.glTexCoord2f(tx1, ty1);
                AttributedTextRenderer.this.mPipelinedQuadRenderer.glVertex3f(x, y, z);
                AttributedTextRenderer.this.mPipelinedQuadRenderer.glTexCoord2f(tx2, ty1);
                AttributedTextRenderer.this.mPipelinedQuadRenderer.glVertex3f(x + (float)width * scaleFactor, y, z);
                AttributedTextRenderer.this.mPipelinedQuadRenderer.glTexCoord2f(tx2, ty2);
                AttributedTextRenderer.this.mPipelinedQuadRenderer.glVertex3f(x + (float)width * scaleFactor, y + (float)height * scaleFactor, z);
                AttributedTextRenderer.this.mPipelinedQuadRenderer.glTexCoord2f(tx1, ty2);
                AttributedTextRenderer.this.mPipelinedQuadRenderer.glVertex3f(x, y + (float)height * scaleFactor, z);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.advance;
        }

        public void clear() {
            this.glyphRectForTextureMapping = null;
        }

        private void upload() {
            GlyphVector gv = this.getGlyphVector();
            Rectangle2D origBBox = AttributedTextRenderer.preNormalize(AttributedTextRenderer.this.renderDelegate.getBounds(gv, AttributedTextRenderer.this.getFontRenderContext()));
            Rectangle2D bbox = AttributedTextRenderer.this.normalize(origBBox);
            Point origin = new Point((int)(-bbox.getMinX()), (int)(-bbox.getMinY()));
            Rect rect = new Rect(0, 0, (int)bbox.getWidth(), (int)bbox.getHeight(), (Object)new TextData(null, origin, origBBox, this.unicodeID));
            AttributedTextRenderer.this.packer.add(rect);
            this.glyphRectForTextureMapping = rect;
            Graphics2D g = AttributedTextRenderer.this.getGraphics2D();
            int strx = rect.x() + origin.x;
            int stry = rect.y() + origin.y;
            g.setComposite(AlphaComposite.Clear);
            g.fillRect(rect.x(), rect.y(), rect.w(), rect.h());
            g.setComposite(AlphaComposite.Src);
            AttributedTextRenderer.this.renderDelegate.drawGlyphVector(g, gv, strx, stry);
            AttributedTextRenderer.this.getBackingStore().markDirty(rect.x(), rect.y(), rect.w(), rect.h());
            this.producer.register(this);
        }

        private GlyphVector getGlyphVector() {
            GlyphVector gv = this.singleUnicodeGlyphVector;
            if (gv != null) {
                this.singleUnicodeGlyphVector = null;
                return gv;
            }
            ((AttributedTextRenderer)AttributedTextRenderer.this).singleUnicode[0] = (char)this.unicodeID;
            return AttributedTextRenderer.this.font.createGlyphVector(AttributedTextRenderer.this.getFontRenderContext(), AttributedTextRenderer.this.singleUnicode);
        }
    }

    public static class DefaultRenderDelegate
    implements RenderDelegate {
        @Override
        public boolean intensityOnly() {
            return true;
        }

        @Override
        public Rectangle2D getBounds(CharSequence str, Font font, FontRenderContext frc) {
            return this.getBounds(font.createGlyphVector(frc, new CharSequenceIterator(str)), frc);
        }

        @Override
        public Rectangle2D getBounds(String str, Font font, FontRenderContext frc) {
            return this.getBounds(font.createGlyphVector(frc, str), frc);
        }

        @Override
        public Rectangle2D getBounds(GlyphVector gv, FontRenderContext frc) {
            return gv.getVisualBounds();
        }

        @Override
        public void drawGlyphVector(Graphics2D graphics, GlyphVector str, int x, int y) {
            graphics.drawGlyphVector(str, x, y);
        }

        @Override
        public void draw(Graphics2D graphics, String str, int x, int y) {
            graphics.drawString(str, x, y);
        }

        @Override
        public void draw(Graphics2D g, AttributedString str2, int strx, int stry) {
            TextLayout layout = new TextLayout(str2.getIterator(), g.getFontRenderContext());
            layout.draw(g, strx, stry);
        }

        @Override
        public Rectangle2D getBounds(AttributedString str2, Font font, FontRenderContext fontRenderContext) {
            TextLayout layout = new TextLayout(str2.getIterator(), fontRenderContext);
            return layout.getBounds();
        }
    }

    class Manager
    implements BackingStoreManager {
        private Graphics2D g;

        Manager() {
        }

        public Object allocateBackingStore(int w, int h) {
            TextureRenderer renderer = new TextureRenderer(w, h, true, AttributedTextRenderer.this.mipmap);
            renderer.setSmoothing(AttributedTextRenderer.this.smoothing);
            if (DEBUG) {
                System.err.println(" TextRenderer allocating backing store " + w + " x " + h);
            }
            return renderer;
        }

        public void deleteBackingStore(Object backingStore) {
            ((TextureRenderer)backingStore).dispose();
        }

        public boolean preExpand(Rect cause, int attemptNumber) {
            if (attemptNumber == 0) {
                if (DEBUG) {
                    System.err.println("Clearing unused entries in preExpand(): attempt number " + attemptNumber);
                }
                if (AttributedTextRenderer.this.inBeginEndPair) {
                    AttributedTextRenderer.this.flush();
                }
                AttributedTextRenderer.this.clearUnusedEntries();
                return true;
            }
            return false;
        }

        public void additionFailed(Rect cause, int attemptNumber) {
            AttributedTextRenderer.this.packer.clear();
            AttributedTextRenderer.this.stringLocations.clear();
            AttributedTextRenderer.this.mGlyphProducer.clearAllCacheEntries();
            if (DEBUG) {
                System.err.println(" *** Cleared all text because addition failed ***");
            }
        }

        public void beginMovement(Object oldBackingStore, Object newBackingStore) {
            if (AttributedTextRenderer.this.inBeginEndPair) {
                AttributedTextRenderer.this.flush();
                GL gl = GLU.getCurrentGL();
                gl.glPopClientAttrib();
                if (AttributedTextRenderer.this.is15Available(gl)) {
                    try {
                        gl.glBindBuffer(34962, 0);
                    }
                    catch (Exception e) {
                        AttributedTextRenderer.this.isExtensionAvailable_GL_VERSION_1_5 = false;
                    }
                }
                if (AttributedTextRenderer.this.isOrthoMode) {
                    ((TextureRenderer)oldBackingStore).endOrthoRendering();
                } else {
                    ((TextureRenderer)oldBackingStore).end3DRendering();
                }
            }
            TextureRenderer newRenderer = (TextureRenderer)newBackingStore;
            this.g = newRenderer.createGraphics();
        }

        public void move(Object oldBackingStore, Rect oldLocation, Object newBackingStore, Rect newLocation) {
            TextureRenderer oldRenderer = (TextureRenderer)oldBackingStore;
            TextureRenderer newRenderer = (TextureRenderer)newBackingStore;
            if (oldRenderer == newRenderer) {
                this.g.copyArea(oldLocation.x(), oldLocation.y(), oldLocation.w(), oldLocation.h(), newLocation.x() - oldLocation.x(), newLocation.y() - oldLocation.y());
            } else {
                Image img = oldRenderer.getImage();
                this.g.drawImage(img, newLocation.x(), newLocation.y(), newLocation.x() + newLocation.w(), newLocation.y() + newLocation.h(), oldLocation.x(), oldLocation.y(), oldLocation.x() + oldLocation.w(), oldLocation.y() + oldLocation.h(), null);
            }
        }

        public void endMovement(Object oldBackingStore, Object newBackingStore) {
            this.g.dispose();
            TextureRenderer newRenderer = (TextureRenderer)newBackingStore;
            newRenderer.markDirty(0, 0, newRenderer.getWidth(), newRenderer.getHeight());
            if (AttributedTextRenderer.this.inBeginEndPair) {
                if (AttributedTextRenderer.this.isOrthoMode) {
                    ((TextureRenderer)newBackingStore).beginOrthoRendering(AttributedTextRenderer.this.beginRenderingWidth, AttributedTextRenderer.this.beginRenderingHeight, AttributedTextRenderer.this.beginRenderingDepthTestDisabled);
                } else {
                    ((TextureRenderer)newBackingStore).begin3DRendering();
                }
                GL gl = GLU.getCurrentGL();
                gl.glPushClientAttrib(-1);
                if (AttributedTextRenderer.this.haveCachedColor) {
                    if (AttributedTextRenderer.this.cachedColor == null) {
                        ((TextureRenderer)newBackingStore).setColor(AttributedTextRenderer.this.cachedR, AttributedTextRenderer.this.cachedG, AttributedTextRenderer.this.cachedB, AttributedTextRenderer.this.cachedA);
                    } else {
                        ((TextureRenderer)newBackingStore).setColor(AttributedTextRenderer.this.cachedColor);
                    }
                }
            } else {
                AttributedTextRenderer.this.needToResetColor = true;
            }
        }
    }

    static class TextData {
        private String str;
        int unicodeID;
        private Point origin;
        private Rectangle2D origRect;
        private boolean used;

        TextData(String str, Point origin, Rectangle2D origRect, int unicodeID) {
            this.str = str;
            this.origin = origin;
            this.origRect = origRect;
            this.unicodeID = unicodeID;
        }

        String string() {
            return this.str;
        }

        Point origin() {
            return this.origin;
        }

        int origOriginX() {
            return (int)(-this.origRect.getMinX());
        }

        int origOriginY() {
            return (int)(-this.origRect.getMinY());
        }

        Rectangle2D origRect() {
            return this.origRect;
        }

        boolean used() {
            return this.used;
        }

        void markUsed() {
            this.used = true;
        }

        void clearUsed() {
            this.used = false;
        }
    }

    private static class CharSequenceIterator
    implements CharacterIterator {
        CharSequence mSequence;
        int mLength;
        int mCurrentIndex;

        CharSequenceIterator() {
        }

        CharSequenceIterator(CharSequence sequence) {
            this.initFromCharSequence(sequence);
        }

        public void initFromCharSequence(CharSequence sequence) {
            this.mSequence = sequence;
            this.mLength = this.mSequence.length();
            this.mCurrentIndex = 0;
        }

        @Override
        public char last() {
            this.mCurrentIndex = Math.max(0, this.mLength - 1);
            return this.current();
        }

        @Override
        public char current() {
            if (this.mLength == 0 || this.mCurrentIndex >= this.mLength) {
                return '\uffff';
            }
            return this.mSequence.charAt(this.mCurrentIndex);
        }

        @Override
        public char next() {
            ++this.mCurrentIndex;
            return this.current();
        }

        @Override
        public char previous() {
            this.mCurrentIndex = Math.max(this.mCurrentIndex - 1, 0);
            return this.current();
        }

        @Override
        public char setIndex(int position) {
            this.mCurrentIndex = position;
            return this.current();
        }

        @Override
        public int getBeginIndex() {
            return 0;
        }

        @Override
        public int getEndIndex() {
            return this.mLength;
        }

        @Override
        public int getIndex() {
            return this.mCurrentIndex;
        }

        @Override
        public Object clone() {
            CharSequenceIterator iter = new CharSequenceIterator(this.mSequence);
            iter.mCurrentIndex = this.mCurrentIndex;
            return iter;
        }

        @Override
        public char first() {
            if (this.mLength == 0) {
                return '\uffff';
            }
            this.mCurrentIndex = 0;
            return this.current();
        }
    }

    public static interface RenderDelegate {
        public boolean intensityOnly();

        public void draw(Graphics2D var1, AttributedString var2, int var3, int var4);

        public Rectangle2D getBounds(AttributedString var1, Font var2, FontRenderContext var3);

        public Rectangle2D getBounds(String var1, Font var2, FontRenderContext var3);

        public Rectangle2D getBounds(CharSequence var1, Font var2, FontRenderContext var3);

        public Rectangle2D getBounds(GlyphVector var1, FontRenderContext var2);

        public void draw(Graphics2D var1, String var2, int var3, int var4);

        public void drawGlyphVector(Graphics2D var1, GlyphVector var2, int var3, int var4);
    }
}

