/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot.timeline.data;

import com.metsci.glimpse.util.units.time.TimeStamp;

public class Epoch {
    protected TimeStamp epoch;

    public static Epoch posixEpoch() {
        return new Epoch(TimeStamp.posixEpoch());
    }

    public static Epoch currentTime() {
        return new Epoch(TimeStamp.currentTime());
    }

    public Epoch(TimeStamp epoch) {
        this.epoch = epoch;
    }

    public TimeStamp getTimeStamp() {
        return this.epoch;
    }

    public TimeStamp toTimeStamp(double axisValue) {
        return TimeStamp.fromPosixSeconds((double)(axisValue + this.epoch.toPosixSeconds()));
    }

    public double fromTimeStamp(TimeStamp time) {
        return time.toPosixSeconds() - this.epoch.toPosixSeconds();
    }
}

