/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot.timeline;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener1D;
import com.metsci.glimpse.axis.painter.NumericXYAxisPainter;
import com.metsci.glimpse.axis.painter.TimeAxisPainter;
import com.metsci.glimpse.axis.painter.TimeXAxisPainter;
import com.metsci.glimpse.axis.painter.TimeYAxisPainter;
import com.metsci.glimpse.axis.painter.label.GridAxisLabelHandler;
import com.metsci.glimpse.axis.tagged.Constraint;
import com.metsci.glimpse.axis.tagged.Tag;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.layout.GlimpseAxisLayout1D;
import com.metsci.glimpse.layout.GlimpseAxisLayoutX;
import com.metsci.glimpse.layout.GlimpseAxisLayoutY;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.painter.decoration.BorderPainter;
import com.metsci.glimpse.painter.decoration.GridPainter;
import com.metsci.glimpse.painter.group.DelegatePainter;
import com.metsci.glimpse.painter.info.SimpleTextPainter;
import com.metsci.glimpse.plot.StackedPlot2D;
import com.metsci.glimpse.plot.timeline.data.Epoch;
import com.metsci.glimpse.plot.timeline.layout.TimePlotInfo;
import com.metsci.glimpse.plot.timeline.listener.TimelineMouseListener1D;
import com.metsci.glimpse.plot.timeline.listener.TimelineMouseListener2D;
import com.metsci.glimpse.plot.timeline.painter.SelectedTimeRegionPainter;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.font.FontUtils;
import com.metsci.glimpse.util.units.time.Time;
import com.metsci.glimpse.util.units.time.TimeStamp;
import java.awt.Font;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class StackedTimePlot2D
extends StackedPlot2D {
    public static final String MIN_TIME = "min_time";
    public static final String MAX_TIME = "max_time";
    public static final String CURRENT_TIME = "current_time";
    public static final String BACKGROUND = "Timeline Background";
    public static final String TIMELINE = "Timeline";
    protected Tag minTag;
    protected Tag maxTag;
    protected Tag currentTag;
    protected Epoch epoch;
    protected GlimpseAxisLayout1D overlayLayout;
    protected GlimpseAxisLayout1D underlayLayout;
    protected StackedPlot2D.PlotInfo timelineInfo;
    protected GlimpseAxisLayout1D timeLayout;
    protected DelegatePainter timeAxisDelegate;
    protected TimeAxisPainter timeAxisPainter;
    protected StackedPlot2D.PlotInfo selectedLayout;
    protected AxisMouseListener1D timelineMouseListener;
    protected SimpleTextPainter timeUnitsPainter;
    protected BorderPainter timeAxisBorderPainter;
    protected SelectedTimeRegionPainter selectedTimePainter;
    protected boolean allowPanX = true;
    protected boolean allowPanY = true;
    protected boolean allowZoomX = true;
    protected boolean allowZoomY = true;
    protected boolean allowSelectionLock = true;
    protected boolean currentTimeLock;
    protected int labelLayoutSize;
    protected boolean showLabelLayout = false;

    public StackedTimePlot2D() {
        this(StackedPlot2D.Orientation.VERTICAL, Epoch.posixEpoch());
    }

    public StackedTimePlot2D(Epoch epoch) {
        this(StackedPlot2D.Orientation.VERTICAL, epoch);
    }

    public StackedTimePlot2D(StackedPlot2D.Orientation orientation) {
        this(orientation, Epoch.posixEpoch());
    }

    public StackedTimePlot2D(StackedPlot2D.Orientation orientation, Epoch epoch) {
        super(orientation);
        this.epoch = epoch;
        this.initializeTimePlot();
    }

    public GlimpseAxisLayout1D getOverlayLayout() {
        return this.overlayLayout;
    }

    public GlimpseAxisLayout1D getUnderlayLayout() {
        return this.underlayLayout;
    }

    public GlimpseAxisLayout1D getTimelineLayout() {
        return this.timeLayout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TimePlotInfo> getAllTimePlots() {
        this.lock.lock();
        try {
            LinkedList<TimePlotInfo> list = new LinkedList<TimePlotInfo>();
            for (StackedPlot2D.PlotInfo plot : this.getAllPlots()) {
                if (!(plot instanceof TimePlotInfo)) continue;
                list.add((TimePlotInfo)plot);
            }
            LinkedList<TimePlotInfo> linkedList = list;
            return linkedList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimePlotInfo getTimePlot(String name) {
        this.lock.lock();
        try {
            StackedPlot2D.PlotInfo plot = this.getPlot(name);
            if (plot instanceof TimePlotInfo) {
                TimePlotInfo timePlotInfo = (TimePlotInfo)plot;
                return timePlotInfo;
            }
            TimePlotInfo timePlotInfo = null;
            return timePlotInfo;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setSelectedPlot(String name) {
        this.setSelectedPlot(this.getPlot(name));
    }

    public void setSelectedPlot(StackedPlot2D.PlotInfo layout) {
        this.selectedLayout = layout;
    }

    public StackedPlot2D.PlotInfo getSelectedPlot() {
        return this.selectedLayout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimelineMouseListener1D(AxisMouseListener1D listener) {
        this.lock.lock();
        try {
            if (this.timelineMouseListener != null) {
                this.timeLayout.removeGlimpseMouseAllListener(this.timelineMouseListener);
            }
            this.timelineMouseListener = listener;
            if (this.timelineMouseListener != null) {
                this.timeLayout.addGlimpseMouseAllListener(this.timelineMouseListener);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public AxisMouseListener1D getTimelineMouseListener1D() {
        return this.timelineMouseListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowSelectionLock(boolean lock) {
        this.lock.lock();
        try {
            this.allowSelectionLock = lock;
            this.timelineMouseListener.setAllowSelectionLock(lock);
            for (TimePlotInfo info : this.getAllTimePlots()) {
                info.getTimelineMouseListener().setAllowSelectionLock(lock);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowZoomY(boolean lock) {
        this.lock.lock();
        try {
            this.allowZoomY = lock;
            if (this.getOrientation() == StackedPlot2D.Orientation.HORIZONTAL) {
                this.timelineMouseListener.setAllowZoom(lock);
            }
            for (TimePlotInfo info : this.getAllTimePlots()) {
                info.getTimelineMouseListener().setAllowZoomY(lock);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowZoomX(boolean lock) {
        this.lock.lock();
        try {
            this.allowZoomX = lock;
            if (this.getOrientation() == StackedPlot2D.Orientation.VERTICAL) {
                this.timelineMouseListener.setAllowZoom(lock);
            }
            for (TimePlotInfo info : this.getAllTimePlots()) {
                info.getTimelineMouseListener().setAllowZoomX(lock);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowPanY(boolean lock) {
        this.lock.lock();
        try {
            this.allowPanY = lock;
            if (this.getOrientation() == StackedPlot2D.Orientation.HORIZONTAL) {
                this.timelineMouseListener.setAllowPan(lock);
            }
            for (TimePlotInfo info : this.getAllTimePlots()) {
                info.getTimelineMouseListener().setAllowPanY(lock);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowPanX(boolean lock) {
        this.lock.lock();
        try {
            this.allowPanX = lock;
            if (this.getOrientation() == StackedPlot2D.Orientation.VERTICAL) {
                this.timelineMouseListener.setAllowPan(lock);
            }
            for (TimePlotInfo info : this.getAllTimePlots()) {
                info.getTimelineMouseListener().setAllowPanX(lock);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeAxisPainter(TimeAxisPainter painter) {
        this.lock.lock();
        try {
            this.timeAxisDelegate.removePainter(this.timeAxisPainter);
            this.timeAxisPainter = painter;
            this.timeAxisDelegate.addPainter(this.timeAxisPainter);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Tag getTimeSelection() {
        return this.currentTag;
    }

    public Tag getTimeSelectionMin() {
        return this.minTag;
    }

    public Tag getTimeSelectionMax() {
        return this.maxTag;
    }

    public Epoch getEpoch() {
        return this.epoch;
    }

    public void setEpoch(Epoch epoch) {
        this.epoch = epoch;
        this.timeAxisPainter.setEpoch(epoch);
    }

    public TimeStamp toTimeStamp(double value) {
        return this.epoch.toTimeStamp(value);
    }

    public double fromTimeStamp(TimeStamp value) {
        return this.epoch.fromTimeStamp(value);
    }

    public TaggedAxis1D getTimeAxis() {
        return (TaggedAxis1D)this.commonAxis;
    }

    public TimeAxisPainter getTimeAxisPainter() {
        return this.timeAxisPainter;
    }

    public SimpleTextPainter getTimeUnitsPainter() {
        return this.timeUnitsPainter;
    }

    public BorderPainter getTimeAxisBorderPainter() {
        return this.timeAxisBorderPainter;
    }

    public SelectedTimeRegionPainter getSelectedTimePainter() {
        return this.selectedTimePainter;
    }

    public StackedPlot2D.PlotInfo getTimelinePlotInfo() {
        return this.timelineInfo;
    }

    public void setAxisColor(float[] rgba) {
        this.timeAxisPainter.setTextColor(rgba);
        this.timeAxisPainter.setTickColor(rgba);
    }

    public void setAxisFont(Font font) {
        this.timeAxisPainter.setFont(font);
    }

    public void setShowCurrentTime(boolean show) {
        this.timeAxisPainter.showCurrentTimeLabel(show);
    }

    public void setCurrentTimeColor(float[] rgba) {
        this.timeAxisPainter.setCurrentTimeTextColor(rgba);
        this.timeAxisPainter.setCurrentTimeTickColor(rgba);
    }

    public void setLabelSize(int size) {
        this.labelLayoutSize = size;
        this.validateLayout();
    }

    public void showLabels(boolean show) {
        this.showLabelLayout = show;
        this.validateLayout();
    }

    public boolean isTimeAxisHorizontal() {
        return this.getOrientation() == StackedPlot2D.Orientation.VERTICAL;
    }

    public GlimpseTargetStack pushLayoutTargetStack(GlimpseTargetStack stack, String name) {
        stack = this.pushPlotTargetStack(stack);
        StackedPlot2D.PlotInfo plot = this.getPlot(name);
        stack.push(plot.getLayout());
        return stack;
    }

    public GlimpseTargetStack pushPlotTargetStack(GlimpseTargetStack stack) {
        stack.push(this);
        return stack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePlot(String name) {
        this.lock.lock();
        try {
            StackedPlot2D.PlotInfo info = (StackedPlot2D.PlotInfo)this.stackedPlots.get(name);
            if (info == null) {
                return;
            }
            if (info instanceof TimePlotInfo) {
                TimePlotInfo timeInfo = (TimePlotInfo)info;
                this.removeLayout(info.getLayout());
                this.removeLayout(timeInfo.getLabelLayout());
                this.stackedPlots.remove(name);
                this.validate();
            } else {
                this.removeLayout(info.getLayout());
                this.stackedPlots.remove(name);
                this.validate();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public StackedPlot2D.PlotInfo createPlot(String name) {
        return this.createPlot(name, new Axis1D());
    }

    @Override
    public StackedPlot2D.PlotInfo createPlot(String name, Axis1D axis) {
        StackedPlot2D.PlotInfo layoutInfo = super.createPlot(name, axis);
        this.attachTimelineMouseListener(layoutInfo);
        return layoutInfo;
    }

    public TimePlotInfo createTimePlot(String name) {
        return this.createTimePlot(name, new Axis1D());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimePlotInfo createTimePlot(String name, Axis1D axis) {
        this.lock.lock();
        try {
            StackedPlot2D.PlotInfo plotInfo = this.createPlot0(name, axis);
            TimePlotInfo timePlotInfo = this.createTimePlot0(plotInfo);
            this.stackedPlots.put(name, timePlotInfo);
            this.validate();
            TimePlotInfo timePlotInfo2 = timePlotInfo;
            return timePlotInfo2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isLocked() {
        return this.isSelectionLocked() || this.isCurrentTimeLocked();
    }

    public boolean isSelectionLocked() {
        return this.getTimeAxis().isSelectionLocked();
    }

    public void setSelectionLocked(boolean lock) {
        this.getTimeAxis().setSelectionLock(lock);
        this.getTimeAxis().validate();
    }

    public boolean isCurrentTimeLocked() {
        return this.currentTimeLock;
    }

    public void setCurrentTimeLocked(boolean lock) {
        this.currentTimeLock = lock;
        if (lock) {
            double maxValue = this.maxTag.getValue();
            TimeStamp maxTime = this.epoch.toTimeStamp(maxValue);
            this.shiftTimeSelection(maxTime);
            this.shiftTimeAxisBounds(maxTime);
            this.getTimeAxis().lockMax(maxValue);
        } else {
            this.getTimeAxis().unlockMax();
        }
        this.getTimeAxis().validate();
    }

    public void setTimeSelection(TimeStamp minTime, TimeStamp selectedTime, TimeStamp maxTime) {
        this.minTag.setValue(this.epoch.fromTimeStamp(minTime));
        this.maxTag.setValue(this.epoch.fromTimeStamp(maxTime));
        this.currentTag.setValue(this.epoch.fromTimeStamp(selectedTime));
        TaggedAxis1D axis = this.getTimeAxis();
        axis.validateTags();
        axis.validate();
        if (this.isCurrentTimeLocked()) {
            this.shiftTimeAxisBounds(maxTime);
        }
    }

    public void setTimeAxisBounds(TimeStamp minTime, TimeStamp maxTime) {
        TaggedAxis1D axis = this.getTimeAxis();
        axis.setMax(this.epoch.fromTimeStamp(maxTime));
        axis.setMin(this.epoch.fromTimeStamp(minTime));
        axis.validate();
        if (this.isCurrentTimeLocked()) {
            this.shiftTimeSelection(maxTime);
        }
    }

    public void shiftTimeAxisBounds(TimeStamp maxTime) {
        TaggedAxis1D axis = this.getTimeAxis();
        double diff = axis.getMax() - axis.getMin();
        double max = this.epoch.fromTimeStamp(maxTime);
        axis.setMax(max);
        axis.setMin(max - diff);
        axis.validate();
    }

    public void setTimeSelection(TimeStamp minTime, TimeStamp maxTime) {
        this.setTimeSelection(minTime, maxTime, maxTime);
    }

    public void shiftTimeSelection(TimeStamp maxTime) {
        double diff = Time.fromSeconds((double)(this.maxTag.getValue() - this.minTag.getValue()));
        TimeStamp minTime = maxTime.subtract(diff);
        this.setTimeSelection(minTime, maxTime, maxTime);
    }

    protected void initializeTimePlot() {
        TaggedAxis1D timeAxis = this.getTimeAxis();
        this.timelineMouseListener = new TimelineMouseListener1D(this);
        this.addTimeTags(this.getTimeAxis());
        this.minTag = timeAxis.getTag(MIN_TIME);
        this.maxTag = timeAxis.getTag(MAX_TIME);
        this.currentTag = timeAxis.getTag(CURRENT_TIME);
        this.timelineInfo = this.createPlot(TIMELINE);
        if (this.isTimeAxisHorizontal()) {
            this.timelineInfo.setSize(45);
            this.timelineInfo.setOrder(Integer.MAX_VALUE);
            this.timeLayout = new GlimpseAxisLayoutX(this.timelineInfo.getLayout());
            this.labelLayoutSize = 30;
        } else {
            this.timelineInfo.setSize(60);
            this.timelineInfo.setOrder(Integer.MIN_VALUE);
            this.timeLayout = new GlimpseAxisLayoutY(this.timelineInfo.getLayout());
            this.labelLayoutSize = 30;
        }
        this.timeLayout.addGlimpseMouseAllListener(this.timelineMouseListener);
        this.timeAxisPainter = this.createTimeAxisPainter();
        this.timeAxisPainter.setFont(FontUtils.getDefaultPlain(12.0f), false);
        this.timeAxisPainter.showCurrentTimeLabel(false);
        this.timeAxisPainter.setCurrentTimeTickColor(GlimpseColor.getGreen());
        this.setBorderSize(0);
        this.timeAxisDelegate = new DelegatePainter();
        this.timeAxisDelegate.addPainter(this.timeAxisPainter);
        this.timeLayout.addPainter(this.timeAxisDelegate);
        this.timeUnitsPainter = new SimpleTextPainter();
        this.timeUnitsPainter.setHorizontalPosition(SimpleTextPainter.HorizontalPosition.Right);
        this.timeUnitsPainter.setVerticalPosition(SimpleTextPainter.VerticalPosition.Bottom);
        this.timeUnitsPainter.setColor(GlimpseColor.getBlack());
        this.timeUnitsPainter.setFont(FontUtils.getDefaultBold(12.0f));
        this.timeUnitsPainter.setText("GMT");
        this.timeUnitsPainter.setBackgroundColor(GlimpseColor.getYellow());
        this.timeUnitsPainter.setPaintBackground(true);
        this.timeAxisBorderPainter = new BorderPainter().setColor(GlimpseColor.fromColorRgba(0.8f, 0.8f, 0.8f, 1.0f));
        this.timeLayout.addPainter(this.timeUnitsPainter);
        this.timeLayout.addPainter(this.timeAxisBorderPainter);
        if (this.isTimeAxisHorizontal()) {
            this.overlayLayout = new GlimpseAxisLayoutX(this, "Overlay", timeAxis);
            this.underlayLayout = new GlimpseAxisLayoutX(this, "Underlay", timeAxis);
        } else {
            this.overlayLayout = new GlimpseAxisLayoutY(this, "Overlay", timeAxis);
            this.underlayLayout = new GlimpseAxisLayoutY(this, "Underlay", timeAxis);
        }
        this.selectedTimePainter = new SelectedTimeRegionPainter(this);
        this.overlayLayout.setEventGenerator(true);
        this.overlayLayout.setEventConsumer(false);
        this.overlayLayout.addPainter(this.selectedTimePainter);
        this.setZOrder(this.overlayLayout, Integer.MAX_VALUE);
        this.setZOrder(this.underlayLayout, Integer.MIN_VALUE);
        this.validate();
    }

    protected TimelineMouseListener2D attachTimelineMouseListener(StackedPlot2D.PlotInfo layoutInfo) {
        TimelineMouseListener2D mouseListener = new TimelineMouseListener2D(this, layoutInfo, this.timelineMouseListener);
        mouseListener.setAllowPanX(this.allowPanX);
        mouseListener.setAllowPanY(this.allowPanY);
        mouseListener.setAllowZoomX(this.allowZoomX);
        mouseListener.setAllowZoomY(this.allowZoomY);
        mouseListener.setAllowSelectionLock(this.allowSelectionLock);
        layoutInfo.getLayout().addGlimpseMouseAllListener(mouseListener);
        return mouseListener;
    }

    protected TimeAxisPainter createTimeAxisPainter() {
        TimeAxisPainter painter = this.isTimeAxisHorizontal() ? new TimeXAxisPainter(this.epoch) : new TimeYAxisPainter(this.epoch);
        painter.setFont(FontUtils.getDefaultPlain(12.0f), false);
        painter.showCurrentTimeLabel(false);
        painter.setCurrentTimeTickColor(GlimpseColor.getGreen());
        return painter;
    }

    protected void addTimeTags(TaggedAxis1D axis) {
        axis.addTag(MIN_TIME, 0.0);
        axis.addTag(MAX_TIME, 10.0);
        axis.addTag(CURRENT_TIME, 10.0);
        axis.addConstraint(new Constraint(){

            @Override
            public void applyConstraint(TaggedAxis1D axis) {
                Tag minTag = axis.getTag(StackedTimePlot2D.MIN_TIME);
                Tag maxTag = axis.getTag(StackedTimePlot2D.MAX_TIME);
                Tag currentTag = axis.getTag(StackedTimePlot2D.CURRENT_TIME);
                double minValue = minTag.getValue();
                double maxValue = maxTag.getValue();
                double currentValue = currentTag.getValue();
                if (minValue > maxValue) {
                    minTag.setValue(maxValue);
                }
                if (currentValue < minValue) {
                    currentTag.setValue(minValue);
                } else if (currentValue > maxValue) {
                    currentTag.setValue(maxValue);
                }
            }

            @Override
            public String getName() {
                return "order";
            }
        });
    }

    @Override
    protected TaggedAxis1D createCommonAxis() {
        return new TaggedAxis1D();
    }

    protected TimePlotInfo createTimePlot0(StackedPlot2D.PlotInfo layoutInfo) {
        GridAxisLabelHandler labelHandler = new GridAxisLabelHandler(){

            @Override
            protected String tickString(double number, int orderAxis) {
                return this.tickNumberFormatter.format(number);
            }

            @Override
            protected void updateFormatter(int orderAxis, int orderTick) {
                this.tickNumberFormatter.setMaximumFractionDigits(Math.abs(orderTick));
            }
        };
        DelegatePainter dataPainter = new DelegatePainter();
        layoutInfo.getLayout().addPainter(dataPainter);
        GridPainter gridPainter = new GridPainter(labelHandler, labelHandler);
        gridPainter.setShowMinorGrid(false);
        layoutInfo.getLayout().addPainter(gridPainter);
        NumericXYAxisPainter axisPainter = new NumericXYAxisPainter(labelHandler, labelHandler);
        axisPainter.setFont(FontUtils.getDefaultPlain(9.0f), false);
        axisPainter.setShowLabelsNearOrigin(true);
        axisPainter.setShowOriginLabel(true);
        layoutInfo.getLayout().addPainter(axisPainter);
        BorderPainter borderPainter = new BorderPainter();
        layoutInfo.getLayout().addPainter(borderPainter);
        TimelineMouseListener2D listener = this.attachTimelineMouseListener(layoutInfo);
        GlimpseLayout labelLayout = new GlimpseLayout(layoutInfo.getId() + "-label");
        this.addLayout(labelLayout);
        SimpleTextPainter labelPainter = new SimpleTextPainter();
        labelPainter.setHorizontalPosition(SimpleTextPainter.HorizontalPosition.Center);
        labelPainter.setVerticalPosition(SimpleTextPainter.VerticalPosition.Center);
        labelPainter.setFont(FontUtils.getDefaultBold(9.0f), false);
        labelPainter.setPadding(2);
        labelPainter.setText("");
        labelPainter.setHorizontalLabels(false);
        labelLayout.addPainter(labelPainter);
        BorderPainter labelBorderPainter = new BorderPainter();
        labelLayout.addPainter(labelBorderPainter);
        TimePlotInfo timePlotInfo = new TimePlotInfo(this, layoutInfo, labelLayout, listener, gridPainter, axisPainter, labelPainter, borderPainter, labelBorderPainter, dataPainter);
        if (this.isTimeAxisHorizontal()) {
            gridPainter.setShowVerticalLines(false);
            labelHandler.setTickSpacing(16);
            axisPainter.setShowVerticalTicks(true);
            axisPainter.setShowHorizontalTicks(false);
            axisPainter.setLockLeft(true);
        } else {
            gridPainter.setShowHorizontalLines(false);
            labelHandler.setTickSpacing(45);
            axisPainter.setShowVerticalTicks(false);
            axisPainter.setShowHorizontalTicks(true);
            axisPainter.setLockTop(true);
        }
        return timePlotInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updatePainterLayout() {
        this.lock.lock();
        try {
            List<StackedPlot2D.PlotInfo> axisList = this.getSortedAxes(this.stackedPlots.values());
            this.layout.setLayoutConstraints(String.format("bottomtotop, gapx 0, gapy 0, insets %d %d %d %d", this.outerBorder, this.outerBorder, this.outerBorder, this.outerBorder));
            for (int i = 0; i < axisList.size(); ++i) {
                TimePlotInfo timeInfo;
                String layout;
                String format;
                StackedPlot2D.PlotInfo info = axisList.get(i);
                if (this.isTimeAxisHorizontal()) {
                    if (info.getSize() < 0) {
                        format = "cell %d %d 1 1, push, grow, id i%2$d";
                        layout = String.format(format, 1, i);
                        info.getLayout().setLayoutData(layout);
                        if (!(info instanceof TimePlotInfo)) continue;
                        timeInfo = (TimePlotInfo)info;
                        format = "cell %d %d 1 1, pushy, growy, width %d!";
                        layout = String.format(format, 0, i, this.showLabelLayout ? this.labelLayoutSize : 0);
                        timeInfo.getLabelLayout().setLayoutData(layout);
                        timeInfo.getLabelLayout().setVisible(this.showLabelLayout);
                        continue;
                    }
                    format = "cell %d %d 1 1, pushx, growx, height %d!, id i%2$d";
                    layout = String.format(format, 1, i, info.getSize());
                    info.getLayout().setLayoutData(layout);
                    if (!(info instanceof TimePlotInfo)) continue;
                    timeInfo = (TimePlotInfo)info;
                    format = "cell %d %d 1 1, width %d!, height %d!";
                    layout = String.format(format, 0, i, this.showLabelLayout ? this.labelLayoutSize : 0, info.getSize());
                    timeInfo.getLabelLayout().setLayoutData(layout);
                    timeInfo.getLabelLayout().setVisible(this.showLabelLayout);
                    continue;
                }
                if (info.getSize() < 0) {
                    format = "cell %d %d 1 1, push, grow, id i%1$d";
                    layout = String.format(format, i, 1);
                    info.getLayout().setLayoutData(layout);
                    if (!(info instanceof TimePlotInfo)) continue;
                    timeInfo = (TimePlotInfo)info;
                    format = "cell %d %d 1 1, pushx, growx, height %d!";
                    layout = String.format(format, i, 0, this.showLabelLayout ? this.labelLayoutSize : 0);
                    timeInfo.getLabelLayout().setLayoutData(layout);
                    timeInfo.getLabelLayout().setVisible(this.showLabelLayout);
                    continue;
                }
                format = "cell %d %d 1 1, pushy, growy, width %d!, id i%1$d";
                layout = String.format(format, i, 1, info.getSize());
                info.getLayout().setLayoutData(layout);
                if (!(info instanceof TimePlotInfo)) continue;
                timeInfo = (TimePlotInfo)info;
                format = "cell %d %d 1 1, height %d!, width %d!";
                layout = String.format(format, i, 0, this.showLabelLayout ? this.labelLayoutSize : 0, info.getSize());
                timeInfo.getLabelLayout().setLayoutData(layout);
                timeInfo.getLabelLayout().setVisible(this.showLabelLayout);
            }
            if (this.overlayLayout != null) {
                if (this.isTimeAxisHorizontal()) {
                    String layout = String.format("pos i%1$d.x i%1$d.y i0.x2 i0.y2", axisList.size() - 1);
                    this.overlayLayout.setLayoutData(layout);
                    this.underlayLayout.setLayoutData(layout);
                } else {
                    String layout = String.format("pos i0.x i0.y i%1$d.x2 i%1$d.y2", axisList.size() - 1);
                    this.overlayLayout.setLayoutData(layout);
                    this.underlayLayout.setLayoutData(layout);
                }
            }
            this.invalidateLayout();
        }
        finally {
            this.lock.unlock();
        }
    }
}

