/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.layout.GlimpseLayoutManagerMig;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.decoration.BackgroundPainter;
import com.metsci.glimpse.support.settings.DefaultLookAndFeel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StackedPlot2D
extends GlimpseLayout {
    protected int outerBorder = 10;
    protected Axis1D commonAxis;
    protected GlimpseLayoutManagerMig layout;
    protected Map<String, PlotInfo> stackedPlots;
    protected BackgroundPainter backgroundPainter;
    protected Orientation orientation = Orientation.VERTICAL;

    public StackedPlot2D(Orientation orientation) {
        this.orientation = orientation;
        this.initializePlot();
    }

    public StackedPlot2D() {
        this(Orientation.VERTICAL);
    }

    protected void initializePlot() {
        this.initializeAxes();
        this.initializeArrays();
        this.initializeLayout();
        this.initializePainters();
        this.initializeLookAndFeel();
        this.updatePainterLayout();
    }

    protected void initializeAxes() {
        this.commonAxis = this.createCommonAxis();
    }

    protected Axis1D createCommonAxis() {
        return new Axis1D();
    }

    protected void initializeArrays() {
        this.stackedPlots = new LinkedHashMap<String, PlotInfo>();
    }

    protected void initializeLayout() {
        this.layout = new GlimpseLayoutManagerMig();
        this.setLayoutManager(this.layout);
    }

    protected void initializePainters() {
        this.backgroundPainter = new BackgroundPainter(false);
        this.addPainter((GlimpsePainter)this.backgroundPainter, Integer.MIN_VALUE);
    }

    protected void initializeLookAndFeel() {
        this.setLookAndFeel(new DefaultLookAndFeel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePainterLayout() {
        this.lock.lock();
        try {
            this.layout.setLayoutConstraints(String.format("bottomtotop, gapx 0, gapy 0, insets %d %d %d %d", this.outerBorder, this.outerBorder, this.outerBorder, this.outerBorder));
            List<PlotInfo> axisList = this.getSortedAxes(this.stackedPlots.values());
            for (int i = 0; i < axisList.size(); ++i) {
                String layout;
                String format;
                PlotInfo info = axisList.get(i);
                if (info.getSize() < 0) {
                    format = "cell %d %d 1 1, push, grow";
                    layout = this.orientation == Orientation.HORIZONTAL ? String.format(format, i, 0) : String.format(format, 0, i);
                    info.getLayout().setLayoutData(layout);
                    continue;
                }
                if (this.orientation == Orientation.HORIZONTAL) {
                    format = "cell %d %d 1 1, pushy, growy, width %d!";
                    layout = String.format(format, i, 0, info.getSize());
                    info.getLayout().setLayoutData(layout);
                    continue;
                }
                if (this.orientation != Orientation.VERTICAL) continue;
                format = "cell %d %d 1 1, pushx, growx, height %d!";
                layout = String.format(format, 0, i, info.getSize());
                info.getLayout().setLayoutData(layout);
            }
            this.invalidateLayout();
        }
        finally {
            this.lock.unlock();
        }
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public Axis1D getCommonAxis() {
        return this.commonAxis;
    }

    public PlotInfo getPlot(String name) {
        return this.stackedPlots.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PlotInfo> getAllPlots() {
        this.lock.lock();
        try {
            Collection<PlotInfo> collection = Collections.unmodifiableCollection(this.stackedPlots.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setBackgroundColor(float[] color) {
        this.backgroundPainter.setColor(color);
    }

    public void setBorderSize(int size) {
        this.outerBorder = size;
        this.validate();
    }

    public void validate() {
        this.validateLayout();
        this.validateAxes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateAxes() {
        this.lock.lock();
        try {
            this.commonAxis.validate();
            for (PlotInfo info : this.stackedPlots.values()) {
                info.getLayout().getAxis().getAxisX().validate();
                info.getLayout().getAxis().getAxisY().validate();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void validateLayout() {
        this.updatePainterLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePlot(String name) {
        this.lock.lock();
        try {
            PlotInfo info = this.stackedPlots.get(name);
            if (info == null) {
                return;
            }
            this.removeLayout(info.getLayout());
            this.stackedPlots.remove(name);
            this.validate();
        }
        finally {
            this.lock.unlock();
        }
    }

    public PlotInfo createPlot(String name) {
        return this.createPlot(name, new Axis1D());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlotInfo createPlot(String name, Axis1D axis) {
        this.lock.lock();
        try {
            PlotInfo info = this.createPlot0(name, axis);
            this.stackedPlots.put(name, info);
            this.validate();
            PlotInfo plotInfo = info;
            return plotInfo;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String toString() {
        return StackedPlot2D.class.getSimpleName();
    }

    protected List<PlotInfo> getSortedAxes(Collection<PlotInfo> unsorted) {
        ArrayList<PlotInfo> sortedList = new ArrayList<PlotInfo>();
        sortedList.addAll(unsorted);
        Collections.sort(sortedList, new Comparator<PlotInfo>(){

            @Override
            public int compare(PlotInfo axis0, PlotInfo axis1) {
                if (axis0.getOrder() < axis1.getOrder()) {
                    return -1;
                }
                if (axis0.getOrder() > axis1.getOrder()) {
                    return 1;
                }
                return 0;
            }
        });
        return sortedList;
    }

    protected Axis1D getCommonAxis(Axis2D axis) {
        return this.orientation == Orientation.HORIZONTAL ? axis.getAxisY() : axis.getAxisX();
    }

    protected Axis1D getOrthogonalAxis(Axis2D axis) {
        return this.orientation == Orientation.HORIZONTAL ? axis.getAxisX() : axis.getAxisY();
    }

    protected PlotInfo createPlot0(String name, Axis1D axis) {
        if (this.stackedPlots.containsKey(name)) {
            throw new IllegalArgumentException("Plot ID: " + name + " already exists.");
        }
        int order = 0;
        int size = -1;
        Axis1D commonChildAxis = this.commonAxis.clone();
        Axis2D axis2D = this.orientation == Orientation.HORIZONTAL ? new Axis2D(axis, commonChildAxis) : new Axis2D(commonChildAxis, axis);
        GlimpseAxisLayout2D layout = new GlimpseAxisLayout2D(null, name, axis2D);
        this.addLayout(layout);
        PlotInfoImpl info = new PlotInfoImpl(this, name, order, size, layout);
        return info;
    }

    public static class PlotInfoImpl
    implements PlotInfo {
        protected String id;
        protected int order;
        protected int size;
        protected GlimpseAxisLayout2D layout;
        protected StackedPlot2D parent;

        public PlotInfoImpl(StackedPlot2D parent, String id, int order, int size, GlimpseAxisLayout2D layout) {
            this.parent = parent;
            this.id = id;
            this.order = order;
            this.size = size;
            this.layout = layout;
        }

        @Override
        public StackedPlot2D getStackedPlot() {
            return this.parent;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public int getOrder() {
            return this.order;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public void setOrder(int order) {
            this.order = order;
            this.parent.validate();
        }

        @Override
        public void setSize(int size) {
            this.size = size;
            this.parent.validate();
        }

        @Override
        public GlimpseAxisLayout2D getLayout() {
            return this.layout;
        }

        @Override
        public Axis1D getCommonAxis(GlimpseTargetStack stack) {
            return this.parent.getCommonAxis(this.layout.getAxis(stack));
        }

        @Override
        public Axis1D getOrthogonalAxis(GlimpseTargetStack stack) {
            return this.parent.getOrthogonalAxis(this.layout.getAxis(stack));
        }

        @Override
        public Axis1D getCommonAxis() {
            return this.parent.getCommonAxis(this.layout.getAxis());
        }

        @Override
        public Axis1D getOrthogonalAxis() {
            return this.parent.getOrthogonalAxis(this.layout.getAxis());
        }

        @Override
        public void addLayout(GlimpseAxisLayout2D childLayout) {
            if (childLayout.getAxis() != null) {
                Axis1D childCommonAxis = this.parent.getCommonAxis(childLayout.getAxis());
                Axis1D parentCommonAxis = this.parent.getCommonAxis(this.layout.getAxis());
                childCommonAxis.setParent(parentCommonAxis);
            }
            this.layout.addLayout(childLayout);
        }
    }

    public static interface PlotInfo {
        public StackedPlot2D getStackedPlot();

        public String getId();

        public int getOrder();

        public int getSize();

        public void setOrder(int var1);

        public void setSize(int var1);

        public GlimpseAxisLayout2D getLayout();

        public Axis1D getCommonAxis(GlimpseTargetStack var1);

        public Axis1D getOrthogonalAxis(GlimpseTargetStack var1);

        public Axis1D getCommonAxis();

        public Axis1D getOrthogonalAxis();

        public void addLayout(GlimpseAxisLayout2D var1);
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

