/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener;
import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener1D;
import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener2D;
import com.metsci.glimpse.axis.painter.NumericAxisPainter;
import com.metsci.glimpse.axis.painter.NumericRightYAxisPainter;
import com.metsci.glimpse.axis.painter.NumericTopXAxisPainter;
import com.metsci.glimpse.axis.painter.NumericXAxisPainter;
import com.metsci.glimpse.axis.painter.NumericYAxisPainter;
import com.metsci.glimpse.axis.painter.label.AxisLabelHandler;
import com.metsci.glimpse.axis.painter.label.GridAxisLabelHandler;
import com.metsci.glimpse.event.mouse.Mouseable;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;
import com.metsci.glimpse.layout.GlimpseAxisLayoutX;
import com.metsci.glimpse.layout.GlimpseAxisLayoutY;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.layout.GlimpseLayoutManagerMig;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.decoration.BackgroundPainter;
import com.metsci.glimpse.painter.group.DelegatePainter;
import com.metsci.glimpse.painter.info.SimpleTextPainter;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.font.FontUtils;
import com.metsci.glimpse.support.settings.AbstractLookAndFeel;
import com.metsci.glimpse.support.settings.DefaultLookAndFeel;
import com.metsci.glimpse.support.settings.LookAndFeel;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiAxisPlot2D
extends GlimpseLayout {
    protected int outerBorder = 10;
    protected int titleSpacing = 50;
    protected int innerSpacing = 0;
    protected Map<String, AxisInfo> axesTopX;
    protected Map<String, AxisInfo> axesBottomX;
    protected Map<String, AxisInfo> axesRightY;
    protected Map<String, AxisInfo> axesLeftY;
    protected Map<String, AxisInfo> axesAll;
    protected Axis1D centerAxisX;
    protected Axis1D centerAxisY;
    protected GlimpseLayoutManagerMig layout;
    protected GlimpseLayout titleLayout;
    protected SimpleTextPainter titlePainter;
    protected String title = null;
    protected boolean showTitle = false;
    protected BackgroundPainter plotBackgroundPainter;
    protected BackgroundPainter backgroundPainter;
    protected LookAndFeel laf;
    protected GlimpseAxisLayout2D axisLayoutXY;
    protected AxisMouseListener mouseListenerXY;

    public MultiAxisPlot2D() {
        this.initialize();
    }

    protected void initialize() {
        this.initializeArrays();
        this.initializeLayout();
        this.initializePainters();
        this.initializeLookAndFeel();
        this.updatePainterLayout();
    }

    protected void initializeArrays() {
        this.axesTopX = new HashMap<String, AxisInfo>();
        this.axesBottomX = new HashMap<String, AxisInfo>();
        this.axesRightY = new HashMap<String, AxisInfo>();
        this.axesLeftY = new HashMap<String, AxisInfo>();
        this.axesAll = new HashMap<String, AxisInfo>();
        this.centerAxisX = new Axis1D();
        this.centerAxisY = new Axis1D();
    }

    protected void initializeLayout() {
        this.layout = new GlimpseLayoutManagerMig();
        this.setLayoutManager(this.layout);
    }

    protected void updatePainterLayout() {
        AxisInfo axis;
        int i;
        int t = this.axesTopX.size();
        int b = this.axesBottomX.size();
        int r = this.axesRightY.size();
        int l = this.axesLeftY.size();
        this.layout.setLayoutConstraints(String.format("bottomtotop, gapx 0, gapy 0, insets %d %d %d %d", this.getTopInset(), this.outerBorder, this.outerBorder, this.outerBorder));
        this.titleLayout.setLayoutData(String.format("cell %d %d 1 1, pushx, growx, height %d!", l, 0, this.isTitleVisible() ? this.titleSpacing : 0));
        this.axisLayoutXY.setLayoutData(String.format("cell %d %d 1 1, push, grow", l, t + 1));
        List<AxisInfo> axisList = this.getSortedAxes(this.axesTopX.values());
        for (i = 0; i < t; ++i) {
            axis = axisList.get(i);
            axis.getLayout().setLayoutData(String.format("cell %d %d 1 1, pushx, growx, height %d!", l, i + 1, axis.getSize()));
        }
        axisList = this.getSortedAxes(this.axesBottomX.values());
        for (i = 0; i < b; ++i) {
            axis = axisList.get(i);
            axis.getLayout().setLayoutData(String.format("cell %d %d 1 1, pushx, growx, height %d!", l, t + 2 + i, axis.getSize()));
        }
        axisList = this.getSortedAxes(this.axesLeftY.values());
        for (i = 0; i < l; ++i) {
            axis = axisList.get(i);
            axis.getLayout().setLayoutData(String.format("cell %d %d 1 1, pushy, growy, width %d!", i, t + 1, axis.getSize()));
        }
        axisList = this.getSortedAxes(this.axesRightY.values());
        for (i = 0; i < r; ++i) {
            axis = axisList.get(i);
            axis.getLayout().setLayoutData(String.format("cell %d %d 1 1, pushy, growy, width %d!", l + 1 + i, t + 1, axis.getSize()));
        }
        this.invalidateLayout();
    }

    protected void initializePainters() {
        this.backgroundPainter = new BackgroundPainter(true);
        super.addPainter(this.backgroundPainter);
        this.titleLayout = new GlimpseLayout(this, "Title");
        this.axisLayoutXY = new GlimpseAxisLayout2D(this, "Center", new Axis2D(this.centerAxisX, this.centerAxisY));
        this.titlePainter = this.createTitlePainter();
        if (this.titlePainter != null) {
            this.titleLayout.addPainter(this.titlePainter);
        }
        this.setTitleFont(this.getDefaultTitleFont(), false);
        this.plotBackgroundPainter = new BackgroundPainter(false);
        this.axisLayoutXY.addPainter(this.plotBackgroundPainter);
        this.mouseListenerXY = this.createAxisMouseListenerXY();
        this.attachAxisMouseListener(this.axisLayoutXY, this.mouseListenerXY);
    }

    protected void initializeLookAndFeel() {
        this.setLookAndFeel(new DefaultLookAndFeel());
    }

    protected List<AxisInfo> getSortedAxes(Collection<AxisInfo> unsorted) {
        ArrayList<AxisInfo> sortedList = new ArrayList<AxisInfo>();
        sortedList.addAll(unsorted);
        Collections.sort(sortedList, new Comparator<AxisInfo>(){

            @Override
            public int compare(AxisInfo axis0, AxisInfo axis1) {
                return axis0.getOrder() - axis1.getOrder();
            }
        });
        return sortedList;
    }

    @Override
    public void setLookAndFeel(LookAndFeel laf) {
        super.setLookAndFeel(laf);
        this.laf = laf;
        this.setPlotBackgroundColor(laf.getColor(AbstractLookAndFeel.PLOT_BACKGROUND_COLOR));
        this.setBackgroundColor(laf.getColor(AbstractLookAndFeel.FRAME_BACKGROUND_COLOR));
        this.setTitleFont(laf.getFont(AbstractLookAndFeel.TITLE_FONT), false);
    }

    public void setPlotBackgroundColor(float[] color) {
        this.plotBackgroundPainter.setColor(color);
    }

    public void setBackgroundColor(float[] color) {
        this.backgroundPainter.setColor(color);
    }

    @Override
    public void addPainter(GlimpsePainter painter) {
        this.axisLayoutXY.addPainter(painter);
    }

    @Override
    public void removePainter(GlimpsePainter painter) {
        this.axisLayoutXY.addPainter(painter);
    }

    public GlimpseAxisLayout2D getLayoutCenter() {
        return this.axisLayoutXY;
    }

    public Axis1D getAxis(String label) {
        AxisInfo info = this.axesAll.get(label);
        return info == null ? null : info.getAxis();
    }

    public AxisInfo getAxisInfo(String label) {
        return this.axesAll.get(label);
    }

    public Axis2D getAxis2D(String axisX, String axisY) {
        return new Axis2D(this.getAxis(axisX), this.getAxis(axisY));
    }

    public Axis1D getCenterAxisX() {
        return this.centerAxisX;
    }

    public Axis1D getCenterAxisY() {
        return this.centerAxisY;
    }

    public Axis2D getCenterAxis() {
        return new Axis2D(this.centerAxisX, this.centerAxisY);
    }

    public void setTitleFont(Font font) {
        this.titlePainter.setFont(font, true);
    }

    public void setTitleFont(Font font, boolean antialias) {
        this.titlePainter.setFont(font, antialias);
    }

    public void setTitle(String title) {
        this.title = title;
        this.titlePainter.setText(title);
        this.setShowTitle(true);
    }

    public void setShowTitle(boolean show) {
        this.showTitle = show;
        this.updatePainterLayout();
        this.validate();
    }

    public void setTitleHeight(int height) {
        this.titleSpacing = height;
        this.updatePainterLayout();
        this.validate();
    }

    public void setBorderSize(int size) {
        this.outerBorder = size;
        this.updatePainterLayout();
        this.validate();
    }

    public void validate() {
        this.centerAxisX.validate();
        this.centerAxisY.validate();
        for (AxisInfo axis : this.axesTopX.values()) {
            axis.getAxis().validate();
        }
        for (AxisInfo axis : this.axesBottomX.values()) {
            axis.getAxis().validate();
        }
        for (AxisInfo axis : this.axesLeftY.values()) {
            axis.getAxis().validate();
        }
        for (AxisInfo axis : this.axesRightY.values()) {
            axis.getAxis().validate();
        }
    }

    public void deleteAxisRight(String name) {
        AxisInfo info = this.axesRightY.get(name);
        if (info == null) {
            return;
        }
        this.removeLayout(info.getLayout());
        this.axesRightY.remove(name);
        this.axesAll.remove(name);
        this.updatePainterLayout();
        this.validate();
    }

    public void deleteAxisLeft(String name) {
        AxisInfo info = this.axesLeftY.get(name);
        if (info == null) {
            return;
        }
        this.removeLayout(info.getLayout());
        this.axesLeftY.remove(name);
        this.axesAll.remove(name);
        this.updatePainterLayout();
        this.validate();
    }

    public void deleteAxisTop(String name) {
        AxisInfo info = this.axesTopX.get(name);
        if (info == null) {
            return;
        }
        this.removeLayout(info.getLayout());
        this.axesTopX.remove(name);
        this.axesAll.remove(name);
        this.updatePainterLayout();
        this.validate();
    }

    public void deleteAxisBottom(String name) {
        AxisInfo info = this.axesBottomX.get(name);
        if (info == null) {
            return;
        }
        this.removeLayout(info.getLayout());
        this.axesBottomX.remove(name);
        this.axesAll.remove(name);
        this.updatePainterLayout();
        this.validate();
    }

    public AxisInfo createAxisRight(String name, Axis1D axis, AxisMouseListener mouseListener) {
        int order = 0;
        int size = this.defaultAxisSizeRight();
        GridAxisLabelHandler tickHandler = this.createTickHandlerRight();
        NumericAxisPainter painter = this.createAxisPainterRight(tickHandler);
        painter.setFont(this.laf.getFont(AbstractLookAndFeel.AXIS_FONT), false);
        GlimpseAxisLayoutY layout = new GlimpseAxisLayoutY(this, name, axis);
        painter.setFont(this.getDefaultAxisFont());
        this.attachAxisMouseListener(layout, mouseListener);
        AxisInfo info = new AxisInfo(name, AxisOrientation.Right, axis, mouseListener, tickHandler, painter, layout, order, size);
        this.axesRightY.put(name, info);
        this.axesAll.put(name, info);
        layout.setLookAndFeel(this.laf);
        this.updatePainterLayout();
        this.validate();
        return info;
    }

    public AxisInfo createAxisRight(String name) {
        Axis1D axis = this.createAxisRight();
        return this.createAxisRight(name, axis, this.createAxisMouseListenerRight());
    }

    public AxisInfo createAxisLeft(String name, Axis1D axis, AxisMouseListener mouseListener) {
        int order = 0;
        int size = this.defaultAxisSizeLeft();
        GridAxisLabelHandler tickHandler = this.createTickHandlerLeft();
        NumericAxisPainter painter = this.createAxisPainterLeft(tickHandler);
        painter.setFont(this.laf.getFont(AbstractLookAndFeel.AXIS_FONT), false);
        GlimpseAxisLayoutY layout = new GlimpseAxisLayoutY(this, name, axis);
        painter.setFont(this.getDefaultAxisFont());
        this.attachAxisMouseListener(layout, mouseListener);
        AxisInfo info = new AxisInfo(name, AxisOrientation.Left, axis, mouseListener, tickHandler, painter, layout, order, size);
        this.axesLeftY.put(name, info);
        this.axesAll.put(name, info);
        layout.setLookAndFeel(this.laf);
        this.updatePainterLayout();
        this.validate();
        return info;
    }

    public AxisInfo createAxisLeft(String name) {
        Axis1D axis = this.createAxisLeft();
        return this.createAxisLeft(name, axis, this.createAxisMouseListenerLeft());
    }

    public AxisInfo createAxisTop(String name, Axis1D axis, AxisMouseListener mouseListener) {
        int order = 0;
        int size = this.defaultAxisSizeTop();
        GridAxisLabelHandler tickHandler = this.createTickHandlerTop();
        NumericAxisPainter painter = this.createAxisPainterTop(tickHandler);
        painter.setFont(this.laf.getFont(AbstractLookAndFeel.AXIS_FONT), false);
        GlimpseAxisLayoutX layout = new GlimpseAxisLayoutX(this, name, axis);
        painter.setFont(this.getDefaultAxisFont());
        this.attachAxisMouseListener(layout, mouseListener);
        AxisInfo info = new AxisInfo(name, AxisOrientation.Top, axis, mouseListener, tickHandler, painter, layout, order, size);
        this.axesTopX.put(name, info);
        this.axesAll.put(name, info);
        layout.setLookAndFeel(this.laf);
        this.updatePainterLayout();
        this.validate();
        return info;
    }

    public AxisInfo createAxisTop(String name) {
        Axis1D axis = this.createAxisTop();
        return this.createAxisTop(name, axis, this.createAxisMouseListenerTop());
    }

    public AxisInfo createAxisBottom(String name, Axis1D axis, AxisMouseListener mouseListener) {
        int order = 0;
        int size = this.defaultAxisSizeBottom();
        GridAxisLabelHandler tickHandler = this.createTickHandlerBottom();
        NumericAxisPainter painter = this.createAxisPainterBottom(tickHandler);
        painter.setFont(this.laf.getFont(AbstractLookAndFeel.AXIS_FONT), false);
        GlimpseAxisLayoutX layout = new GlimpseAxisLayoutX(this, name, axis);
        painter.setFont(this.getDefaultAxisFont());
        this.attachAxisMouseListener(layout, mouseListener);
        AxisInfo info = new AxisInfo(name, AxisOrientation.Bottom, axis, mouseListener, tickHandler, painter, layout, order, size);
        this.axesBottomX.put(name, info);
        this.axesAll.put(name, info);
        layout.setLookAndFeel(this.laf);
        this.updatePainterLayout();
        this.validate();
        return info;
    }

    protected void attachAxisMouseListener(Mouseable mouseable, AxisMouseListener listener) {
        mouseable.addGlimpseMouseListener(listener);
        mouseable.addGlimpseMouseMotionListener(listener);
        mouseable.addGlimpseMouseWheelListener(listener);
    }

    public AxisInfo createAxisBottom(String name) {
        Axis1D axis = this.createAxisBottom();
        return this.createAxisBottom(name, axis, this.createAxisMouseListenerBottom());
    }

    protected Axis1D createAxisRight() {
        return new Axis1D();
    }

    protected Axis1D createAxisLeft() {
        return new Axis1D();
    }

    protected Axis1D createAxisTop() {
        return new Axis1D();
    }

    protected Axis1D createAxisBottom() {
        return new Axis1D();
    }

    protected NumericAxisPainter createAxisPainterRight(AxisLabelHandler tickHandler) {
        return new NumericRightYAxisPainter(tickHandler);
    }

    protected NumericAxisPainter createAxisPainterTop(AxisLabelHandler tickHandler) {
        return new NumericTopXAxisPainter(tickHandler);
    }

    protected NumericAxisPainter createAxisPainterBottom(AxisLabelHandler tickHandler) {
        return new NumericXAxisPainter(tickHandler);
    }

    protected NumericAxisPainter createAxisPainterLeft(AxisLabelHandler tickHandler) {
        return new NumericYAxisPainter(tickHandler);
    }

    protected GridAxisLabelHandler createTickHandlerRight() {
        return new GridAxisLabelHandler();
    }

    protected GridAxisLabelHandler createTickHandlerTop() {
        return new GridAxisLabelHandler();
    }

    protected GridAxisLabelHandler createTickHandlerBottom() {
        return new GridAxisLabelHandler();
    }

    protected GridAxisLabelHandler createTickHandlerLeft() {
        return new GridAxisLabelHandler();
    }

    protected AxisMouseListener createAxisMouseListenerRight() {
        return new AxisMouseListener1D();
    }

    protected AxisMouseListener createAxisMouseListenerTop() {
        return new AxisMouseListener1D();
    }

    protected AxisMouseListener createAxisMouseListenerBottom() {
        return new AxisMouseListener1D();
    }

    protected AxisMouseListener createAxisMouseListenerLeft() {
        return new AxisMouseListener1D();
    }

    protected int defaultAxisSizeRight() {
        return 50;
    }

    protected int defaultAxisSizeTop() {
        return 35;
    }

    protected int defaultAxisSizeBottom() {
        return 40;
    }

    protected int defaultAxisSizeLeft() {
        return 50;
    }

    protected AxisMouseListener createAxisMouseListenerXY() {
        return new AxisMouseListener2D();
    }

    protected SimpleTextPainter createTitlePainter() {
        SimpleTextPainter painter = new SimpleTextPainter();
        painter.setHorizontalPosition(SimpleTextPainter.HorizontalPosition.Center);
        painter.setVerticalPosition(SimpleTextPainter.VerticalPosition.Center);
        painter.setColor(GlimpseColor.getBlack());
        return painter;
    }

    public Font getDefaultAxisFont() {
        return FontUtils.getDefaultPlain(11.0f);
    }

    public Font getDefaultTitleFont() {
        return FontUtils.getDefaultBold(14.0f);
    }

    protected boolean isTitleVisible() {
        return this.showTitle && this.title != null && !this.title.isEmpty();
    }

    protected int getTopInset() {
        if (this.isTitleVisible()) {
            return 0;
        }
        return this.outerBorder;
    }

    @Override
    public String toString() {
        return MultiAxisPlot2D.class.getSimpleName();
    }

    public class AxisInfo {
        protected String id;
        protected int order;
        protected Axis1D axis;
        protected AxisMouseListener mouseListener;
        protected GridAxisLabelHandler tickHandler;
        protected GlimpseLayout layout;
        protected int size;
        protected AxisOrientation orient;
        protected DelegatePainter backgroundDelegate;
        protected DelegatePainter axisDelegate;
        protected NumericAxisPainter axisPainter;
        protected DelegatePainter foregroundDelegate;

        public AxisInfo(String id, AxisOrientation orient, Axis1D axis, AxisMouseListener mouseListener, GridAxisLabelHandler tickHandler, NumericAxisPainter painter, GlimpseLayout layout, int order, int size) {
            this.id = id;
            this.axis = axis;
            this.mouseListener = mouseListener;
            this.tickHandler = tickHandler;
            this.axisPainter = painter;
            this.layout = layout;
            this.order = order;
            this.size = size;
            this.orient = orient;
            this.backgroundDelegate = new DelegatePainter();
            this.backgroundDelegate.setVisible(false);
            this.axisDelegate = new DelegatePainter();
            this.foregroundDelegate = new DelegatePainter();
            this.foregroundDelegate.setVisible(false);
            this.layout.addPainter(this.backgroundDelegate);
            this.layout.addPainter(this.axisDelegate);
            this.layout.addPainter(this.foregroundDelegate);
            this.axisDelegate.addPainter(this.axisPainter);
        }

        public String getId() {
            return this.id;
        }

        public Axis1D getAxis() {
            return this.axis;
        }

        public AxisMouseListener getMouseListener() {
            return this.mouseListener;
        }

        public GridAxisLabelHandler getTickHandler() {
            return this.tickHandler;
        }

        public NumericAxisPainter getAxisPainter() {
            return this.axisPainter;
        }

        public GlimpseLayout getLayout() {
            return this.layout;
        }

        public AxisOrientation getOrientation() {
            return this.orient;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
            MultiAxisPlot2D.this.updatePainterLayout();
            MultiAxisPlot2D.this.validate();
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
            MultiAxisPlot2D.this.updatePainterLayout();
            MultiAxisPlot2D.this.validate();
        }

        public void addBackgroundPainter(GlimpsePainter painter) {
            this.backgroundDelegate.addPainter(painter);
            this.backgroundDelegate.setVisible(true);
        }

        public void removeBackgroundPainter(GlimpsePainter painter) {
            this.backgroundDelegate.removePainter(painter);
        }

        public void addForegroundPainter(GlimpsePainter painter) {
            this.foregroundDelegate.addPainter(painter);
            this.foregroundDelegate.setVisible(true);
        }

        public void removeForegroundPainter(GlimpsePainter painter) {
            this.foregroundDelegate.removePainter(painter);
        }

        public void setAxisPainter(NumericAxisPainter newPainter) {
            this.axisDelegate.removePainter(this.axisPainter);
            this.axisPainter = newPainter;
            this.axisDelegate.addPainter(this.axisPainter);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 + result * (this.id == null ? 0 : this.id.hashCode());
            result = 31 + result * (this.orient == null ? 0 : this.orient.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AxisInfo other = (AxisInfo)obj;
            if (this.id == null) {
                return other.id == null;
            }
            if (!this.id.equals(other.id)) {
                return false;
            }
            return this.orient == other.orient;
        }
    }

    protected static enum AxisOrientation {
        Top,
        Bottom,
        Left,
        Right;

    }
}

