/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.treemap;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;

public class NestedTreeMap {
    private Node root;
    private Int2ObjectMap<Node> map;
    private int versionId = 0;

    public int getRoot() {
        return this.root.id;
    }

    public void setRoot(int id) {
        this.root = new Node(id);
        this.map = new Int2ObjectOpenHashMap();
        this.map.put(id, (Object)this.root);
        ++this.versionId;
    }

    public int getLevel(int id) {
        int level = 0;
        Node node = this.getNode(id);
        while (node != this.root) {
            ++level;
            node = node.parent;
        }
        return level;
    }

    public void addChild(int parentId, int childId, double size) {
        this.addChild(parentId, childId, size, null);
    }

    public void addChild(int parentId, int childId, double size, String title) {
        Node child = new Node(childId);
        child.size = size;
        child.title = title;
        this.map.put(childId, (Object)child);
        this.getNode(parentId).addChild(child);
        ++this.versionId;
    }

    public void setSize(int id, double size) {
        this.getNode((int)id).size = size;
        ++this.versionId;
    }

    public double getSize(int id) {
        return this.getNode((int)id).size;
    }

    public void setTitle(int id, String title) {
        this.getNode((int)id).title = title;
        ++this.versionId;
    }

    public String getTitle(int id) {
        return this.getNode((int)id).title;
    }

    public void setText(int id, String text) {
        this.getNode((int)id).text = text;
        ++this.versionId;
    }

    public String getText(int id) {
        return this.getNode((int)id).text;
    }

    public int getParent(int childId) {
        if (childId == this.root.id) {
            return childId;
        }
        return this.getNode((int)childId).parent.id;
    }

    public void removeChild(int childId) {
        Node child = (Node)this.map.get(childId);
        this.removeAllDescendants(child.parent, child);
        ++this.versionId;
    }

    protected void removeAllDescendants(Node parent, Node child) {
        if (parent.removeChild(child)) {
            this.map.remove(child.id);
            if (child.children != null) {
                for (Node grandchild : child.children) {
                    this.removeAllDescendants(child, grandchild);
                }
            }
        }
    }

    public boolean isLeaf(int id) {
        return this.getNode((int)id).children == null;
    }

    public int[] getChildren(int id) {
        if (this.isLeaf(id)) {
            return new int[0];
        }
        Node node = this.getNode(id);
        List<Node> children = node.children;
        int[] array = new int[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            array[i] = children.get((int)i).id;
        }
        return array;
    }

    public double[] getSizesOfChildren(int id) {
        if (this.isLeaf(id)) {
            return new double[0];
        }
        Node node = this.getNode(id);
        List<Node> children = node.children;
        double[] sizes = new double[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            sizes[i] = children.get((int)i).size;
        }
        return sizes;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    protected Node getNode(int id) {
        return (Node)this.map.get(id);
    }

    int getVersion() {
        return this.versionId;
    }

    private static class Node {
        int id;
        List<Node> children;
        Node parent;
        double size;
        String title;
        String text;

        public Node(int id) {
            this.id = id;
        }

        public void addChild(Node child) {
            if (this.children == null) {
                this.children = new ArrayList<Node>();
            }
            this.children.add(child);
            child.parent = this;
        }

        public boolean removeChild(Node child) {
            if (this.children != null) {
                boolean removed = this.children.remove(child);
                if (this.children.isEmpty()) {
                    this.children = null;
                }
                child.parent = null;
                return removed;
            }
            return false;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Node) {
                return ((Node)obj).id == this.id;
            }
            return false;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

