/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.shape;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.painter.base.GlimpseDataPainter2D;
import com.metsci.glimpse.support.polygon.Polygon;
import com.metsci.glimpse.support.polygon.PolygonTessellator;
import com.metsci.glimpse.support.polygon.SimpleVertexAccumulator;
import com.metsci.glimpse.util.logging.LoggerUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class PolygonPainterSimple
extends GlimpseDataPainter2D {
    protected ReentrantLock lock = new ReentrantLock();
    protected PolygonTessellator tessellator;
    private long startTime = Long.MIN_VALUE;
    private long endTime = Long.MAX_VALUE;
    private int nextPolyId = 0;
    private NavigableSet<PolyStruct> polyByTime = new TreeSet<PolyStruct>(new TimeComparator());
    private ArrayList<PolyStruct> polyById = new ArrayList();
    private boolean allShown = false;

    public PolygonPainterSimple() {
        this.tessellator = new PolygonTessellator(this.glu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowOn(int[] ids) {
        this.lock.lock();
        try {
            for (int i = 0; i < ids.length; ++i) {
                this.polyById.get((int)ids[i]).show = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowOff(int[] ids) {
        this.lock.lock();
        try {
            for (int i = 0; i < ids.length; ++i) {
                this.polyById.get((int)ids[i]).show = false;
            }
            this.allShown = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowAll() {
        this.lock.lock();
        try {
            if (this.allShown) {
                return;
            }
            for (int i = 0; i < this.polyById.size(); ++i) {
                this.polyById.get((int)i).show = true;
            }
            this.allShown = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowNone() {
        this.lock.lock();
        try {
            for (int i = 0; i < this.polyById.size(); ++i) {
                this.polyById.get((int)i).show = false;
            }
            this.allShown = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeRangeToDraw(long startTime, long endTime) {
        this.lock.lock();
        try {
            this.startTime = startTime;
            this.endTime = endTime;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowAllTimeRange() {
        this.lock.lock();
        try {
            this.startTime = Long.MIN_VALUE;
            this.endTime = Long.MAX_VALUE;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.lock();
        try {
            this.polyByTime.clear();
            this.polyById.clear();
            this.nextPolyId = 0;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addPolygon(long time, float[] dataX, float[] dataY, float[] color) {
        this.lock.lock();
        try {
            Polygon polygon = PolygonPainterSimple.buildPolygon(dataX, dataY);
            SimpleVertexAccumulator accumulator = new SimpleVertexAccumulator();
            this.tessellator.tessellate(polygon, accumulator);
            PolyStruct p = new PolyStruct();
            p.data = accumulator.getVertices();
            p.color = color;
            p.show = true;
            p.time = time;
            p.id = this.nextPolyId;
            this.polyByTime.add(p);
            this.polyById.add(p);
        }
        catch (PolygonTessellator.TessellationException e) {
            LoggerUtils.logWarning((Logger)logger, (String)"Problem tessellating polygon.", (Throwable)e, (Object[])new Object[0]);
        }
        finally {
            this.lock.unlock();
        }
        return this.nextPolyId++;
    }

    protected static Polygon buildPolygon(float[] geometryX, float[] geometryY) {
        Polygon p = new Polygon();
        int size = Math.min(geometryX.length, geometryY.length);
        double[] geometry = new double[size * 2];
        for (int i = 0; i < size; ++i) {
            geometry[2 * i] = geometryX[i];
            geometry[2 * i + 1] = geometryY[i];
        }
        Polygon.Loop.LoopBuilder b = new Polygon.Loop.LoopBuilder();
        b.addVertices(geometry, size);
        p.add(b.complete(Polygon.Interior.onRight));
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTo(GL gl, GlimpseBounds bounds, Axis2D axis) {
        this.lock.lock();
        try {
            gl.glBegin(4);
            try {
                for (PolyStruct p : this.polyByTime) {
                    float[] color = p.color;
                    float[] data = p.data;
                    if (!p.show || p.time > this.endTime || p.time < this.startTime) continue;
                    gl.glColor4f(color[0], color[1], color[2], color[3]);
                    for (int i = 0; i < data.length; i += 2) {
                        gl.glVertex2f(data[i], data[i + 1]);
                    }
                }
            }
            finally {
                gl.glEnd();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void dispose(GLContext context) {
    }

    private static class TimeComparator
    implements Comparator<PolyStruct>,
    Serializable {
        private TimeComparator() {
        }

        @Override
        public int compare(PolyStruct p1, PolyStruct p2) {
            if (p1 == p2) {
                return 0;
            }
            if (p1.time < p2.time) {
                return -1;
            }
            if (p1.time > p2.time) {
                return 1;
            }
            if (p1.id < p2.id) {
                return -1;
            }
            if (p1.id > p2.id) {
                return 1;
            }
            throw new RuntimeException();
        }
    }

    private static class PolyStruct {
        long id;
        long time;
        float[] data;
        float[] color;
        boolean show;

        private PolyStruct() {
        }
    }
}

