/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.shape;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.gl.attribute.GLFloatBuffer;
import com.metsci.glimpse.gl.attribute.GLFloatBuffer2D;
import com.metsci.glimpse.gl.attribute.GLVertexAttribute;
import com.metsci.glimpse.painter.base.GlimpseDataPainter2D;
import com.metsci.glimpse.painter.shape.DynamicPointSetPainter;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.util.primitives.FloatsArray;
import com.metsci.glimpse.util.primitives.IntsArray;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL;

public class DynamicLineSetPainter
extends GlimpseDataPainter2D {
    protected static final double GROWTH_FACTOR = 1.3;
    protected static final float DEFAULT_LINE_WIDTH = 2.0f;
    protected static final int DEFAULT_INITIAL_SIZE = 2000;
    protected static final float[] DEFAULT_COLOR = GlimpseColor.getBlack();
    protected boolean lineStipple = false;
    protected int stippleFactor = 1;
    protected short stipplePattern = (short)255;
    protected float lineWidth = 2.0f;
    protected int bufferSize;
    protected GLFloatBuffer colorBuffer;
    protected GLFloatBuffer2D pointBuffer;
    protected Map<Object, Integer> idMap;
    protected Map<Integer, Object> indexMap;
    protected ReentrantLock lock;
    protected IntsArray searchResults;

    public DynamicLineSetPainter() {
        this(2000);
    }

    public DynamicLineSetPainter(int initialSize) {
        this.bufferSize = initialSize;
        this.lock = new ReentrantLock();
        this.idMap = new LinkedHashMap<Object, Integer>();
        this.indexMap = new LinkedHashMap<Integer, Object>();
        this.pointBuffer = new GLFloatBuffer2D(initialSize * 2, false);
        this.colorBuffer = new GLFloatBuffer(initialSize * 2, 4);
        this.searchResults = new IntsArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDotted(boolean dotted) {
        this.lock.lock();
        try {
            this.lineStipple = dotted;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDotted(int stippleFactor, short stipplePattern) {
        this.lock.lock();
        try {
            this.lineStipple = true;
            this.stippleFactor = stippleFactor;
            this.stipplePattern = stipplePattern;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineWidth(float size) {
        this.lock.lock();
        try {
            this.lineWidth = size;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLines(BulkLineAccumulator accumulator) {
        this.lock.lock();
        try {
            int newPoints = accumulator.getSize();
            int currentSize = this.idMap.size();
            if (this.bufferSize < currentSize + newPoints) {
                this.growBuffers(currentSize + newPoints);
            }
            this.mutatePositions(accumulator);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putColors(DynamicPointSetPainter.BulkColorAccumulator accumulator) {
        this.lock.lock();
        try {
            this.mutateColors(accumulator);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void putLine(Object id, float posX1, float posY1, float posX2, float posY2) {
        this.putLine(id, posX1, posY1, posX2, posY2, DEFAULT_COLOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLine(Object id, float posX1, float posY1, float posX2, float posY2, float[] color) {
        this.lock.lock();
        try {
            int currentSize = this.idMap.size();
            if (this.bufferSize < currentSize + 1) {
                this.growBuffers(currentSize + 1);
            }
            int index = this.getIndex(id, true);
            this.mutatePosition(index, posX1, posY1, posX2, posY2);
            this.mutateColor(index, color);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putColor(Object id, float[] color) {
        this.lock.lock();
        try {
            int index = this.getIndex(id, false);
            this.mutateColor(index, color);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeLine(Object id) {
        throw new UnsupportedOperationException("removeLine() is not yet supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTo(GL gl, GlimpseBounds bounds, Axis2D axis) {
        this.lock.lock();
        try {
            this.colorBuffer.bind(GLVertexAttribute.ATTRIB_COLOR_4D, gl);
            this.pointBuffer.bind(GLVertexAttribute.ATTRIB_POSITION_2D, gl);
            try {
                if (this.lineStipple) {
                    gl.glEnable(2852);
                    gl.glLineStipple(this.stippleFactor, this.stipplePattern);
                }
                gl.glLineWidth(this.lineWidth);
                gl.glDrawArrays(1, 0, this.idMap.size() * 2);
            }
            finally {
                this.colorBuffer.unbind(gl);
                this.pointBuffer.unbind(gl);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void mutateColor(final int index, final float[] color) {
        this.colorBuffer.mutate(new GLFloatBuffer.Mutator(){

            @Override
            public void mutate(FloatBuffer data, int length) {
                data.position(index * 2 * length);
                for (int i = 0; i < 2; ++i) {
                    data.put(color[0]);
                    data.put(color[1]);
                    data.put(color[2]);
                    data.put(color.length == 4 ? color[3] : 1.0f);
                }
            }
        });
    }

    protected void mutatePosition(final int index, final float posX1, final float posY1, final float posX2, final float posY2) {
        this.pointBuffer.mutateIndexed(new GLFloatBuffer2D.IndexedMutator(){

            @Override
            public int getUpdateIndex() {
                return index;
            }

            @Override
            public void mutate(FloatBuffer data, int length) {
                data.position(index * 2 * length);
                data.put(posX1);
                data.put(posY1);
                data.put(posX2);
                data.put(posY2);
            }
        });
    }

    protected int getIndexArray(List<Object> ids, int[] listIndex) {
        int size;
        int minIndex = size = ids.size();
        for (int i = 0; i < size; ++i) {
            int index;
            listIndex[i] = index = this.getIndex(ids.get(i), true);
            if (minIndex <= index) continue;
            minIndex = index;
        }
        return minIndex;
    }

    protected void mutatePositions(BulkLineAccumulator accumulator) {
        List<Object> ids = accumulator.getIds();
        final float[] v = accumulator.getVertices();
        final int stride = accumulator.getStride();
        final int size = accumulator.getSize();
        final int[] indexList = new int[size];
        final int minIndex = this.getIndexArray(ids, indexList);
        this.pointBuffer.mutateIndexed(new GLFloatBuffer2D.IndexedMutator(){

            @Override
            public int getUpdateIndex() {
                return minIndex * 2;
            }

            @Override
            public void mutate(FloatBuffer data, int length) {
                for (int i = 0; i < size; ++i) {
                    data.position(indexList[i] * 2 * length);
                    data.put(v, i * stride, 2 * length);
                }
            }
        });
        this.colorBuffer.mutate(new GLFloatBuffer.Mutator(){

            @Override
            public void mutate(FloatBuffer data, int length) {
                for (int i = 0; i < size; ++i) {
                    data.position(indexList[i] * 2 * length);
                    for (int j = 0; j < 2; ++j) {
                        data.put(v, i * stride + 4, length);
                    }
                }
            }
        });
    }

    protected void mutateColors(DynamicPointSetPainter.BulkColorAccumulator accumulator) {
        List<Object> ids = accumulator.getIds();
        final float[] v = accumulator.getVertices();
        final int stride = accumulator.getStride();
        final int size = accumulator.getSize();
        final int[] indexList = new int[size];
        this.getIndexArray(ids, indexList);
        this.colorBuffer.mutate(new GLFloatBuffer.Mutator(){

            @Override
            public void mutate(FloatBuffer data, int length) {
                for (int i = 0; i < size; ++i) {
                    data.position(indexList[i] * 2 * length);
                    for (int j = 0; j < 2; ++j) {
                        data.put(v, i * stride, length);
                    }
                }
            }
        });
    }

    protected int getIndex(Object id, boolean grow) {
        Integer index = this.idMap.get(id);
        if (index == null) {
            if (grow) {
                index = this.idMap.size();
                this.idMap.put(id, index);
                this.indexMap.put(index, id);
            } else {
                throw new IllegalArgumentException(String.format("Id %s does not exist.", id));
            }
        }
        return index;
    }

    protected void growBuffers(int minSize) {
        this.bufferSize = Math.max((int)((double)this.bufferSize * 1.3), minSize);
        this.pointBuffer.ensureCapacity(this.bufferSize * 2);
        this.colorBuffer.ensureCapacity(this.bufferSize * 2);
    }

    public static class BulkLineAccumulator {
        List<Object> ids = new ArrayList<Object>();
        FloatsArray v = new FloatsArray();

        public void add(Object id, float x1, float y1, float x2, float y2, float[] color) {
            if (color.length != 3 && color.length != 4) {
                throw new IllegalArgumentException("Color array must be size 3 or 4");
            }
            if (this.v.n == this.v.a.length) {
                this.v.ensureCapacity((int)Math.max((double)(this.v.n + this.getStride()), (double)this.v.n * 1.3));
            }
            this.ids.add(id);
            this.v.append(x1);
            this.v.append(y1);
            this.v.append(x2);
            this.v.append(y2);
            this.v.append(color);
            if (color.length == 3) {
                this.v.append(1.0f);
            }
        }

        public void add(Object id, float x1, float y1, float x2, float y2) {
            this.add(id, x1, y1, x2, y2, DEFAULT_COLOR);
        }

        int getStride() {
            return 8;
        }

        List<Object> getIds() {
            return this.ids;
        }

        float[] getVertices() {
            return this.v.a;
        }

        int getSize() {
            return this.ids.size();
        }
    }
}

