/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.plot;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.painter.base.GlimpseDataPainter2D;
import com.metsci.glimpse.support.colormap.ColorMap;
import com.sun.opengl.util.BufferUtil;
import java.nio.FloatBuffer;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class XYLinePainter
extends GlimpseDataPainter2D {
    protected float[] lineColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    protected float lineThickness = 1.0f;
    protected boolean showLines = true;
    protected float pointSize = 6.0f;
    protected boolean showPoints = true;
    protected int stippleFactor = 1;
    protected short stipplePattern = (short)255;
    protected boolean stippleOn = false;
    protected int dataSize = 0;
    protected int[] colorHandle = null;
    protected FloatBuffer colorBuffer = null;
    protected boolean useColorDevice = false;
    protected boolean useColorHost = false;
    protected int[] bufferHandle = null;
    protected FloatBuffer dataBuffer = null;
    protected ReentrantLock dataBufferLock = new ReentrantLock();
    protected volatile boolean newData = false;
    protected volatile boolean bufferInitialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataAndColor(double[] dataX, double[] dataY, double[] dataZ, ColorMap scale) {
        this.dataBufferLock.lock();
        try {
            this.setData(dataX, dataY);
            this.setColor(dataZ, scale);
        }
        finally {
            this.dataBufferLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataAndColor(float[] dataX, float[] dataY, float[] dataZ, ColorMap scale) {
        this.dataBufferLock.lock();
        try {
            this.setData(dataX, dataY);
            this.setColor(dataZ, scale);
        }
        finally {
            this.dataBufferLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(float[] dataX, float[] dataY) {
        this.dataBufferLock.lock();
        try {
            this.dataSize = Math.min(dataX.length, dataY.length);
            if (this.dataBuffer == null || this.dataBuffer.rewind().capacity() < this.dataSize * 2) {
                this.dataBuffer = BufferUtil.newFloatBuffer((int)(this.dataSize * 2));
            }
            for (int i = 0; i < this.dataSize; ++i) {
                this.dataBuffer.put(dataX[i]).put(dataY[i]);
            }
            this.newData = true;
        }
        finally {
            this.dataBufferLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(double[] dataX, double[] dataY) {
        this.dataBufferLock.lock();
        try {
            this.dataSize = Math.min(dataX.length, dataY.length);
            if (this.dataBuffer == null || this.dataBuffer.rewind().capacity() < this.dataSize * 2) {
                this.dataBuffer = BufferUtil.newFloatBuffer((int)(this.dataSize * 2));
            }
            for (int i = 0; i < this.dataSize; ++i) {
                this.dataBuffer.put((float)dataX[i]).put((float)dataY[i]);
            }
            this.newData = true;
        }
        finally {
            this.dataBufferLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColor(float[] dataZ, ColorMap scale) {
        this.dataBufferLock.lock();
        try {
            if (this.colorBuffer == null || this.colorBuffer.rewind().capacity() < this.dataSize * 4) {
                this.colorBuffer = BufferUtil.newFloatBuffer((int)(this.dataSize * 4));
            }
            float[] color = new float[4];
            for (int i = 0; i < this.dataSize; ++i) {
                scale.toColor(dataZ[i], color);
                this.colorBuffer.put(color[0]).put(color[1]).put(color[2]).put(color[3]);
            }
            this.useColorHost = true;
        }
        finally {
            this.dataBufferLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColor(double[] dataZ, ColorMap scale) {
        this.dataBufferLock.lock();
        try {
            if (this.colorBuffer == null || this.colorBuffer.rewind().capacity() < this.dataSize * 4) {
                this.colorBuffer = BufferUtil.newFloatBuffer((int)(this.dataSize * 4));
            }
            float[] color = new float[4];
            for (int i = 0; i < this.dataSize; ++i) {
                scale.toColor((float)dataZ[i], color);
                this.colorBuffer.put(color[0]).put(color[1]).put(color[2]).put(color[3]);
            }
            this.useColorHost = true;
        }
        finally {
            this.dataBufferLock.unlock();
        }
    }

    public void setLineStipple(boolean activate) {
        this.stippleOn = activate;
    }

    public void setLineStipple(int stippleFactor, short stipplePattern) {
        this.stippleFactor = stippleFactor;
        this.stipplePattern = stipplePattern;
    }

    public void setLineThickness(float lineThickness) {
        this.lineThickness = lineThickness;
    }

    public void setLineColor(float[] rgba) {
        this.lineColor = rgba;
    }

    public void setLineColor(float r, float g, float b, float a) {
        this.lineColor[0] = r;
        this.lineColor[1] = g;
        this.lineColor[2] = b;
        this.lineColor[3] = a;
    }

    public void setPointSize(float pointSize) {
        this.pointSize = pointSize;
    }

    public void showPoints(boolean show) {
        this.showPoints = show;
    }

    public void showLines(boolean show) {
        this.showLines = show;
    }

    @Override
    public void dispose(GLContext context) {
        if (this.bufferInitialized) {
            context.getGL().glDeleteBuffers(1, this.colorHandle, 0);
            context.getGL().glDeleteBuffers(1, this.bufferHandle, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTo(GL gl, GlimpseBounds bounds, Axis2D axis) {
        if (this.dataSize == 0) {
            return;
        }
        if (!this.bufferInitialized) {
            this.bufferHandle = new int[1];
            gl.glGenBuffers(1, this.bufferHandle, 0);
            this.colorHandle = new int[1];
            gl.glGenBuffers(1, this.colorHandle, 0);
            this.bufferInitialized = true;
        }
        if (this.newData) {
            this.dataBufferLock.lock();
            try {
                gl.glPixelStorei(3317, 1);
                gl.glBindBuffer(34962, this.bufferHandle[0]);
                gl.glBufferData(34962, this.dataSize * 2 * 4, this.dataBuffer.rewind(), 35048);
                this.glHandleError(gl);
                this.useColorDevice = this.useColorHost;
                if (this.useColorDevice) {
                    gl.glBindBuffer(34962, this.colorHandle[0]);
                    gl.glBufferData(34962, this.dataSize * 4 * 4, this.colorBuffer.rewind(), 35048);
                    this.glHandleError(gl);
                }
                this.newData = false;
            }
            finally {
                this.dataBufferLock.unlock();
            }
        }
        gl.glShadeModel(7424);
        if (this.useColorDevice) {
            gl.glBindBuffer(34962, this.colorHandle[0]);
            gl.glColorPointer(4, 5126, 0, 0L);
            gl.glEnableClientState(32886);
        }
        gl.glBindBuffer(34962, this.bufferHandle[0]);
        gl.glVertexPointer(2, 5126, 0, 0L);
        gl.glEnableClientState(32884);
        gl.glColor4fv(this.lineColor, 0);
        gl.glLineWidth(this.lineThickness);
        if (this.showLines) {
            if (this.stippleOn) {
                gl.glEnable(2852);
                gl.glLineStipple(this.stippleFactor, this.stipplePattern);
            }
            gl.glDrawArrays(3, 0, this.dataSize);
        }
        if (this.showPoints) {
            gl.glPointSize(this.pointSize);
            gl.glDrawArrays(0, 0, this.dataSize);
        }
    }
}

