/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.info;

import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.painter.info.SimpleTextPainter;
import com.metsci.glimpse.support.color.GlimpseColor;

public class FpsPainter
extends SimpleTextPainter {
    private static float[] normColor = new float[]{0.5f, 1.0f, 0.5f, 1.0f};
    private static float[] warnColor = new float[]{1.0f, 0.5f, 0.5f, 1.0f};
    private float lastFpsEstimate = -1.0f;
    private long timeOfLastCounterReset = -1L;
    private float frameCount = 0.0f;

    public FpsPainter() {
        this.setFont(12, true, false);
        this.setBackgroundColor(GlimpseColor.getGray(0.5f));
        this.setPaintBackground(true);
    }

    private final void tickTock() {
        this.frameCount += 1.0f;
        long currentTime = System.currentTimeMillis();
        if (this.timeOfLastCounterReset < 0L) {
            this.timeOfLastCounterReset = System.currentTimeMillis();
            this.frameCount = 0.0f;
        } else if (currentTime - this.timeOfLastCounterReset >= 1000L || this.frameCount >= 10.0f) {
            this.lastFpsEstimate = this.frameCount / (float)(currentTime - this.timeOfLastCounterReset) * 1000.0f;
            this.timeOfLastCounterReset = currentTime;
            this.frameCount = 0.0f;
        }
    }

    @Override
    protected void paintTo(GlimpseContext context, GlimpseBounds bounds) {
        this.tickTock();
        String text = "FPS: Measuring...";
        this.setColor(GlimpseColor.getBlack());
        if (this.lastFpsEstimate > 0.0f) {
            text = String.format("FPS:%4.0f", Float.valueOf(this.lastFpsEstimate));
            if (this.lastFpsEstimate > 30.0f) {
                this.setColor(normColor);
            } else {
                this.setColor(warnColor);
            }
        }
        this.setText(text);
        super.paintTo(context, bounds);
    }
}

