/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.decoration;

import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.painter.base.GlimpsePainterImpl;
import javax.media.opengl.GL;

public class BorderPainter
extends GlimpsePainterImpl {
    protected float[] borderColor = new float[]{0.5f, 0.5f, 0.5f, 1.0f};
    protected float lineWidth = 1.0f;
    protected int stippleFactor = 1;
    protected short stipplePattern = (short)255;
    protected boolean stippleOn = false;

    public BorderPainter setDotted(boolean dotted) {
        this.stippleOn = dotted;
        return this;
    }

    public BorderPainter setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }

    public BorderPainter setColor(float[] rgba) {
        this.borderColor = rgba;
        return this;
    }

    public BorderPainter setColor(float r, float g, float b, float a) {
        this.borderColor[0] = r;
        this.borderColor[1] = g;
        this.borderColor[2] = b;
        this.borderColor[3] = a;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintTo(GlimpseContext context, GlimpseBounds bounds) {
        GL gl = context.getGL();
        int x = bounds.getX();
        int y = bounds.getY();
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho((double)x - 0.5, (double)((float)(x + width) + 0.5f), (double)y - 0.5, (double)((float)(y + height) + 0.5f), -1.0, 1.0);
        gl.glBlendFunc(770, 771);
        gl.glEnable(3042);
        gl.glLineWidth(this.lineWidth);
        gl.glColor4fv(this.borderColor, 0);
        if (this.stippleOn) {
            gl.glEnable(2852);
            gl.glLineStipple(this.stippleFactor, this.stipplePattern);
        }
        gl.glBegin(2);
        try {
            gl.glVertex2f((float)x, (float)y);
            gl.glVertex2f((float)(x + width), (float)y);
            gl.glVertex2f((float)(x + width), (float)(y + height));
            gl.glVertex2f((float)x, (float)(y + height));
        }
        finally {
            gl.glEnd();
        }
    }
}

