/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.layout;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.AxisNotSetException;
import com.metsci.glimpse.axis.factory.AxisFactory1D;
import com.metsci.glimpse.axis.factory.AxisFactory2D;
import com.metsci.glimpse.axis.factory.DefaultAxisFactory1D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.layout.GlimpseLayoutCache;

public abstract class GlimpseAxisLayout1D
extends GlimpseLayout {
    protected GlimpseLayoutCache<Axis1D> cache;
    protected Axis1D axis;
    protected boolean defaultSet = false;
    protected AxisFactory1D factory;

    public GlimpseAxisLayout1D(GlimpseLayout parent, String name, Axis1D axis) {
        super(parent, name);
        this.axis = axis;
        this.cache = new GlimpseLayoutCache();
    }

    public GlimpseAxisLayout1D(GlimpseLayout parent, Axis1D axis) {
        this(parent, null, axis);
    }

    public GlimpseAxisLayout1D(String name, Axis1D axis) {
        this(null, name, axis);
    }

    public GlimpseAxisLayout1D(Axis1D axis) {
        this(null, null, axis);
    }

    public GlimpseAxisLayout1D(GlimpseLayout parent, String name) {
        this(parent, name, null);
    }

    public GlimpseAxisLayout1D(GlimpseLayout parent) {
        this(parent, null, null);
    }

    @Override
    protected void preLayout(GlimpseTargetStack stack, GlimpseBounds bounds) {
        Axis1D contextAxis = this.getAxis(stack);
        if (contextAxis == null) {
            throw new AxisNotSetException(stack);
        }
        contextAxis.setSizePixels(this.getSize(bounds));
    }

    public abstract boolean isHorizontal();

    protected abstract Axis1D getAxis(Axis2D var1);

    protected abstract int getSize(GlimpseBounds var1);

    public void clearCache() {
        this.cache.clear();
        for (GlimpseTarget target : this.getTargetChildren()) {
            GlimpseAxisLayout1D layout;
            if (!(target instanceof GlimpseAxisLayout1D) || (layout = (GlimpseAxisLayout1D)target).isAxisSet()) continue;
            layout.clearCache();
        }
    }

    public void setAxis(Axis1D axis) {
        this.clearCache();
        this.defaultSet = false;
        this.axis = axis;
    }

    public void setAxis(GlimpseTargetStack stack, Axis1D axis) {
        this.cache.setValue(stack, axis);
    }

    public void setAxis(GlimpseContext context, Axis1D axis) {
        this.cache.setValue(context, axis);
    }

    public AxisFactory1D getAxisFactory() {
        return this.factory;
    }

    public void setAxisFactory(AxisFactory1D factory) {
        this.factory = factory;
    }

    public boolean isAxisSet() {
        return this.axis != null;
    }

    public boolean isAxisFactorySet() {
        return this.factory != null;
    }

    public Axis1D getAxis() {
        return this.axis;
    }

    public Axis1D getAxis(GlimpseContext context) {
        return this.getAxis(context.getTargetStack());
    }

    public Axis1D getAxis(GlimpseTargetStack stack) {
        AxisFactory1D factory = this.getAxisFactory0(stack);
        for (GlimpseTarget target : stack.getTargetList()) {
            GlimpseLayout layout;
            if (target instanceof GlimpseAxisLayout2D) {
                layout = (GlimpseAxisLayout2D)target;
                if (!((GlimpseAxisLayout2D)layout).isAxisSet()) continue;
                return this.getCachedAxis0(this.getAxis(((GlimpseAxisLayout2D)layout).getAxis()), factory, stack);
            }
            if (!(target instanceof GlimpseAxisLayout1D) || !((GlimpseAxisLayout1D)(layout = (GlimpseAxisLayout1D)target)).isAxisSet()) continue;
            return this.getCachedAxis0(((GlimpseAxisLayout1D)layout).getAxis(), factory, stack);
        }
        return null;
    }

    protected AxisFactory1D getAxisFactory0(GlimpseTargetStack stack) {
        for (GlimpseTarget target : stack.getTargetList()) {
            GlimpseLayout layout;
            if (target instanceof GlimpseAxisLayout2D) {
                layout = (GlimpseAxisLayout2D)target;
                if (!((GlimpseAxisLayout2D)layout).isAxisFactorySet()) continue;
                AxisFactory2D factory = ((GlimpseAxisLayout2D)layout).getAxisFactory();
                return this.isHorizontal() ? factory.getAxisFactoryX(stack) : factory.getAxisFactoryY(stack);
            }
            if (!(target instanceof GlimpseAxisLayout1D) || !((GlimpseAxisLayout1D)(layout = (GlimpseAxisLayout1D)target)).isAxisFactorySet()) continue;
            return ((GlimpseAxisLayout1D)layout).getAxisFactory();
        }
        return null;
    }

    protected Axis1D getCachedAxis0(Axis1D parent_axis, AxisFactory1D factory, GlimpseTargetStack stack) {
        Axis1D newAxis = null;
        if (!this.defaultSet) {
            this.defaultSet = true;
            newAxis = parent_axis;
            this.cache.setValue(stack, newAxis);
        } else {
            newAxis = this.cache.getValueNoBoundsCheck(stack);
            if (newAxis == null) {
                newAxis = factory != null ? factory.newAxis(stack, parent_axis) : DefaultAxisFactory1D.newAxis(parent_axis);
                newAxis.setSizePixels(this.getSize(stack.getBounds()));
                this.cache.setValue(stack, newAxis);
            }
        }
        return newAxis;
    }

    protected Axis1D getCachedAxis0(Axis1D parent_axis, AxisFactory1D factory, GlimpseContext context) {
        return this.getCachedAxis0(parent_axis, factory, context.getTargetStack());
    }
}

