/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.gl.shader;

import com.metsci.glimpse.gl.shader.ShaderArg;
import com.metsci.glimpse.util.logging.LoggerUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.opengl.GL;

public class GLShaderUtils {
    public static void logShaderArgs(Logger logger, Level level, ShaderArg[] args, String prefix) {
        if (args == null || args.length == 0) {
            logger.log(level, "%sNo shader args.", prefix);
            return;
        }
        LoggerUtils.log((Logger)logger, (Level)level, (String)"%s%d shader args found.", (Object[])new Object[]{prefix, args.length});
        for (ShaderArg arg : args) {
            LoggerUtils.log((Logger)logger, (Level)level, (String)"%sShader args found: %s", (Object[])new Object[]{prefix, arg.toString()});
        }
    }

    public static boolean logGLProgramInfoLog(Logger logger, GL gl, int glProgramHandle, String name) {
        int[] status = new int[1];
        gl.glGetProgramiv(glProgramHandle, 35714, status, 0);
        if (status[0] != 1) {
            logger.warning("LINKING FAILED: " + name + " did not link properly.");
            logger.warning(GLShaderUtils.getGLProgramInfoLog(gl, glProgramHandle));
            return false;
        }
        logger.info(name + " linked.");
        return true;
    }

    public static boolean logGLShaderInfoLog(Logger logger, GL gl, int glShaderHandle, String name) {
        int[] status = new int[1];
        gl.glGetShaderiv(glShaderHandle, 35713, status, 0);
        if (status[0] != 1) {
            logger.warning("COMPILATION FAILED: " + name + " did not compile.");
            logger.warning(GLShaderUtils.logGLShaderInfoLog(gl, glShaderHandle));
            return false;
        }
        logger.info("Shader " + name + " compiled.");
        return true;
    }

    public static String logGLShaderInfoLog(GL gl, int glShaderHandle) {
        int[] logLength = new int[1];
        gl.glGetShaderiv(glShaderHandle, 35716, logLength, 0);
        int[] log1 = new int[logLength[0]];
        byte[] log2 = new byte[logLength[0]];
        gl.glGetShaderInfoLog(glShaderHandle, logLength[0], log1, 0, log2, 0);
        char[] msg = new char[log2.length];
        for (int i = 0; i < log2.length; ++i) {
            msg[i] = (char)log2[i];
        }
        return String.valueOf(msg);
    }

    public static String getGLProgramInfoLog(GL gl, int glProgramHandle) {
        int[] logLength = new int[1];
        gl.glGetProgramiv(glProgramHandle, 35716, logLength, 0);
        int[] log1 = new int[logLength[0]];
        byte[] log2 = new byte[logLength[0]];
        gl.glGetProgramInfoLog(glProgramHandle, logLength[0], log1, 0, log2, 0);
        char[] msg = new char[log2.length];
        for (int i = 0; i < log2.length; ++i) {
            msg[i] = (char)log2[i];
        }
        return String.valueOf(msg);
    }
}

