/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.gl.attribute;

import com.metsci.glimpse.gl.attribute.GLVertexAttribute;
import com.metsci.glimpse.gl.util.GLUtils;
import com.sun.opengl.util.BufferUtil;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL;

public abstract class GLBuffer {
    protected ReentrantLock lock = new ReentrantLock();
    protected int elementSize;
    protected int glHandle;
    protected boolean dirty;
    protected ByteBuffer data;
    protected GLVertexAttribute boundType;
    protected int boundGenericIndex;

    public GLBuffer(int length, int elementSize) {
        if (elementSize > 4 || elementSize < 1) {
            throw new IllegalArgumentException("length must be 1, 2, 3, or 4");
        }
        this.glHandle = -1;
        this.dirty = true;
        this.elementSize = elementSize;
        this.data = this.createBuffer(length, elementSize);
        this.boundType = null;
        this.boundGenericIndex = -1;
    }

    public abstract int getGlType();

    public abstract int getBytesPerElement();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int length) {
        this.lock.lock();
        try {
            if (length > this.getNumVertices()) {
                ByteBuffer newByteBuffer = this.createBuffer(length, this.elementSize);
                this.data.rewind();
                newByteBuffer.put(this.data).rewind();
                this.data = newByteBuffer;
                this.dirty = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public ByteBuffer createBuffer(int length, int elementSize) {
        return BufferUtil.newByteBuffer((int)(length * elementSize * this.getBytesPerElement()));
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void makeDirty() {
        this.dirty = true;
    }

    public int getNumVertices() {
        return this.data.limit() / this.elementSize / this.getBytesPerElement();
    }

    public int getMaxVertices() {
        return this.data.capacity() / this.elementSize / this.getBytesPerElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(GLVertexAttribute type, GL gl) {
        this.lock.lock();
        try {
            this.prepare(gl);
            type.bind(gl, 0, 0);
            this.boundType = type;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(int genericIndex, GL gl) {
        this.lock.lock();
        try {
            this.prepare(gl);
            gl.glEnableVertexAttribArray(genericIndex);
            gl.glVertexAttribPointer(genericIndex, this.elementSize, this.getGlType(), false, 0, 0L);
            this.boundGenericIndex = genericIndex;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(GL gl) {
        this.lock.lock();
        try {
            if (this.boundType != null) {
                this.boundType.unbind(gl);
                this.boundType = null;
            } else if (this.boundGenericIndex > 0) {
                GLVertexAttribute.unbind(gl, this.boundGenericIndex);
                this.boundGenericIndex = -1;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepare(GL gl) {
        this.lock.lock();
        try {
            if (this.glHandle == -1) {
                this.glHandle = GLUtils.genBuffer(gl);
                this.makeDirty();
            }
            gl.glBindBuffer(34962, this.glHandle);
            if (this.isDirty()) {
                gl.glBufferData(34962, this.data.limit(), this.data.rewind(), 35044);
                this.dirty = false;
            }
            boolean bl = !this.isDirty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispose(GL gl) {
        this.lock.lock();
        try {
            if (this.glHandle != -1) {
                gl.glDeleteBuffers(1, new int[]{this.glHandle}, 0);
                this.glHandle = -1;
            }
        }
        finally {
            this.lock.unlock();
        }
        this.lock = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutate(Mutator mutator) {
        this.lock.lock();
        try {
            mutator.mutate(this.data, this.elementSize);
            this.data.flip();
            this.makeDirty();
        }
        finally {
            this.lock.unlock();
        }
    }

    public static interface Mutator {
        public void mutate(ByteBuffer var1, int var2);
    }
}

