/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.gl;

import com.metsci.glimpse.gl.GLSimpleListener;
import java.awt.Rectangle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class GLSimpleFboListenerEntry {
    private static final Logger logger = Logger.getLogger(GLSimpleFboListenerEntry.class.getName());
    private final GLSimpleListener listener;
    private boolean needsInit;
    private boolean needsReshape;
    private boolean warnOnException;

    public GLSimpleFboListenerEntry(GLSimpleListener listener) {
        this.listener = listener;
        this.needsInit = true;
        this.needsReshape = true;
        this.warnOnException = true;
    }

    public void requireReshape() {
        this.needsReshape = true;
    }

    public void draw(GLContext context, Rectangle bounds) {
        block4: {
            try {
                if (this.needsInit) {
                    this.listener.init(context);
                    this.needsInit = false;
                }
                if (this.needsReshape) {
                    GL gl = context.getGL();
                    gl.glViewport(0, 0, bounds.width, bounds.height);
                    this.listener.reshape(context, 0, 0, bounds.width, bounds.height);
                    this.needsReshape = false;
                }
                this.listener.display(context);
                this.warnOnException = true;
            }
            catch (Exception e) {
                if (!this.warnOnException) break block4;
                logger.log(Level.WARNING, "Listener failed to draw", e);
                this.warnOnException = false;
            }
        }
    }

    public void dispose(GLContext context) {
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof GLSimpleFboListenerEntry) {
            GLSimpleFboListenerEntry l = (GLSimpleFboListenerEntry)o;
            return this.listener.equals(l.listener);
        }
        return false;
    }
}

