/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.event.mouse;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.event.mouse.ModifierKey;
import com.metsci.glimpse.event.mouse.MouseButton;
import com.metsci.glimpse.layout.GlimpseAxisLayout1D;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;
import java.util.EnumSet;

public class GlimpseMouseEvent {
    protected GlimpseTargetStack stack;
    protected EnumSet<ModifierKey> modifiers;
    protected EnumSet<MouseButton> buttons;
    protected int wheelIncrement;
    protected int clickCount;
    protected int x;
    protected int y;

    public GlimpseMouseEvent(GlimpseTargetStack stack, int x, int y) {
        this(stack, x, y, 0);
    }

    public GlimpseMouseEvent(GlimpseTargetStack stack, int x, int y, int wheelIncrement) {
        this(stack, EnumSet.noneOf(ModifierKey.class), EnumSet.noneOf(MouseButton.class), x, y, wheelIncrement, 0);
    }

    public GlimpseMouseEvent(GlimpseTargetStack stack, EnumSet<ModifierKey> modifiers, EnumSet<MouseButton> buttons, int x, int y) {
        this(stack, modifiers, buttons, x, y, 0, 0);
    }

    public GlimpseMouseEvent(GlimpseTargetStack stack, EnumSet<ModifierKey> modifiers, EnumSet<MouseButton> buttons, int x, int y, int wheelIncrement, int clickCount) {
        this.stack = stack;
        this.modifiers = modifiers;
        this.buttons = buttons;
        this.x = x;
        this.y = y;
        this.wheelIncrement = wheelIncrement;
        this.clickCount = clickCount;
    }

    public EnumSet<ModifierKey> getModifiers() {
        return this.modifiers;
    }

    public EnumSet<MouseButton> getButtons() {
        return this.buttons;
    }

    public boolean isKeyDown(ModifierKey modifier) {
        return this.modifiers.contains((Object)modifier);
    }

    public boolean isButtonDown(MouseButton button) {
        return this.buttons.contains((Object)button);
    }

    public boolean isAnyButtonDown() {
        return !this.buttons.isEmpty();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWheelIncrement() {
        return this.wheelIncrement;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public GlimpseTargetStack getTargetStack() {
        return this.stack;
    }

    public Axis1D getAxis1D() {
        GlimpseTargetStack stack = this.getTargetStack();
        GlimpseTarget target = stack.getTarget();
        if (target instanceof GlimpseAxisLayout1D) {
            GlimpseAxisLayout1D layout = (GlimpseAxisLayout1D)target;
            return layout.getAxis(stack);
        }
        return null;
    }

    public Axis2D getAxis2D() {
        GlimpseTargetStack stack = this.getTargetStack();
        GlimpseTarget target = stack.getTarget();
        if (target instanceof GlimpseAxisLayout2D) {
            GlimpseAxisLayout2D layout = (GlimpseAxisLayout2D)target;
            return layout.getAxis(stack);
        }
        return null;
    }

    public String toString() {
        return String.format("x: %d y: %d wheel: %d click: %d button: %s modifier: %s", this.x, this.y, this.wheelIncrement, this.clickCount, this.buttons, this.modifiers);
    }
}

